/*
 *  Copyright 2020-2022 Yuntu Microelectronics Co., Ltd.
 *  All rights reserved.
 * 
 *  SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file pin_mux.c
 * @brief 
 * 
 */
 #include "pin_mux.h"

pin_settings_config_t g_pin_mux_InitConfigArr0[NUM_OF_CONFIGURED_PINS0] = {
    /* LED0 */ 
    {
        .base = PCTRLE,
        .pinPortIdx = 16U,
        .pullConfig = PCTRL_INTERNAL_PULL_NOT_ENABLED,
        .driveSelect = PCTRL_LOW_DRIVE_STRENGTH,
        .passiveFilter = false,
        .mux = PCTRL_MUX_AS_GPIO,
        .intConfig = PCTRL_DMA_INT_DISABLED,
        .clearIntFlag = true,
        .gpioBase = GPIOE,
        .digitalFilter = false,
        .direction = GPIO_OUTPUT_DIRECTION,
        .initValue = 0,
    },
    /* TLV320AIC3104 reset pin */
    {
        .base = PCTRLB,
        .pinPortIdx = 27U,
        .pullConfig = PCTRL_INTERNAL_PULL_NOT_ENABLED,
        .driveSelect = PCTRL_LOW_DRIVE_STRENGTH,
        .passiveFilter = false,
        .mux = PCTRL_MUX_AS_GPIO,
        .intConfig = PCTRL_DMA_INT_DISABLED,
        .clearIntFlag = true,
        .gpioBase = GPIOB,
        .digitalFilter = false,
        .direction = GPIO_OUTPUT_DIRECTION,
        .initValue = 1,
    },
    /* sai0_sync */
    {
        .base = PCTRLC,
        .pinPortIdx = 13U,
        .pullConfig = PCTRL_INTERNAL_PULL_UP_ENABLED,
        .driveSelect = PCTRL_LOW_DRIVE_STRENGTH,
        .passiveFilter = false,
        .mux = PCTRL_MUX_ALT7,
        .intConfig = PCTRL_DMA_INT_DISABLED,
        .clearIntFlag = false,
        .gpioBase = GPIOC,
        .digitalFilter = false,
    },
    /* sai0_mclk */
    {
        .base = PCTRLB,
        .pinPortIdx = 3U,
        .pullConfig = PCTRL_INTERNAL_PULL_UP_ENABLED,
        .driveSelect = PCTRL_LOW_DRIVE_STRENGTH,
        .passiveFilter = false,
        .mux = PCTRL_MUX_ALT12,
        .intConfig = PCTRL_DMA_INT_DISABLED,
        .clearIntFlag = false,
        .gpioBase = GPIOB,
        .digitalFilter = false,
    },
    /* sai0_bit_clock */
    {
        .base = PCTRLC,
        .pinPortIdx = 12U,
        .pullConfig = PCTRL_INTERNAL_PULL_UP_ENABLED,
        .driveSelect = PCTRL_LOW_DRIVE_STRENGTH,
        .passiveFilter = false,
        .mux = PCTRL_MUX_ALT7,
        .intConfig = PCTRL_DMA_INT_DISABLED,
        .clearIntFlag = false,
        .gpioBase = GPIOC,
        .digitalFilter = false,
    },
    /* sai0_data0 */
    {
        .base = PCTRLB,
        .pinPortIdx = 2U,
        .pullConfig = PCTRL_INTERNAL_PULL_UP_ENABLED,
        .driveSelect = PCTRL_LOW_DRIVE_STRENGTH,
        .passiveFilter = false,
        .mux = PCTRL_MUX_ALT7,
        .intConfig = PCTRL_DMA_INT_DISABLED,
        .clearIntFlag = false,
        .gpioBase = GPIOB,
        .digitalFilter = false,
    },    
    /* SAI_I2C_SCL <--> PTB21 */ 
    {
        .base = PCTRLB,
        .pinPortIdx = 21U,
        .pullConfig = PCTRL_INTERNAL_PULL_UP_ENABLED,
        .driveSelect = PCTRL_LOW_DRIVE_STRENGTH,
        .passiveFilter = false,
        .mux = PCTRL_MUX_ALT5,
        .intConfig = PCTRL_DMA_INT_DISABLED,
        .clearIntFlag = false,
        .gpioBase = GPIOB,
        .digitalFilter = false,
    },
    /* SAI_I2C_SDA <--> PTB20 */ 
    {
        .base = PCTRLB,
        .pinPortIdx = 20U,
        .pullConfig = PCTRL_INTERNAL_PULL_UP_ENABLED,
        .driveSelect = PCTRL_LOW_DRIVE_STRENGTH,
        .passiveFilter = false,
        .mux = PCTRL_MUX_ALT5,
        .intConfig = PCTRL_DMA_INT_DISABLED,
        .clearIntFlag = false,
        .gpioBase = GPIOB,
        .digitalFilter = false,
    },
};
/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
