/*
 *  Copyright 2020-2022 Yuntu Microelectronics Co., Ltd.
 *  All rights reserved.
 * 
 *  SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file peripherals_config.h
 * @brief 
 * 
 */
 
#ifndef __PERIPHERALS_CONFIG_H__
#define __PERIPHERALS_CONFIG_H__

/*******************************************************************************
 * Included files 
 ******************************************************************************/
#include "linflexd_uart_driver.h"
#include "sai_driver.h"
#include "i2c_driver.h"

/*******************************************************************************
 * Definitions 
 ******************************************************************************/
/* ----linflexd---- */
extern const linflexd_uart_user_config_t LINFlexDUartInitConfig;
extern linflexd_uart_state_t LINFLexDState;

/* ----sai---- */
extern sai_user_config_t saiTxInitConfig0;
extern sai_state_t SaiTxState;

/* ----i2c---- */
extern i2c_master_state_t I2CMasterState;
extern i2c_master_user_config_t I2CMasterInitConfig;

#endif /* __PERIPHERALS_CONFIG_H__ */
