/*
 *  Copyright 2020-2022 Yuntu Microelectronics Co., Ltd.
 *  All rights reserved.
 * 
 *  SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file peripherals_config.c
 * @brief 
 * 
 */
 
/*******************************************************************************
 * Included files
 ******************************************************************************/
#include "peripherals_config.h"

/* sai perpheral config */
linflexd_uart_state_t LINFLexDState;
const linflexd_uart_user_config_t LINFlexDUartInitConfig = {
    .baudRate = 115200,
    .parityCheck = false,
    .stopBitsCount = LINFlexD_UART_ONE_STOP_BIT,
    .wordLength = LINFlexD_UART_8_BITS,
    .txTransferType = LINFlexD_UART_USING_INTERRUPTS,
    .rxTransferType = LINFlexD_UART_USING_INTERRUPTS
};

/* sai perpheral config */ 
sai_state_t SaiTxState;
sai_user_config_t saiTxInitConfig0 = {
    .SyncMode        = SAI_ASYNC,
    .MasterClkSrc    = SAI_PLL_CLK,
    .MckClkFreq      = 12288000,
    .BitClkNegPolar  = true,
    .BitClkInternal  = true,
    .BitClkFreq      = 44100*16*2,
    .FrameSize       = 0x02,
    .SyncWidth       = 0x10,
    .SyncEarly       = true,
    .SyncNegPolar    = false,
    .SyncInternal    = true,
    .SyncNCONT       = false,
    .MsbFirst        = true,
    .Word0Width      = 0x10,
    .WordNWidth      = 0x10,
    .FirstBitIndex   = 0x10,
    .ChannelEnable   = 0x01,
    .MaskMode        = SAI_MASK_TRISTATE,
    .RunErrorReport  = false,
    .SyncErrorReport = false,
    .FrameStartReport= false,
    .MuxMode         = SAI_MUX_DISABLED,
    .TransferType    = SAI_INTERRUPT,
    .DmaChannel      = {0},
    .ElementSize     = 0x02,
    .ChannelCount    = 0x04,
    .callback        = NULL,
};

/* i2c perpheral config */ 
i2c_master_state_t I2CMasterState;
i2c_master_user_config_t I2CMasterInitConfig = {
    .slaveAddress = 0x18,
    .is10bitAddr = false,
    .operatingMode = I2C_STANDARD_MODE,
    .baudRate = 100000UL,
    .transferType = I2C_USING_INTERRUPTS,
    .masterCallback = NULL,
    .callbackParam = NULL
};
