/*
 *  Copyright 2020-2022 Yuntu Microelectronics Co., Ltd.
 *  All rights reserved.
 * 
 *  SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file clock_config.h
 * @brief 
 * 
 */

#ifndef CLOCK_CONFIG_H
#define CLOCK_CONFIG_H

#include "clock.h"
#include <stdbool.h>
#include <stdint.h>


/*! @brief Count of user configuration structures */
#define CLOCK_MANAGER_CONFIG_CNT                           1U /*!< Count of user configuration */

/*! @brief Count of user Callbacks structures */
#define CLOCK_MANAGER_CALLBACK_CNT                         0U /*!< Count of user Callbacks */


/*! @brief Count of peripheral clock user configuration 0*/
#define NUM_OF_PERIPHERAL_CLOCKS_0                         5U /* Count of peripheral clock user configurations. */

/*! @brief User configuration structure 0*/
extern clock_manager_user_config_t clockMan1_InitConfig0;

/*! @brief Array of User callbacks */
/* The tool do not support generate Callbacks configuration. It's always empty. */
extern clock_manager_callback_user_config_t *g_clockManCallbacksArr[];

/*! @brief User peripheral configuration structure 0*/
extern peripheral_clock_config_t peripheralClockConfig0[NUM_OF_PERIPHERAL_CLOCKS_0];

/*! @brief Array of pointers to User configuration structures */
extern clock_manager_user_config_t const *g_clockManConfigsArr[CLOCK_MANAGER_CONFIG_CNT];

#endif /* CLOCK_CONFIG_H */
