/*
 *  Copyright 2020-2022 Yuntu Microelectronics Co., Ltd.
 *  All rights reserved.
 * 
 *  SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file clock_config.c
 * @brief 
 * 
 */
 
#include "clock_config.h"

/* *************************************************************************
* Configuration structure for peripheral clock configuration 0
* ************************************************************************* */
/*! @brief peripheral clock configuration 0 */
peripheral_clock_config_t peripheralClockConfig0[NUM_OF_PERIPHERAL_CLOCKS_0] = {
    {
        .clkName = LINFlexD1_CLK,
        .clkSrc = CLK_SRC_FIRC,
        .clkGate = true,
        .divider = DIV_BY_1,
    },
    {
        .clkName = SAI0_CLK,
        .clkSrc = CLK_SRC_PLL,
        .clkGate = true,
        .divider = DIV_BY_2,
    },
    {
        .clkName = DMA_CLK,
        .clkSrc = CLK_SRC_FIRC,
        .clkGate = true,
        .divider = DIV_BY_1,
    },
    {
        .clkName = GPIO_CLK,
        .clkSrc = CLK_SRC_PLL,
        .clkGate = true,
        .divider = DIV_BY_1,
    },
    {
        .clkName = I2C1_CLK,
        .clkSrc = CLK_SRC_FIRC,
        .clkGate = true,
        .divider = DIV_BY_1,
    },
};

const scu_config_t scuConfig = {
    .fircEnable = true,
    .sircPowerDownEnable = false,
    .sircStandbyEnable = false,
    .sircDeepSleepEnable = false,
#ifdef USE_FIRC_AS_SYSTEM_CLOCK
    .sysClkSrc = SCU_SYSTEM_CLOCK_SRC_FIRC,
#else
    .sysClkSrc = SCU_SYSTEM_CLOCK_SRC_PLL,
#endif
    .fxoscConfig =
        {
            .enable = true,
            .bypassMode = false,
            .gainSelection = 5,
            .frequency = FEATURE_SCU_FXOSC_FREQ
        },
    .pllConfig =
        {
#ifdef USE_FIRC_AS_SYSTEM_CLOCK
            .enable = false,
#else
            .enable = true,
#endif
            .pllRefClock = SCU_PLL_REF_FXOSC_CLK,
            .pllFeedBackDiv = 50,
            .pllRefClkDiv = 3
        },
    .sysDiv = SCU_SYS_CLK_DIV_BY_1,
    .fastBusDiv = SCU_SYS_CLK_DIV_BY_2,
    .slowBusDiv = SCU_SYS_CLK_DIV_BY_2,
    .flashDiv = SCU_SYS_CLK_DIV_BY_2,
    .clockOutConfig =
        {
            .enable = false,
            .source = SCU_CLKOUT_SEL_SIRC_CLK,
            .divider = 10
        }
};

/* *************************************************************************
* Configuration structure for Clock Configuration 0
* ************************************************************************* */
/*! @brief User Configuration structure clock_managerCfg_0 */
clock_manager_user_config_t clockMan1_InitConfig0 = {
    .scuConfigPtr = &scuConfig,
    .ipcConfig =
        {
            .peripheralClocks = peripheralClockConfig0,
            .count = NUM_OF_PERIPHERAL_CLOCKS_0,
        },
};

/*! @brief Array of pointers to User configuration structures */
clock_manager_user_config_t const *g_clockManConfigsArr[] = {
    &clockMan1_InitConfig0
};

/*! @brief Array of pointers to User defined Callbacks configuration structures */
/* The tool do not support generate Callbacks configuration. It's always empty. */
clock_manager_callback_user_config_t *g_clockManCallbacksArr[] = {(void *) 0};


