#include "boot_jump.h"
#include "YTM32B1ME0.h"

volatile uint32_t appEntry, appStack;

#if 1
void shutdown_drivers(void)
{
}
#else
extern void shutdown_drivers(void);
#endif

void System_Reset(void)
{
	SystemSoftwareReset();
}

void bootup_application(uint32_t appEntry, uint32_t appStack)
{
	static void (*jump_to_application)(void);
	static uint32_t stack_pointer; 
	jump_to_application = (void (*)(void))appEntry;
	stack_pointer = appStack;
	
	SCB->VTOR = APP_IMAGE_START;

	#if 0
	__asm volatile ("MSR msp, %0\n" : : "r" (stack_pointer) : "sp");
	__asm volatile ("MSR psp, %0\n" : : "r" (stack_pointer) : "sp");
	#else
	__set_MSP(stack_pointer);
	__set_PSP(stack_pointer);
	#endif

	jump_to_application();
}

 void JumpTo_Application(void)
 {
	shutdown_drivers();
 	appStack = *(volatile uint32_t*) APP_IMAGE_START;  /* setup app jump */
	appEntry = *(volatile uint32_t*)(APP_IMAGE_START + 4);
	bootup_application(appEntry,appStack);

	while(1){};
}



