# CAN示例代码

## 项目名称：Can_Demo

---

## 功能描述

本示例使用四个通道。逻辑通道和物理通道的关系如下：

| 通道名称  | CanHwChannel |   FIFO   |
| :------: | :----------: | :------: |
|   CAN0   |  FLEXCAN_0   | Enhanced |
|   CAN1   |  FLEXCAN_1   | Enhanced |
|   CAN2   |  FLEXCAN_6   |  Legacy  |
|   CAN3   |  FLEXCAN_7   |  Legacy  |

> 本示例中使用的通道逻辑名称对应EVB板上的丝印。

本示例包括四个演示阶段：

* **CAN1_TX_CAN0**: Can_Demo 使用 CAN1 向 CAN0 发送消息
* **CAN0_TX_CAN1**: Can_Demo 使用 CAN0 向 CAN1 发送消息
* **CAN3_TX_CAN2**: Can_Demo 使用 CAN3 向 CAN2 发送消息
* **CAN2_TX_CAN3**: Can_Demo 使用 CAN2 向 CAN3 发送消息

### CAN1_TX_CAN0

此阶段演示以下内容：

* 使用 **mailbox** 接收 **CANFD** **标准** ID，采用 **中断** 接收 `0x101`
* 使用 **mailbox** 接收 **CANFD** **扩展** ID，采用 **中断** 接收 `0x00000102`
* 使用 **mailbox** 接收 **CAN2.0** **标准** ID，采用 **轮询** 接收`0x103`
* 使用 **mailbox** 接收 **CAN2.0** **扩展** ID，采用 **轮询** 接收`0x0000104`
* 使用 **Enhanced FIFO** 并配置 **标准** ID 过滤器，设置从 `0x105` 到 `0x10A` 的三种过滤模式

在此阶段，源代码将按以下ID顺序发送CAN消息：

`0x101`, `0x00000102`, `0x103`, `0x00000104`, `0x105`, `0x106`, `0x107`, `0x108`, `0x109`, `0x10A`

CAN总线上实际的消息顺序将是：

`0x101`, `0x00000102`, `0x00000104`, `0x103`, `0x105`, `0x106`, `0x107`, `0x108`, `0x109`, `0x10A`

Callback函数认为接收到ID顺序为：

`0x101`, `0x00000102`, `0x00000104`, `0x105`, `0x106`, `0x107`, `0x108`, `0x109`, `0x10A`, `0x103`

> 1. ID为 `0x00000104` 的消息将先于 `0x103` 发送，因为它具有更高的优先级。
> 2. 消息 `0x103` 将通过轮询接收，且轮询间隔为500ms，所以其是最后到达的数据。

### CAN0_TX_CAN1

此阶段演示以下内容：

* 使用 Enhanced FIFO 并配置扩展 ID 过滤器，设置三种过滤模式

在此阶段，源代码将按以下ID顺序发送CAN消息：

`0x00000201`, `0x00000202`, `0x00000203`, `0x00000204`, `0x00000205`, `0x00000206`, `0x00000207`, `0x00000208`, `0x00000208`, `0x00000209`, `0x0000020A`, `0x20A`

CAN总线上实际的消息顺序将是：

`0x00000201`, `0x00000202`, `0x00000203`, `0x00000204`, `0x00000205`, `0x00000206`, `0x00000207`, `0x00000208`, `0x00000208`, `0x00000209`, `0x0000020A`, `0x20A`

Callback函数认为接收到ID顺序为：

`0x00000201`, `0x00000202`, `0x00000203`, `0x00000204`, `0x00000205`, `0x00000206`, `0x00000207`, `0x00000208`, `0x00000208`, `0x00000209`, `0x20A`

> 1. ID为 `0x0000020A` 的消息将被忽略，因为没有过滤器匹配此ID。

### CAN3_TX_CAN2

此阶段演示以下内容：

* 使用 Legacy FIFO 并以 `CAN_LEGACY_RX_FIFO_FILTER_FORMAT_A` 作为 mailbox 过滤模式

在此阶段，源代码将按以下ID顺序发送CAN消息：

`0x301`, `0x00000302`, `0x303`, `0x00000304`, `0x305`

CAN总线上实际的消息顺序将是：

`0x301`, `0x00000302`, `0x00000304`, `0x303`, `0x305`

Callback函数认为接收到ID顺序为：

`0x305`, `0x301`, `0x00000302`, `0x00000304`, `0x303`

> 1. Legacy FIFO 过滤格式为：`CAN_LEGACY_RX_FIFO_FILTER_FORMAT_A`。
> 2. ID为 0x303 的消息由 Global_Filter0 匹配。参见参考手册中的图 20.4 "ID Filter Table Structure"，了解为何 0xC0C00000 匹配 0x303。
> 3. ID为 0x305 的消息将在软件中接收，因为其他消息使用2ms轮询接收。

### CAN2_TX_CAN3

此阶段演示以下内容：

* 使用 Legacy FIFO 并以 `CAN_LEGACY_RX_FIFO_FILTER_FORMAT_B` 作为 mailbox 过滤模式

在此阶段，源代码将按以下ID顺序发送CAN消息：

`0x401`, `0x04020000`, `0x04030000`, `0x100`, `0x101`, `0x10100000`, `0x404`, `0x04050000`

CAN总线上实际的消息顺序将是：

`0x401`, `0x100`, `0x04020000`, `0x04030000`, `0x101`, `0x04050000`, `0x404`, `0x10100000`

Callback函数认为接收到ID顺序为：

`0x401`, `0x100`, `0x04020000`, `0x04030000`, `0x04050000`, `0x404`, `0x10100000`

> 1. Legacy FIFO 过滤格式为：`CAN_LEGACY_RX_FIFO_FILTER_FORMAT_B`。
> 2. ID为 0x100 的消息由 Individual_Filter2 匹配。参见参考手册中的图 20.4 "ID Filter Table Structure"，了解为何 0x04020000 匹配 0x100。
> 3. ID为 0x404 的消息由 Individual_Filter3 匹配。参见参考手册中的图 20.4 "ID Filter Table Structure"，了解为何 0x10100000 匹配 0x404。
> 4. ID为 0x101 的消息将被忽略，因为没有过滤器匹配此ID。

---

## 硬件需求
+ **EVB**: YTM32B1HA01-EVB-Q176-Rev.A
+ **调试器**： J-Link HW v9 或更高版本，安装了 YUNTU YTM32B1HA01 补丁（支持包）。

---

## 软件需求

+ **配置和代码生成工具**
  + **MCAL**:     Yuntu Config Tool(YCT) v2.6 或更高版本
+ **编译器工具链**
  + **GCC**     : GNU GCC v10.3 或更高版本
  + **Keil/MDK**: ARM Keil/MDK v5.36 或更高版本
  + **IAR**     : IAR v8.40 或更高版本
  + **VS Code**  : Microsoft Visual Studio Code IDE v1.76 或更高版本（需要 C/C++ 支持，GNU 工具链，CMake v3.25，ninja，Cortex-Debug 扩展安装）
+ **Debugger driver**
    + **J-Link**              : SEGGER J-Link v7.8.2 或更高版本，需要安装 YUNTU YTM32B1HA01 补丁（支持包）。
    + **Ozone Debugger tool**  : SEGGER Ozone v3.28 或更高版本。

    ***注意***: * 需要安装 **YTM32B1HA0** 补丁，补丁可通过 **YCT** 工具或联系 ***云途 销售/FAE 团队***获取.

---

## 勘误表

1. 要启动 CAN1，断开 EVB J17 和 J19 跳线，并将 J17-1 连接到 J19-2，J19-1 连接到 J17-2。
2. 要启动 CAN2，断开 EVB J25 并连接 J25-2 到 P4-87。

---

## 步骤

1. **步骤1**: 使用 YCT 工具打开 `Can_Demo.yct`，根据需要配置工具链（默认是 VS Code + GCC）。
2. **步骤2**: 生成代码。如果需要，可以更改配置（以适应您自己的硬件设计）。确保所有修改无误后再生成代码。
3. **步骤3**: 使用所选的 VS Code/IAR/Keil IDE 打开生成的项目。
4. **步骤4**: 编译项目，给 EVB 上电，并通过可用的调试器（如 J-Link 调试器探头）下载到 EVB。
5. **步骤5**: 如果您没有更改默认配置，可以在 EVB 上找到逻辑名称对应的丝印。
6. **步骤6**: 分别连接 CAN1 和 CAN2，以及 CAN2 和 CAN3。
7. **步骤7**: 更改 **main.c** 中的 `Demo_State` 然后编译，测试不同的发送接收类型

---