/*
* @file    SchM_Can.h
*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : SchM_Can
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V1.0.0
*
*   (c) Copyright 2020-2023 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifndef SCHM_CAN_H
#define SCHM_CAN_H

/**
*   @file    SchM_Can.h
*
*   @addtogroup SCHM_CAN_MODULE
*   @{
*/

#ifdef __cplusplus
extern "C" {
#endif

/* PRQA S 0777,0779 EOF */
/*==================================================================================================
                                              INCLUDE FILES                                          
==================================================================================================*/
#include "Can.h"

/*==================================================================================================
                                      HEADER FILE VERSION INFORMATION                                
==================================================================================================*/
#define SCHM_CAN_VENDOR_ID                      (180)
#define SCHM_CAN_AR_RELEASE_MAJOR_VERSION       (4)
#define SCHM_CAN_AR_RELEASE_MINOR_VERSION       (4)
#define SCHM_CAN_AR_RELEASE_REVISION_VERSION    (0)
#define SCHM_CAN_SW_MAJOR_VERSION               (1)
#define SCHM_CAN_SW_MINOR_VERSION               (0)
#define SCHM_CAN_SW_PATCH_VERSION               (0)
/*==================================================================================================
                                                DEFINES AND MACROS                                       
==================================================================================================*/

/* Number of cores id */
#ifndef NUMBER_OF_CORES
#define NUMBER_OF_CORES         (uint8)(1U)
#endif /* NUMBER_OF_CORES */

/*==================================================================================================
                                                EXTERNAL CONSTANTS                                        
==================================================================================================*/
/*==================================================================================================
                                                ENUMS                                        
==================================================================================================*/
/*==================================================================================================
                                                FUNCTION PROTOTYPES                                           
==================================================================================================*/

extern void SchM_Enter_Can_CAN_EXCLUSIVE_AREA_00(void);
extern void SchM_Exit_Can_CAN_EXCLUSIVE_AREA_00(void);
extern void SchM_Enter_Can_CAN_EXCLUSIVE_AREA_01(void);
extern void SchM_Exit_Can_CAN_EXCLUSIVE_AREA_01(void);
extern void SchM_Enter_Can_CAN_EXCLUSIVE_AREA_02(void);
extern void SchM_Exit_Can_CAN_EXCLUSIVE_AREA_02(void);
#if ((CAN_BUSOFF_PROCESS_HAS_INTERRUPT == STD_ON) || (CAN_SCHM_CONTINUOUSLY == STD_ON))
extern void SchM_Enter_Can_CAN_EXCLUSIVE_AREA_03(void);
extern void SchM_Exit_Can_CAN_EXCLUSIVE_AREA_03(void);
#endif
#if ((CAN_DMA_USAGE == STD_ON) || (CAN_SCHM_CONTINUOUSLY == STD_ON))
extern void SchM_Enter_Can_CAN_EXCLUSIVE_AREA_04(void);
extern void SchM_Exit_Can_CAN_EXCLUSIVE_AREA_04(void);
#endif
#if (((CAN_RX_PROCESS_HAS_INTERRUPT == STD_ON) && (CAN_LEGACY_FIFO_USAGE == STD_ON)) || (CAN_SCHM_CONTINUOUSLY == STD_ON))
extern void SchM_Enter_Can_CAN_EXCLUSIVE_AREA_05(void);
extern void SchM_Exit_Can_CAN_EXCLUSIVE_AREA_05(void);
#endif
extern void SchM_Enter_Can_CAN_EXCLUSIVE_AREA_06(void);
extern void SchM_Exit_Can_CAN_EXCLUSIVE_AREA_06(void);
extern void SchM_Enter_Can_CAN_EXCLUSIVE_AREA_07(void);
extern void SchM_Exit_Can_CAN_EXCLUSIVE_AREA_07(void);
extern void SchM_Enter_Can_CAN_EXCLUSIVE_AREA_08(void);
extern void SchM_Exit_Can_CAN_EXCLUSIVE_AREA_08(void);
extern void SchM_Enter_Can_CAN_EXCLUSIVE_AREA_09(void);
extern void SchM_Exit_Can_CAN_EXCLUSIVE_AREA_09(void);
extern void SchM_Enter_Can_CAN_EXCLUSIVE_AREA_10(void);
extern void SchM_Exit_Can_CAN_EXCLUSIVE_AREA_10(void);
extern void SchM_Enter_Can_CAN_EXCLUSIVE_AREA_11(void);
extern void SchM_Exit_Can_CAN_EXCLUSIVE_AREA_11(void);
extern void SchM_Enter_Can_CAN_EXCLUSIVE_AREA_12(void);
extern void SchM_Exit_Can_CAN_EXCLUSIVE_AREA_12(void);
extern void SchM_Enter_Can_CAN_EXCLUSIVE_AREA_13(void);
extern void SchM_Exit_Can_CAN_EXCLUSIVE_AREA_13(void);
extern void SchM_Enter_Can_CAN_EXCLUSIVE_AREA_14(void);
extern void SchM_Exit_Can_CAN_EXCLUSIVE_AREA_14(void);
extern void SchM_Enter_Can_CAN_EXCLUSIVE_AREA_15(void);
extern void SchM_Exit_Can_CAN_EXCLUSIVE_AREA_15(void);
extern void SchM_Enter_Can_CAN_EXCLUSIVE_AREA_16(void);
extern void SchM_Exit_Can_CAN_EXCLUSIVE_AREA_16(void);
extern void SchM_Enter_Can_CAN_EXCLUSIVE_AREA_17(void);
extern void SchM_Exit_Can_CAN_EXCLUSIVE_AREA_17(void);
extern void SchM_Enter_Can_CAN_EXCLUSIVE_AREA_18(void);
extern void SchM_Exit_Can_CAN_EXCLUSIVE_AREA_18(void);
extern void SchM_Enter_Can_CAN_EXCLUSIVE_AREA_19(void);
extern void SchM_Exit_Can_CAN_EXCLUSIVE_AREA_19(void);
#if ((CAN_LEGACY_FIFO_USAGE == STD_ON) || (CAN_SCHM_CONTINUOUSLY == STD_ON))
extern void SchM_Enter_Can_CAN_EXCLUSIVE_AREA_20(void);
extern void SchM_Exit_Can_CAN_EXCLUSIVE_AREA_20(void);
#endif
extern void SchM_Enter_Can_CAN_EXCLUSIVE_AREA_21(void);
extern void SchM_Exit_Can_CAN_EXCLUSIVE_AREA_21(void);
#if (((CAN_RX_PROCESS_HAS_INTERRUPT == STD_ON) || (CAN_TX_PROCESS_HAS_INTERRUPT == STD_ON)) || (CAN_SCHM_CONTINUOUSLY == STD_ON))
extern void SchM_Enter_Can_CAN_EXCLUSIVE_AREA_22(void);
extern void SchM_Exit_Can_CAN_EXCLUSIVE_AREA_22(void);
#endif
extern void SchM_Enter_Can_CAN_EXCLUSIVE_AREA_23(void);
extern void SchM_Exit_Can_CAN_EXCLUSIVE_AREA_23(void);
extern void SchM_Enter_Can_CAN_EXCLUSIVE_AREA_24(void);
extern void SchM_Exit_Can_CAN_EXCLUSIVE_AREA_24(void);
extern void SchM_Enter_Can_CAN_EXCLUSIVE_AREA_25(void);
extern void SchM_Exit_Can_CAN_EXCLUSIVE_AREA_25(void);
extern void SchM_Enter_Can_CAN_EXCLUSIVE_AREA_26(void);
extern void SchM_Exit_Can_CAN_EXCLUSIVE_AREA_26(void);

#ifdef __cplusplus
}
#endif

/** @} */

#endif /* End of file SchM_Can.h */

