/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file Can_PBcfg.c
 * @brief 
 * 
 */


#ifdef __cplusplus
extern "C"{
#endif

/**
 * @page misra_violations MISRA-C:2012 violations
 */

/*==================================================================================================
 *                                        INCLUDE FILES
==================================================================================================*/
#include "Can.h"
#include "Can_Drv.h"

/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define CAN_VENDOR_ID_PBCFG_C                      (180)
#define CAN_AR_RELEASE_MAJOR_VERSION_PBCFG_C       (4)
#define CAN_AR_RELEASE_MINOR_VERSION_PBCFG_C       (4)
#define CAN_AR_RELEASE_REVISION_VERSION_PBCFG_C    (0)
#define CAN_SW_MAJOR_VERSION_PBCFG_C               (1)
#define CAN_SW_MINOR_VERSION_PBCFG_C               (0)
#define CAN_SW_PATCH_VERSION_PBCFG_C               (0)

/*==================================================================================================
*                                         CALLBACKS
==================================================================================================*/

#if (CAN_RX_PROCESS_HAS_POLLING == STD_ON)
#define CAN_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Can_MemMap.h"
CAN_CONST const Can_MainFunction_RW Can_MainFunction_Read_CanReadWrite2ms = Can_MainFunction_Read_Period_0;
CAN_CONST const Can_MainFunction_RW Can_MainFunction_Read_CanReadWrite500ms = Can_MainFunction_Read_Period_1;
#define CAN_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Can_MemMap.h"/*memory map finish*/ 
#endif

#if (CAN_TX_PROCESS_HAS_POLLING == STD_ON)
#define CAN_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Can_MemMap.h"
CAN_CONST const Can_MainFunction_RW Can_MainFunction_Write_CanReadWrite2ms = Can_MainFunction_Write_Period_0;
CAN_CONST const Can_MainFunction_RW Can_MainFunction_Write_CanReadWrite500ms = Can_MainFunction_Write_Period_1;
#define CAN_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Can_MemMap.h"/*memory map finish*/
#endif

#define CAN_START_SEC_CODE
#include "Can_MemMap.h"
CAN_FUNC __attribute__((weak)) boolean CanReceiveCallOut(uint8 Hrh, Can_IdType CanId, uint8 CanDataLegth, const uint8* CanSduPtr ){(void)Hrh; (void)CanId; (void)CanDataLegth; (void)CanSduPtr; return TRUE;}
CAN_FUNC __attribute__((weak)) void CanTransmitCallOut(PduIdType TxPduId){(void)TxPduId;}



#define CAN_STOP_SEC_CODE
#include "Can_MemMap.h"
/*==================================================================================================
*                                         CONSTANTS
==================================================================================================*/
#define CAN_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Can_MemMap.h"
#if (CAN_ENHANCE_FIFO_USAGE == STD_ON)

#endif/*#if (CAN_ENHANCE_FIFO_USAGE == STD_ON)*/
#if (CAN_LEGACY_FIFO_USAGE == STD_ON)

#endif/*#if (CAN_LEGACY_FIFO_USAGE == STD_ON)*/

#if (CAN_FD_USAGE == STD_ON)
#endif



CAN_CONST const Can_BdrConfigType CanControllerBaudrateConfig_0[1] = 
{
    {
        .CanBaudrateConfigID = 0U,
        .CanBaudrate         = 500U,
        .CanPreDiv           = 20U,
        .CanPropSeg          = 4U,
        .CanSeg1             = 3U,
        .CanSeg2             = 2U,
        .CanSyncJumpWidth    = 1U,
#if (CAN_FD_USAGE == STD_ON)
        .CanFdBdrConfig = NULL_PTR,
#endif
    },
};

CAN_CONST const Can_MbRegionConfigType MbRegionConfig_0[4] =
{
    {
        .MbPlSizeType     = CAN_PLSIZE_8_BYTES,
        .MbMsgBufferNum   = 32U,
        .PayloadSize      = 8U,
        .PayloadRamLength = 16U
    },
    {
        .MbPlSizeType     = CAN_PLSIZE_8_BYTES,
        .MbMsgBufferNum   = 32U,
        .PayloadSize      = 8U,
        .PayloadRamLength = 16U
    },
    {
        .MbPlSizeType     = CAN_PLSIZE_8_BYTES,
        .MbMsgBufferNum   = 32U,
        .PayloadSize      = 8U,
        .PayloadRamLength = 16U
    },
    {
        .MbPlSizeType     = CAN_PLSIZE_8_BYTES,
        .MbMsgBufferNum   = 32U,
        .PayloadSize      = 8U,
        .PayloadRamLength = 16U
    },
};


CAN_CONST const Can_PayloadConfigType    Can_PayloadConfig_0 =
{
    .MbRegionNum     = (Can_HwObjRegionType)4U,
    .MbRegionConfig  = MbRegionConfig_0,
    .ChPayloadMaxNum = 128U,
    .RxFifoType      = CAN_RX_FIFO_NONE,
#if (CAN_ENHANCE_FIFO_USAGE == STD_ON)
    .EnhanceRxFifoConfigPtr = NULL_PTR, /*!< Point the rx fifo config */
#endif
#if (CAN_LEGACY_FIFO_USAGE == STD_ON)
    .LegacyRxFifoConfigPtr  = NULL_PTR,
#endif
};

CAN_CONST const Can_FilterOfMbType Can_FilterConfig_0[1] =
{
    {
        .FilterCode = 0x101U,
        .MaskCode   = 0x7FEU,
    }
};
CAN_CONST const Can_FilterOfMbType Can_FilterConfig_1[1] =
{
    {
        .FilterCode = 0x102U,
        .MaskCode   = 0x1FFFFFFFU,
    }
};
CAN_CONST const Can_FilterOfMbType Can_FilterConfig_2[1] =
{
    {
        .FilterCode = 0x103U,
        .MaskCode   = 0x7FFU,
    }
};



CAN_CONST const Can_HohConfigType Can_HohConfig[4] =
{
    {
        .CanObjId          = 0U,
        .CanChannelId      = 0U,
        .CanHwObjRegionId  = CAN_RAM_REGION_0,
        .CanHwObjNum       = 1U,
        .ObjectType        = CAN_RECEIVE,
#if ((CAN_RX_PROCESS_HAS_POLLING == STD_ON) || (CAN_TX_PROCESS_HAS_POLLING == STD_ON))
        .UsePolling        = FALSE,
        .PollingPeriodId   = 255U,
#endif
#if (DEVELOPPING == STD_ON)
        .BasicFullType     = CAN_HANDLE_BASIC,
#endif
        .MsgIdType         = STANDARD,
        .FilterConfig      = Can_FilterConfig_0,
        .CanHwFlagStartId  = 0,
        .CanHwObjStartId = 0
    },
    {
        .CanObjId          = 1U,
        .CanChannelId      = 0U,
        .CanHwObjRegionId  = CAN_RAM_REGION_1,
        .CanHwObjNum       = 2U,
        .ObjectType        = CAN_RECEIVE,
#if ((CAN_RX_PROCESS_HAS_POLLING == STD_ON) || (CAN_TX_PROCESS_HAS_POLLING == STD_ON))
        .UsePolling        = FALSE,
        .PollingPeriodId   = 255U,
#endif
#if (DEVELOPPING == STD_ON)
        .BasicFullType     = CAN_HANDLE_BASIC,
#endif
        .MsgIdType         = EXTENDED,
        .FilterConfig      = Can_FilterConfig_1,
        .CanHwFlagStartId  = 32,
        .CanHwObjStartId = 0
    },
    {
        .CanObjId          = 2U,
        .CanChannelId      = 0U,
        .CanHwObjRegionId  = CAN_RAM_REGION_1,
        .CanHwObjNum       = 2U,
        .ObjectType        = CAN_RECEIVE,
#if ((CAN_RX_PROCESS_HAS_POLLING == STD_ON) || (CAN_TX_PROCESS_HAS_POLLING == STD_ON))
        .UsePolling        = FALSE,
        .PollingPeriodId   = 255U,
#endif
#if (DEVELOPPING == STD_ON)
        .BasicFullType     = CAN_HANDLE_BASIC,
#endif
        .MsgIdType         = STANDARD,
        .FilterConfig      = Can_FilterConfig_2,
        .CanHwFlagStartId  = 34,
        .CanHwObjStartId = 2
    },
    {
        .CanObjId          = 3U,
        .CanChannelId      = 0U,
        .CanHwObjRegionId  = CAN_RAM_REGION_2,
        .CanHwObjNum       = 1U,
        .ObjectType        = CAN_TRANSMIT,
#if ((CAN_RX_PROCESS_HAS_POLLING == STD_ON) || (CAN_TX_PROCESS_HAS_POLLING == STD_ON))
        .UsePolling        = FALSE,
        .PollingPeriodId   = 255U,
#endif
#if (CAN_FD_USAGE == STD_ON)
        .CanFdPaddingValue = 0xccU,
#endif
#if (DEVELOPPING == STD_ON)
        .TrigTransEnable   = FALSE,
#endif
#if (DEVELOPPING == STD_ON)
        .BasicFullType     = CAN_HANDLE_BASIC,
#endif
        .CanHwFlagStartId  = 64,
        .CanHwObjStartId = 0
    },
};

#if (CAN_RX_PROCESS_HAS_POLLING == STD_ON)

CAN_CONST const Can_HohPolPeriodType CanHrhPolPeriodTable[2] =
{
    /* Polling Name: CanReadWrite2ms */
    {
        .CanPeriodId       = 0U,
        .CanHohNum         = 0U,
        .CanPolTablePtr    = NULL_PTR,
    },
    /* Polling Name: CanReadWrite500ms */
    {
        .CanPeriodId       = 1U,
        .CanHohNum         = 0U,
        .CanPolTablePtr    = NULL_PTR,
    },
};
#endif

#if (CAN_TX_PROCESS_HAS_POLLING == STD_ON)

CAN_CONST const Can_HohPolPeriodType CanHthPolPeriodTable[2] =
{
    /* Polling Name: CanReadWrite2ms */
    {
        .CanPeriodId       = 0U,
        .CanHohNum         = 0U,
        .CanPolTablePtr    = NULL_PTR,
    },
    /* Polling Name: CanReadWrite500ms */
    {
        .CanPeriodId       = 1U,
        .CanHohNum         = 0U,
        .CanPolTablePtr    = NULL_PTR,
    },
};
#endif


/**
 * @brief This map is used to translate the 'CAN hardware ID' to 'a logical ID'.
 */
CAN_CONST const uint8 Can_HwIdTable[8] = { 0U, 255U, 255U, 255U, 255U, 255U, 255U, 255U,  };

/**
 * @brief This map is used to convert a mailbox flag ID to the HOH ID and region for CAN0.
 */
CAN_CONST const Can_MbFlagMatrixType Can_HwFlagMatrixConfig_0[128] =
{
    /* Flag id: 0 */
    {
        .CanHwObjId    = 0,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = 0,
    },
    /* Flag id: 1 */
    {
        .CanHwObjId    = 1,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 2 */
    {
        .CanHwObjId    = 2,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 3 */
    {
        .CanHwObjId    = 3,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 4 */
    {
        .CanHwObjId    = 4,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 5 */
    {
        .CanHwObjId    = 5,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 6 */
    {
        .CanHwObjId    = 6,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 7 */
    {
        .CanHwObjId    = 7,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 8 */
    {
        .CanHwObjId    = 8,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 9 */
    {
        .CanHwObjId    = 9,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 10 */
    {
        .CanHwObjId    = 10,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 11 */
    {
        .CanHwObjId    = 11,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 12 */
    {
        .CanHwObjId    = 12,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 13 */
    {
        .CanHwObjId    = 13,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 14 */
    {
        .CanHwObjId    = 14,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 15 */
    {
        .CanHwObjId    = 15,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 16 */
    {
        .CanHwObjId    = 16,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 17 */
    {
        .CanHwObjId    = 17,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 18 */
    {
        .CanHwObjId    = 18,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 19 */
    {
        .CanHwObjId    = 19,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 20 */
    {
        .CanHwObjId    = 20,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 21 */
    {
        .CanHwObjId    = 21,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 22 */
    {
        .CanHwObjId    = 22,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 23 */
    {
        .CanHwObjId    = 23,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 24 */
    {
        .CanHwObjId    = 24,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 25 */
    {
        .CanHwObjId    = 25,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 26 */
    {
        .CanHwObjId    = 26,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 27 */
    {
        .CanHwObjId    = 27,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 28 */
    {
        .CanHwObjId    = 28,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 29 */
    {
        .CanHwObjId    = 29,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 30 */
    {
        .CanHwObjId    = 30,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 31 */
    {
        .CanHwObjId    = 31,
        .CanHwRegionId = CAN_RAM_REGION_0,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 32 */
    {
        .CanHwObjId    = 0,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = 1,
    },
    /* Flag id: 33 */
    {
        .CanHwObjId    = 1,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = 1,
    },
    /* Flag id: 34 */
    {
        .CanHwObjId    = 2,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = 2,
    },
    /* Flag id: 35 */
    {
        .CanHwObjId    = 3,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = 2,
    },
    /* Flag id: 36 */
    {
        .CanHwObjId    = 4,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 37 */
    {
        .CanHwObjId    = 5,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 38 */
    {
        .CanHwObjId    = 6,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 39 */
    {
        .CanHwObjId    = 7,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 40 */
    {
        .CanHwObjId    = 8,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 41 */
    {
        .CanHwObjId    = 9,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 42 */
    {
        .CanHwObjId    = 10,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 43 */
    {
        .CanHwObjId    = 11,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 44 */
    {
        .CanHwObjId    = 12,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 45 */
    {
        .CanHwObjId    = 13,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 46 */
    {
        .CanHwObjId    = 14,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 47 */
    {
        .CanHwObjId    = 15,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 48 */
    {
        .CanHwObjId    = 16,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 49 */
    {
        .CanHwObjId    = 17,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 50 */
    {
        .CanHwObjId    = 18,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 51 */
    {
        .CanHwObjId    = 19,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 52 */
    {
        .CanHwObjId    = 20,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 53 */
    {
        .CanHwObjId    = 21,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 54 */
    {
        .CanHwObjId    = 22,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 55 */
    {
        .CanHwObjId    = 23,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 56 */
    {
        .CanHwObjId    = 24,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 57 */
    {
        .CanHwObjId    = 25,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 58 */
    {
        .CanHwObjId    = 26,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 59 */
    {
        .CanHwObjId    = 27,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 60 */
    {
        .CanHwObjId    = 28,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 61 */
    {
        .CanHwObjId    = 29,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 62 */
    {
        .CanHwObjId    = 30,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 63 */
    {
        .CanHwObjId    = 31,
        .CanHwRegionId = CAN_RAM_REGION_1,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 64 */
    {
        .CanHwObjId    = 0,
        .CanHwRegionId = CAN_RAM_REGION_2,
        .CanHohId      = 3,
    },
    /* Flag id: 65 */
    {
        .CanHwObjId    = 1,
        .CanHwRegionId = CAN_RAM_REGION_2,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 66 */
    {
        .CanHwObjId    = 2,
        .CanHwRegionId = CAN_RAM_REGION_2,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 67 */
    {
        .CanHwObjId    = 3,
        .CanHwRegionId = CAN_RAM_REGION_2,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 68 */
    {
        .CanHwObjId    = 4,
        .CanHwRegionId = CAN_RAM_REGION_2,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 69 */
    {
        .CanHwObjId    = 5,
        .CanHwRegionId = CAN_RAM_REGION_2,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 70 */
    {
        .CanHwObjId    = 6,
        .CanHwRegionId = CAN_RAM_REGION_2,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 71 */
    {
        .CanHwObjId    = 7,
        .CanHwRegionId = CAN_RAM_REGION_2,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 72 */
    {
        .CanHwObjId    = 8,
        .CanHwRegionId = CAN_RAM_REGION_2,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 73 */
    {
        .CanHwObjId    = 9,
        .CanHwRegionId = CAN_RAM_REGION_2,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 74 */
    {
        .CanHwObjId    = 10,
        .CanHwRegionId = CAN_RAM_REGION_2,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 75 */
    {
        .CanHwObjId    = 11,
        .CanHwRegionId = CAN_RAM_REGION_2,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 76 */
    {
        .CanHwObjId    = 12,
        .CanHwRegionId = CAN_RAM_REGION_2,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 77 */
    {
        .CanHwObjId    = 13,
        .CanHwRegionId = CAN_RAM_REGION_2,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 78 */
    {
        .CanHwObjId    = 14,
        .CanHwRegionId = CAN_RAM_REGION_2,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 79 */
    {
        .CanHwObjId    = 15,
        .CanHwRegionId = CAN_RAM_REGION_2,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 80 */
    {
        .CanHwObjId    = 16,
        .CanHwRegionId = CAN_RAM_REGION_2,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 81 */
    {
        .CanHwObjId    = 17,
        .CanHwRegionId = CAN_RAM_REGION_2,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 82 */
    {
        .CanHwObjId    = 18,
        .CanHwRegionId = CAN_RAM_REGION_2,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 83 */
    {
        .CanHwObjId    = 19,
        .CanHwRegionId = CAN_RAM_REGION_2,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 84 */
    {
        .CanHwObjId    = 20,
        .CanHwRegionId = CAN_RAM_REGION_2,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 85 */
    {
        .CanHwObjId    = 21,
        .CanHwRegionId = CAN_RAM_REGION_2,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 86 */
    {
        .CanHwObjId    = 22,
        .CanHwRegionId = CAN_RAM_REGION_2,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 87 */
    {
        .CanHwObjId    = 23,
        .CanHwRegionId = CAN_RAM_REGION_2,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 88 */
    {
        .CanHwObjId    = 24,
        .CanHwRegionId = CAN_RAM_REGION_2,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 89 */
    {
        .CanHwObjId    = 25,
        .CanHwRegionId = CAN_RAM_REGION_2,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 90 */
    {
        .CanHwObjId    = 26,
        .CanHwRegionId = CAN_RAM_REGION_2,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 91 */
    {
        .CanHwObjId    = 27,
        .CanHwRegionId = CAN_RAM_REGION_2,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 92 */
    {
        .CanHwObjId    = 28,
        .CanHwRegionId = CAN_RAM_REGION_2,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 93 */
    {
        .CanHwObjId    = 29,
        .CanHwRegionId = CAN_RAM_REGION_2,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 94 */
    {
        .CanHwObjId    = 30,
        .CanHwRegionId = CAN_RAM_REGION_2,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 95 */
    {
        .CanHwObjId    = 31,
        .CanHwRegionId = CAN_RAM_REGION_2,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 96 */
    {
        .CanHwObjId    = 0,
        .CanHwRegionId = CAN_RAM_REGION_3,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 97 */
    {
        .CanHwObjId    = 1,
        .CanHwRegionId = CAN_RAM_REGION_3,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 98 */
    {
        .CanHwObjId    = 2,
        .CanHwRegionId = CAN_RAM_REGION_3,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 99 */
    {
        .CanHwObjId    = 3,
        .CanHwRegionId = CAN_RAM_REGION_3,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 100 */
    {
        .CanHwObjId    = 4,
        .CanHwRegionId = CAN_RAM_REGION_3,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 101 */
    {
        .CanHwObjId    = 5,
        .CanHwRegionId = CAN_RAM_REGION_3,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 102 */
    {
        .CanHwObjId    = 6,
        .CanHwRegionId = CAN_RAM_REGION_3,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 103 */
    {
        .CanHwObjId    = 7,
        .CanHwRegionId = CAN_RAM_REGION_3,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 104 */
    {
        .CanHwObjId    = 8,
        .CanHwRegionId = CAN_RAM_REGION_3,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 105 */
    {
        .CanHwObjId    = 9,
        .CanHwRegionId = CAN_RAM_REGION_3,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 106 */
    {
        .CanHwObjId    = 10,
        .CanHwRegionId = CAN_RAM_REGION_3,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 107 */
    {
        .CanHwObjId    = 11,
        .CanHwRegionId = CAN_RAM_REGION_3,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 108 */
    {
        .CanHwObjId    = 12,
        .CanHwRegionId = CAN_RAM_REGION_3,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 109 */
    {
        .CanHwObjId    = 13,
        .CanHwRegionId = CAN_RAM_REGION_3,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 110 */
    {
        .CanHwObjId    = 14,
        .CanHwRegionId = CAN_RAM_REGION_3,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 111 */
    {
        .CanHwObjId    = 15,
        .CanHwRegionId = CAN_RAM_REGION_3,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 112 */
    {
        .CanHwObjId    = 16,
        .CanHwRegionId = CAN_RAM_REGION_3,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 113 */
    {
        .CanHwObjId    = 17,
        .CanHwRegionId = CAN_RAM_REGION_3,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 114 */
    {
        .CanHwObjId    = 18,
        .CanHwRegionId = CAN_RAM_REGION_3,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 115 */
    {
        .CanHwObjId    = 19,
        .CanHwRegionId = CAN_RAM_REGION_3,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 116 */
    {
        .CanHwObjId    = 20,
        .CanHwRegionId = CAN_RAM_REGION_3,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 117 */
    {
        .CanHwObjId    = 21,
        .CanHwRegionId = CAN_RAM_REGION_3,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 118 */
    {
        .CanHwObjId    = 22,
        .CanHwRegionId = CAN_RAM_REGION_3,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 119 */
    {
        .CanHwObjId    = 23,
        .CanHwRegionId = CAN_RAM_REGION_3,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 120 */
    {
        .CanHwObjId    = 24,
        .CanHwRegionId = CAN_RAM_REGION_3,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 121 */
    {
        .CanHwObjId    = 25,
        .CanHwRegionId = CAN_RAM_REGION_3,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 122 */
    {
        .CanHwObjId    = 26,
        .CanHwRegionId = CAN_RAM_REGION_3,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 123 */
    {
        .CanHwObjId    = 27,
        .CanHwRegionId = CAN_RAM_REGION_3,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 124 */
    {
        .CanHwObjId    = 28,
        .CanHwRegionId = CAN_RAM_REGION_3,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 125 */
    {
        .CanHwObjId    = 29,
        .CanHwRegionId = CAN_RAM_REGION_3,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 126 */
    {
        .CanHwObjId    = 30,
        .CanHwRegionId = CAN_RAM_REGION_3,
        .CanHohId      = MB_NOT_USE,
    },
    /* Flag id: 127 */
    {
        .CanHwObjId    = 31,
        .CanHwRegionId = CAN_RAM_REGION_3,
        .CanHohId      = MB_NOT_USE,
    },
};


/**
 * @brief This is callback enable list for CAN0
 */
CAN_CONST const Can_CallbackEntranceType Can_CallbackEntrance_0 =
{
#if ((CAN_LEGACY_FIFO_USAGE == STD_ON) || (CAN_ENHANCE_FIFO_USAGE == STD_ON))
    .ReceiveFifoFullCallback      = NULL_PTR,
    .ReceiveFifoOverflowCallback  = NULL_PTR,
#endif
    .OverrunCallback              = NULL_PTR,
    .WarningCallback              = NULL_PTR,
    .BusoffCallback               = NULL_PTR,
    .ErrorCallback                = NULL_PTR,
    .ErrFastCallback              = NULL_PTR,
    .ErrNceCallback               = NULL_PTR,
    .ErrCeCallback                = NULL_PTR,
#if (CAN_WAKEUP_SUPPORT == STD_ON)
    .WakeupCallback               = NULL_PTR,
#endif
#if (CAN_ICOM_USAGE == STD_ON)
    .IcomCallback                 = NULL_PTR,
#endif
};


CAN_CONST const Can_ChannelConfigType Can_ChannelConfig[1] =
{
    {
        .CanChannelId            = 0U,
        .CanHwChId               = FLEXCAN_0,
        .CanChActivation         = TRUE,
        .ChBaseAddr              = 0x400D0000U,
        .CanTrippleSamp          = FALSE,
        /* Do not need to take care of 'CanAutoBusoffRecovery' param, The driver ensures that
           when a Busoff occurs, the Can controller will always enter the STOPPED state and
           has complied with MCAL requirements */
        .CanAutoBusoffRecovery   = TRUE,
        .CanRxProcessing         = CAN_PROCESS_INTERRUPT,
        .CanTxProcessing         = CAN_PROCESS_INTERRUPT,
        .CanBusoffProcessing     = CAN_PROCESS_INTERRUPT,
#if (CAN_WAKEUP_SUPPORT == STD_ON)
        .CanWakeupProcessing     = CAN_PROCESS_INTERRUPT,
        .CanWakeupSupport        = FALSE,
        .EcuMWakeupSource        = (EcuM_WakeupSourceType)0,
#endif
#if (CAN_WAKEUP_FUNCTIONALITY_API == STD_ON)
        .CanWakeupFunctionalityAPI = FALSE,
#endif
#if (CAN_FD_USAGE == STD_ON)
        .FdUsage                 = FALSE,
        .IsoModeUsage            = FALSE,
#endif
        .CanTimeQuantaSource     = CAN_CLOCK_SOURCE_PE,
        .ChBaudrateNum           = 1U,
        .DefaultBdrConfig        = &CanControllerBaudrateConfig_0[0],
        .BdrConfigPtr            = CanControllerBaudrateConfig_0,
        .PayloadConfigPtr        = &Can_PayloadConfig_0,
        .CanCallbackPtr          = &Can_CallbackEntrance_0,
        .CanFifoHrhId            = 255U,
        .CanHwFlagMatrixPtr      = Can_HwFlagMatrixConfig_0,
        .RamMbNum                = 128U,
        .RamIrmqEn               = TRUE,
#if (CAN_MEMECC_FEATURE == STD_ON)
        .RamEnhFifoEn            = TRUE,
        .RamHrTimeStmpEn         = TRUE,
        .RamEnhMbMemEn           = FALSE,
#endif
    },
};

/**
 * @brief CAN config
 */
CAN_CONST const Can_ConfigType Can_Config =
{
    .CanChannelNum        = 1U,
    .CanHohNum            = 4U,
    .CanChCfgPtr          = Can_ChannelConfig,
    .CanHohCfgPtr         = Can_HohConfig,
    .CanHwIdTable         = Can_HwIdTable,
#if ((CAN_RX_PROCESS_HAS_POLLING == STD_ON) && (CAN_TX_PROCESS_HAS_POLLING == STD_ON))
    .CanPolPeriodNum      = 2,
#endif
#if (CAN_RX_PROCESS_HAS_POLLING == STD_ON)
    .CanHrhPolPeriodPtr   = CanHrhPolPeriodTable,
#endif
#if (CAN_TX_PROCESS_HAS_POLLING == STD_ON)
    .CanHthPolPeriodPtr   = CanHthPolPeriodTable,
#endif
    .CanReceiveCallback   = CanReceiveCallOut,
    .CanTransmitCallback  = CanTransmitCallOut,
#if ((CAN_ENHANCE_FIFO_USAGE == STD_ON) || (CAN_LEGACY_FIFO_USAGE == STD_ON))
#if (CAN_FIFO_IDHIT_USAGE == STD_ON)
    .CanIdhitCallback     = NULL_PTR,
#endif
#endif
#if (CAN_ICOM_USAGE == STD_ON)
    .CanIcomNum           = 0U,
    .CanIcomCfgPtr        = NULL_PTR,
#endif
};

#define CAN_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Can_MemMap.h"

#ifdef __cplusplus
}
#endif

/** @} */

