/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file pin_mux.c
 * @brief 
 * 
 */



#include "pin_mux.h"

const pin_settings_config_t g_pin_mux_InitConfigArr0[NUM_OF_CONFIGURED_PINS0] = {
    /*PTE_8-9-GPIO-*/
    {
        .base=PCTRLE,
        .pinPortIdx = 8U,
        .pullConfig = PCTRL_INTERNAL_PULL_NOT_ENABLED,
        .driveSelect = PCTRL_HIGH_DRIVE_STRENGTH,
        .passiveFilter = false,
        .mux = PCTRL_MUX_AS_GPIO,
        .intConfig = PCTRL_DMA_INT_DISABLED,
        .clearIntFlag = false,
        .digitalFilter = false,
        .filterConfig ={
                        .width = 10
                        },
        .gpioBase = GPIOE,
        .direction=GPIO_OUTPUT_DIRECTION,
        .initValue=1,
    },
    /*PTD_5-14-GPIO-SD232*/
    {
        .base=PCTRLD,
        .pinPortIdx = 5U,
        .pullConfig = PCTRL_INTERNAL_PULL_NOT_ENABLED,
        .driveSelect = PCTRL_LOW_DRIVE_STRENGTH,
        .passiveFilter = false,
        .mux = PCTRL_MUX_AS_GPIO,
        .intConfig = PCTRL_DMA_INT_DISABLED,
        .clearIntFlag = false,
        .digitalFilter = false,
        .filterConfig ={
                        .width = 10
                        },
        .gpioBase = GPIOD,
        .direction=GPIO_OUTPUT_DIRECTION,
        .initValue=1,
    },
};


/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/

