
/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file vector.S
 * @brief 
 * 
 */

    
    SECTION .isr_vector:DATA:ROOT(2)
    EXTERN DefaultISR
    EXTERN STACK_end   /* Top of Stack for Initial Stack Pointer */
    EXTERN Reset_Handler             /* Reset Handler */
    EXTERN NMI_Handler
    EXTERN HardFault_Handler
    EXTERN MemManage_Handler
    EXTERN BusFault_Handler
    EXTERN UsageFault_Handler
    EXTERN SVC_Handler
    EXTERN DebugMon_Handler
    EXTERN PendSV_Handler
    EXTERN SysTick_Handler
    EXTERN DMA0_IRQHandler
    EXTERN DMA1_IRQHandler
    EXTERN DMA2_IRQHandler
    EXTERN DMA3_IRQHandler
    EXTERN DMA4_IRQHandler
    EXTERN DMA5_IRQHandler
    EXTERN DMA6_IRQHandler
    EXTERN DMA7_IRQHandler
    EXTERN DMA8_IRQHandler
    EXTERN DMA9_IRQHandler
    EXTERN DMA10_IRQHandler
    EXTERN DMA11_IRQHandler
    EXTERN DMA12_IRQHandler
    EXTERN DMA13_IRQHandler
    EXTERN DMA14_IRQHandler
    EXTERN DMA15_IRQHandler
    EXTERN DMA16_IRQHandler
    EXTERN DMA17_IRQHandler
    EXTERN DMA18_IRQHandler
    EXTERN DMA19_IRQHandler
    EXTERN DMA20_IRQHandler
    EXTERN DMA21_IRQHandler
    EXTERN DMA22_IRQHandler
    EXTERN DMA23_IRQHandler
    EXTERN DMA24_IRQHandler
    EXTERN DMA25_IRQHandler
    EXTERN DMA26_IRQHandler
    EXTERN DMA27_IRQHandler
    EXTERN DMA28_IRQHandler
    EXTERN DMA29_IRQHandler
    EXTERN DMA30_IRQHandler
    EXTERN DMA31_IRQHandler
    EXTERN DMA_Error_IRQHandler
    EXTERN FPU_IRQHandler
    EXTERN EFM_IRQHandler
    EXTERN EFM_Error_IRQHandler
    EXTERN PCU_IRQHandler
    EXTERN EFM_Ecc_IRQHandler
    EXTERN Wdg_Lld_Isr
    EXTERN I2C0_Master_Slave_IRQHandler
    EXTERN SPI0_IRQHandler
    EXTERN SPI1_IRQHandler
    EXTERN SPI2_IRQHandler
    EXTERN I2C1_Master_Slave_IRQHandler
    EXTERN LINFlexD0_IRQHandler
    EXTERN LINFlexD1_IRQHandler
    EXTERN LINFlexD2_IRQHandler
    EXTERN QSPI_IRQHandler
    EXTERN ADC0_IRQHandler
    EXTERN ADC1_IRQHandler
    EXTERN ACMP0_IRQHandler
    EXTERN ACMP1_IRQHandler
    EXTERN EMU_IRQHandler
    EXTERN RTC_IRQHandler
    EXTERN RTC_Seconds_IRQHandler
    EXTERN pTMR0_Ch0_IRQHandler
    EXTERN pTMR0_Ch1_IRQHandler
    EXTERN pTMR0_Ch2_IRQHandler
    EXTERN pTMR0_Ch3_IRQHandler
    EXTERN PTU0_IRQHandler
    EXTERN pTMR1_Ch0_IRQHandler
    EXTERN pTMR1_Ch1_IRQHandler
    EXTERN pTMR1_Ch2_IRQHandler
    EXTERN pTMR1_Ch3_IRQHandler
    EXTERN SCU_IRQHandler
    EXTERN lpTMR0_IRQHandler
    EXTERN GPIOA_IRQHandler
    EXTERN GPIOB_IRQHandler
    EXTERN GPIOC_IRQHandler
    EXTERN GPIOD_IRQHandler
    EXTERN GPIOE_IRQHandler
    EXTERN PTU1_IRQHandler
    EXTERN CAN0_ORed_IRQHandler
    EXTERN CAN0_Error_IRQHandler
    EXTERN CAN0_Wake_Up_IRQHandler
    EXTERN CAN0_ORed_0_15_MB_IRQHandler
    EXTERN CAN0_ORed_16_31_MB_IRQHandler
    EXTERN CAN0_ORed_32_47_MB_IRQHandler
    EXTERN CAN0_ORed_48_63_MB_IRQHandler
    EXTERN CAN0_ORed_64_79_MB_IRQHandler
    EXTERN CAN0_ORed_80_95_MB_IRQHandler
    EXTERN CAN0_ORed_96_111_MB_IRQHandler
    EXTERN CAN0_ORed_112_127_MB_IRQHandler
    EXTERN CAN1_ORed_IRQHandler
    EXTERN CAN1_Error_IRQHandler
    EXTERN CAN1_Wake_Up_IRQHandler
    EXTERN CAN1_ORed_0_15_MB_IRQHandler
    EXTERN CAN1_ORed_16_31_MB_IRQHandler
    EXTERN CAN1_ORed_32_47_MB_IRQHandler
    EXTERN CAN1_ORed_48_63_MB_IRQHandler
    EXTERN CAN1_ORed_64_79_MB_IRQHandler
    EXTERN CAN1_ORed_80_95_MB_IRQHandler
    EXTERN CAN1_ORed_96_111_MB_IRQHandler
    EXTERN CAN1_ORed_112_127_MB_IRQHandler
    EXTERN CAN2_ORed_IRQHandler
    EXTERN CAN2_Error_IRQHandler
    EXTERN CAN2_Wake_Up_IRQHandler
    EXTERN CAN2_ORed_0_15_MB_IRQHandler
    EXTERN CAN2_ORed_16_31_MB_IRQHandler
    EXTERN CAN2_ORed_32_47_MB_IRQHandler
    EXTERN CAN2_ORed_48_63_MB_IRQHandler
    EXTERN eTMR0_Ch0_Ch1_IRQHandler
    EXTERN eTMR0_Ch2_Ch3_IRQHandler
    EXTERN eTMR0_Ch4_Ch5_IRQHandler
    EXTERN eTMR0_Ch6_Ch7_IRQHandler
    EXTERN eTMR0_Fault_IRQHandler
    EXTERN eTMR0_Ovf_IRQHandler
    EXTERN eTMR1_Ch0_Ch1_IRQHandler
    EXTERN eTMR1_Ch2_Ch3_IRQHandler
    EXTERN eTMR1_Ch4_Ch5_IRQHandler
    EXTERN eTMR1_Ch6_Ch7_IRQHandler
    EXTERN eTMR1_Fault_IRQHandler
    EXTERN eTMR1_Ovf_IRQHandler
    EXTERN eTMR2_Ch0_Ch1_IRQHandler
    EXTERN eTMR2_Ch2_Ch3_IRQHandler
    EXTERN eTMR2_Ch4_Ch5_IRQHandler
    EXTERN eTMR2_Ch6_Ch7_IRQHandler
    EXTERN eTMR2_Fault_IRQHandler
    EXTERN eTMR2_Ovf_IRQHandler
    EXTERN eTMR3_Ch0_Ch1_IRQHandler
    EXTERN eTMR3_Ch2_Ch3_IRQHandler
    EXTERN eTMR3_Ch4_Ch5_IRQHandler
    EXTERN eTMR3_Ch6_Ch7_IRQHandler
    EXTERN eTMR3_Fault_IRQHandler
    EXTERN eTMR3_Ovf_IRQHandler
    EXTERN eTMR4_Ch0_Ch1_IRQHandler
    EXTERN eTMR4_Ch2_Ch3_IRQHandler
    EXTERN eTMR4_Ch4_Ch5_IRQHandler
    EXTERN eTMR4_Ch6_Ch7_IRQHandler
    EXTERN eTMR4_Fault_IRQHandler
    EXTERN eTMR4_Ovf_IRQHandler
    EXTERN eTMR5_Ch0_Ch1_IRQHandler
    EXTERN eTMR5_Ch2_Ch3_IRQHandler
    EXTERN eTMR5_Ch4_Ch5_IRQHandler
    EXTERN eTMR5_Ch6_Ch7_IRQHandler
    EXTERN eTMR5_Fault_IRQHandler
    EXTERN eTMR5_Ovf_IRQHandler
    EXTERN pTMR2_Ch0_IRQHandler
    EXTERN pTMR2_Ch1_IRQHandler
    EXTERN pTMR2_Ch2_IRQHandler
    EXTERN pTMR2_Ch3_IRQHandler
    EXTERN SENT0_IRQHandler
    EXTERN SENT1_IRQHandler
    EXTERN FMU_Alarm_IRQHandler
    EXTERN FMU_MISC_IRQHandler
    EXTERN TRNG_IRQHandler
    EXTERN HCU_IRQHandler
    EXTERN INTM_IRQHandler
    EXTERN TMR0_IRQHandler
    EXTERN LINFlexD3_IRQHandler
    EXTERN LINFlexD4_IRQHandler
    EXTERN LINFlexD5_IRQHandler
    EXTERN I2C2_Master_Slave_IRQHandler
    EXTERN SPI3_IRQHandler
    EXTERN SPI4_IRQHandler
    EXTERN SPI5_IRQHandler
    EXTERN CAN3_ORed_IRQHandler
    EXTERN CAN3_Error_IRQHandler
    EXTERN CAN3_Wake_Up_IRQHandler
    EXTERN CAN3_ORed_0_15_MB_IRQHandler
    EXTERN CAN3_ORed_16_31_MB_IRQHandler
    EXTERN CAN3_ORed_32_47_MB_IRQHandler
    EXTERN CAN3_ORed_48_63_MB_IRQHandler
    EXTERN CAN4_ORed_IRQHandler
    EXTERN CAN4_Error_IRQHandler
    EXTERN CAN4_Wake_Up_IRQHandler
    EXTERN CAN4_ORed_0_15_MB_IRQHandler
    EXTERN CAN4_ORed_16_31_MB_IRQHandler
    EXTERN CAN4_ORed_32_47_MB_IRQHandler
    EXTERN CAN4_ORed_48_63_MB_IRQHandler
    EXTERN CAN5_ORed_IRQHandler
    EXTERN CAN5_Error_IRQHandler
    EXTERN CAN5_Wake_Up_IRQHandler
    EXTERN CAN5_ORed_0_15_MB_IRQHandler
    EXTERN CAN5_ORed_16_31_MB_IRQHandler
    EXTERN WKU_IRQHandler
    EXTERN LINFlexD6_IRQHandler
    EXTERN LINFlexD7_IRQHandler
    EXTERN LINFlexD8_IRQHandler
    EXTERN LINFlexD9_IRQHandler
    EXTERN SPI6_IRQHandler
    EXTERN SPI7_IRQHandler
    EXTERN I2C3_Master_Slave_IRQHandler
    EXTERN I2C4_Master_Slave_IRQHandler
    EXTERN CAN6_ORed_IRQHandler
    EXTERN CAN6_Error_IRQHandler
    EXTERN CAN6_Wake_Up_IRQHandler
    EXTERN CAN6_ORed_0_15_MB_IRQHandler
    EXTERN CAN6_ORed_16_31_MB_IRQHandler
    EXTERN TMR1_IRQHandler
    EXTERN CORE_CTI_IRQHandler
    EXTERN SAI0_IRQHandler
    EXTERN SAI1_IRQHandler
    EXTERN ENET_IRQHandler
    EXTERN ENET_TX_IRQHandler
    EXTERN ENET_RX_IRQHandler
    EXTERN ENET_ECC_IRQHandler
    EXTERN CAN7_ORed_IRQHandler
    EXTERN CAN7_Error_IRQHandler
    EXTERN CAN7_Wake_Up_IRQHandler
    EXTERN CAN7_ORed_0_15_MB_IRQHandler
    EXTERN CAN7_ORed_16_31_MB_IRQHandler
    EXTERN MPWM0_Ch0_Ch7_IRQHandler
    EXTERN MPWM0_Ch8_Ch15_IRQHandler
    EXTERN MPWM1_Ch0_Ch7_IRQHandler
    EXTERN MPWM1_Ch8_Ch15_IRQHandler
    EXTERN MPWM2_Ch0_Ch7_IRQHandler
    EXTERN MPWM2_Ch8_Ch15_IRQHandler

__vector_table

    DCD STACK_end   /* Top of Stack for Initial Stack Pointer */
    DCD Reset_Handler             /* Reset Handler */
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD NMI_Handler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD HardFault_Handler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD MemManage_Handler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD BusFault_Handler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD UsageFault_Handler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD SVC_Handler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DebugMon_Handler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD PendSV_Handler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD SysTick_Handler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA0_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA1_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA2_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA3_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA4_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA5_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA6_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA7_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA8_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA9_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA10_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA11_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA12_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA13_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA14_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA15_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA16_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA17_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA18_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA19_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA20_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA21_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA22_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA23_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA24_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA25_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA26_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA27_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA28_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA29_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA30_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA31_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA_Error_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD FPU_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD EFM_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD EFM_Error_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD PCU_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD EFM_Ecc_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD Wdg_Lld_Isr
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD I2C0_Master_Slave_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD SPI0_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD SPI1_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD SPI2_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD I2C1_Master_Slave_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD LINFlexD0_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD LINFlexD1_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD LINFlexD2_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD QSPI_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD ADC0_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD ADC1_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD ACMP0_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD ACMP1_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD EMU_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD RTC_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD RTC_Seconds_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD pTMR0_Ch0_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD pTMR0_Ch1_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD pTMR0_Ch2_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD pTMR0_Ch3_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD PTU0_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD pTMR1_Ch0_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD pTMR1_Ch1_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD pTMR1_Ch2_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD pTMR1_Ch3_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD SCU_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD lpTMR0_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD GPIOA_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD GPIOB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD GPIOC_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD GPIOD_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD GPIOE_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD PTU1_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN0_ORed_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN0_Error_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN0_Wake_Up_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN0_ORed_0_15_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN0_ORed_16_31_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN0_ORed_32_47_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN0_ORed_48_63_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN0_ORed_64_79_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN0_ORed_80_95_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN0_ORed_96_111_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN0_ORed_112_127_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN1_ORed_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN1_Error_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN1_Wake_Up_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN1_ORed_0_15_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN1_ORed_16_31_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN1_ORed_32_47_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN1_ORed_48_63_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN1_ORed_64_79_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN1_ORed_80_95_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN1_ORed_96_111_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN1_ORed_112_127_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN2_ORed_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN2_Error_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN2_Wake_Up_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN2_ORed_0_15_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN2_ORed_16_31_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN2_ORed_32_47_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN2_ORed_48_63_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR0_Ch0_Ch1_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR0_Ch2_Ch3_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR0_Ch4_Ch5_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR0_Ch6_Ch7_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR0_Fault_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR0_Ovf_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR1_Ch0_Ch1_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR1_Ch2_Ch3_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR1_Ch4_Ch5_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR1_Ch6_Ch7_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR1_Fault_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR1_Ovf_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR2_Ch0_Ch1_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR2_Ch2_Ch3_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR2_Ch4_Ch5_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR2_Ch6_Ch7_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR2_Fault_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR2_Ovf_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR3_Ch0_Ch1_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR3_Ch2_Ch3_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR3_Ch4_Ch5_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR3_Ch6_Ch7_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR3_Fault_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR3_Ovf_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR4_Ch0_Ch1_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR4_Ch2_Ch3_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR4_Ch4_Ch5_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR4_Ch6_Ch7_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR4_Fault_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR4_Ovf_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR5_Ch0_Ch1_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR5_Ch2_Ch3_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR5_Ch4_Ch5_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR5_Ch6_Ch7_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR5_Fault_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR5_Ovf_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD pTMR2_Ch0_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD pTMR2_Ch1_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD pTMR2_Ch2_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD pTMR2_Ch3_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD SENT0_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD SENT1_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD FMU_Alarm_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD FMU_MISC_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD TRNG_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD HCU_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD INTM_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD TMR0_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD LINFlexD3_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD LINFlexD4_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD LINFlexD5_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD I2C2_Master_Slave_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD SPI3_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD SPI4_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD SPI5_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN3_ORed_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN3_Error_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN3_Wake_Up_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN3_ORed_0_15_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN3_ORed_16_31_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN3_ORed_32_47_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN3_ORed_48_63_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN4_ORed_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN4_Error_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN4_Wake_Up_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN4_ORed_0_15_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN4_ORed_16_31_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN4_ORed_32_47_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN4_ORed_48_63_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN5_ORed_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN5_Error_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN5_Wake_Up_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN5_ORed_0_15_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN5_ORed_16_31_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD WKU_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD LINFlexD6_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD LINFlexD7_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD LINFlexD8_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD LINFlexD9_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD SPI6_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD SPI7_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD I2C3_Master_Slave_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD I2C4_Master_Slave_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN6_ORed_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN6_Error_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN6_Wake_Up_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN6_ORed_0_15_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN6_ORed_16_31_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD TMR1_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CORE_CTI_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD SAI0_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD SAI1_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD ENET_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD ENET_TX_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD ENET_RX_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD ENET_ECC_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN7_ORed_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN7_Error_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN7_Wake_Up_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN7_ORed_0_15_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN7_ORed_16_31_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD MPWM0_Ch0_Ch7_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD MPWM0_Ch8_Ch15_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD MPWM1_Ch0_Ch7_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD MPWM1_Ch8_Ch15_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD MPWM2_Ch0_Ch7_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD MPWM2_Ch8_Ch15_IRQHandler
#endif
    END

