/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file undefined
 * @brief 
 * 
 */


#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
 *                                        INCLUDE FILES
==================================================================================================*/
#include "Pwm_PBcfg.h"
#include "Pwm_Lld_Mpwm_PBcfg.h"

/*==================================================================================================
 *                                 SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define PWM_VENDOR_ID_PBCFG_C                      (180)
#define PWM_AR_RELEASE_MAJOR_VERSION_PBCFG_C       (4)
#define PWM_AR_RELEASE_MINOR_VERSION_PBCFG_C       (4)
#define PWM_AR_RELEASE_REVISION_VERSION_PBCFG_C    (0)
#define PWM_SW_MAJOR_VERSION_PBCFG_C               (1)
#define PWM_SW_MINOR_VERSION_PBCFG_C               (0)
#define PWM_SW_PATCH_VERSION_PBCFG_C               (0)

/*==================================================================================================
 *                                        GLOBAL CONSTANTS                                        
==================================================================================================*/
#define PWM_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Pwm_MemMap.h"

/**
 * @brief   PWM channels configuration array
 */
PWM_CONST static const Pwm_ChannelConfigType Pwm_ChannelConfigs[PWM_PBCFG_CHANNELS_COUNT] = 
{
/* PwmChannel_0 */
    {
        .ChannelId = 0U,
        .ChannelClass = PWM_VARIABLE_PERIOD,
        .MldChCfg = 
        {
            .ChInstId = PWM_LLD_MPWM_INST_ID_MPWM_0_CH_0,
            .ChType = PWM_MLD_CHN_MPWM,
            .ChDutyCycle = 0x4000U,
            .MpwmChCfg = &Pwm_Lld_Mpwm_ChCfg_Inst0_Ch0
        },
        .ChannelIdleState = PWM_LOW,
#if (PWM_NOTIFICATION_SUPPORTED == STD_ON)
        .ChannelNotification = NULL_PTR
#endif
    },
};

/**
 * @brief   PWM instances configuration array
 */
PWM_CONST static const Pwm_Mld_InstCfgType Pwm_InstanceConfigs[PWM_PBCFG_INSTANCES_COUNT] =
{
/* PwmMpwm_0 */
    {
        .InstId = 0U,
        .InstType = PWM_MLD_INST_MPWM
    },
};

/**
 * @brief   PWM configuration
 */
PWM_CONST const Pwm_ConfigType Pwm_Config = 
{
    .ChannelCount = PWM_PBCFG_CHANNELS_COUNT,
    .PwmChannelsConfig = &Pwm_ChannelConfigs,
    .InstanceCount = PWM_PBCFG_INSTANCES_COUNT,   
    .PwmInstancesConfig = &Pwm_InstanceConfigs
};

#define PWM_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Pwm_MemMap.h"

#ifdef __cplusplus
}
#endif

/** @} */

