/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file Pwm_Mld_Cfg.h
 * @brief 
 * 
 */


#ifndef PWM_MLD_CFG_H
#define PWM_MLD_CFG_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
 *                                        INCLUDE FILES
==================================================================================================*/
#include "Std_Types.h"

/*==================================================================================================
 *                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define PWM_MLD_CFG_VENDOR_ID                      (180)
#define PWM_MLD_CFG_AR_RELEASE_MAJOR_VERSION       (4)
#define PWM_MLD_CFG_AR_RELEASE_MINOR_VERSION       (4)
#define PWM_MLD_CFG_AR_RELEASE_REVISION_VERSION    (0)
#define PWM_MLD_CFG_SW_MAJOR_VERSION               (1)
#define PWM_MLD_CFG_SW_MINOR_VERSION               (0)
#define PWM_MLD_CFG_SW_PATCH_VERSION               (0)

/*==================================================================================================
 *                                       DEFINES AND MACROS
==================================================================================================*/
/**
 * @brief   ETMR is used as PWM or not
 */
#define PWM_ETMR_USED    (STD_OFF)

/**
 * @brief   MPWM is used as PWM or not
 */
#define PWM_MPWM_USED    (STD_ON)

#ifdef __cplusplus
}
#endif

#endif /* PWM_MLD_CFG_H */

/** @} */

