/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file Pwm_Lld_Mpwm_PBcfg.h
 * @brief 
 * 
 */


#ifndef PWM_LLD_MPWM_PBCFG_H
#define PWM_LLD_MPWM_PBCFG_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
 *                                        INCLUDE FILES
==================================================================================================*/
#include "Pwm_Lld_Mpwm_Types.h"

/*==================================================================================================
 *                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define PWM_LLD_MPWM_VENDOR_ID_PBCFG                      (180)
#define PWM_LLD_MPWM_AR_RELEASE_MAJOR_VERSION_PBCFG       (4)
#define PWM_LLD_MPWM_AR_RELEASE_MINOR_VERSION_PBCFG       (4)
#define PWM_LLD_MPWM_AR_RELEASE_REVISION_VERSION_PBCFG    (0)
#define PWM_LLD_MPWM_SW_MAJOR_VERSION_PBCFG               (1)
#define PWM_LLD_MPWM_SW_MINOR_VERSION_PBCFG               (0)
#define PWM_LLD_MPWM_SW_PATCH_VERSION_PBCFG               (0)

/*==================================================================================================
 *                                       DEFINES AND MACROS                                       
==================================================================================================*/

/* eTMR instance index for instance configuration PwmMpwm_0 */
/* Channel configuration PwmMpwmCh_0 */
#define PWM_LLD_MPWM_INST_ID_MPWM_0_CH_0  (0U)

/*==================================================================================================
 *                                  GLOBAL CONSTANTS DECLARATIONS                                  
==================================================================================================*/
#define PWM_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Pwm_MemMap.h"

/*================================================================================================*/
/* User configuration structure PwmMpwm_0 */
PWM_CONST extern const Pwm_Lld_Mpwm_CfgType Pwm_Lld_Mpwm_Cfg_Inst0;
/* Channel configuration PwmMpwmCh_0 */
PWM_CONST extern const Pwm_Lld_Mpwm_ChCfgType Pwm_Lld_Mpwm_ChCfg_Inst0_Ch0;

#define PWM_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Pwm_MemMap.h"

/*==================================================================================================
 *                                      FUNCTION PROTOTYPES
==================================================================================================*/
#ifdef __cplusplus
}
#endif

#endif /* PWM_LLD_MPWM_PBCFG_H */

/** @} */

