/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file Pwm_Lld_Mpwm_PBcfg.c
 * @brief 
 * 
 */


#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
 *                                        INCLUDE FILES
==================================================================================================*/
#include "Pwm_Lld_Mpwm_PBcfg.h"

/*==================================================================================================
 *                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define PWM_LLD_MPWM_VENDOR_ID_PBCFG_C                      (180)
#define PWM_LLD_MPWM_AR_RELEASE_MAJOR_VERSION_PBCFG_C       (4)
#define PWM_LLD_MPWM_AR_RELEASE_MINOR_VERSION_PBCFG_C       (4)
#define PWM_LLD_MPWM_AR_RELEASE_REVISION_VERSION_PBCFG_C    (0)
#define PWM_LLD_MPWM_SW_MAJOR_VERSION_PBCFG_C               (1)
#define PWM_LLD_MPWM_SW_MINOR_VERSION_PBCFG_C               (0)
#define PWM_LLD_MPWM_SW_PATCH_VERSION_PBCFG_C               (0)

/*==================================================================================================
 *                                         GLOBAL CONSTANTS                                         
==================================================================================================*/
#define PWM_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Pwm_MemMap.h"
        
/*================================================================================================*/
/* Channel configuration PwmMpwmCh_0 */
PWM_CONST const Pwm_Lld_Mpwm_ChCfgType Pwm_Lld_Mpwm_ChCfg_Inst0_Ch0 = 
{
    .DebugModeEn = STD_ON,
    .CmpMatchTrigEn = STD_OFF,
    .PeriodMatchTrigEn = STD_ON,
    .OvfIrqEn = STD_OFF,
    .ChIrqEn = STD_OFF,
    .ChannelId = 0U,
    .Period = 10000U,
    .DutyCycle = 16384U,
    .ClockPrescaler = PWM_LLD_MPWM_CLK_DIV_1,
    .ReloadSource = PWM_LLD_MPWM_RLD_SRC_PERIOD,
    .AlignMode = PWM_LLD_MPWM_ALIGN_MODE_LEFT_EDGE,
    .Polarity = PWM_LLD_MPWM_POLARITY_INVERT,
    .IdleState = PWM_LLD_MPWM_OUTPUT_STATE_LOW,
    .OvfCallback = NULL_PTR,
    .ChCallback = NULL_PTR
};

PWM_CONST static const Pwm_Lld_Mpwm_ChCfgType * const Pwm_Lld_Mpwm_ChCfgArr_Inst0[1U] = 
{
    &Pwm_Lld_Mpwm_ChCfg_Inst0_Ch0,
};

/* User configuration structure PwmMpwm_0 */
PWM_CONST const Pwm_Lld_Mpwm_CfgType Pwm_Lld_Mpwm_Cfg_Inst0 = 
{
    .ChannelCount = 1U,
    .ChCfgArr = Pwm_Lld_Mpwm_ChCfgArr_Inst0
};

#define PWM_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Pwm_MemMap.h"

#ifdef __cplusplus
}
#endif

/** @} */

