/*
* @file    CddTrg_Cfg.h
*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : CddTrg_Cfg
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V1.0.0.HF001
*
*   (c) Copyright 2020-2025 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifndef CDDTRG_CFG_H
#define CDDTRG_CFG_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
                                              INCLUDE FILES
==================================================================================================*/
/*==================================================================================================
                                      HEADER FILE VERSION INFORMATION
==================================================================================================*/
#define CDDTRG_CFG_VENDOR_ID                      (180)
#define CDDTRG_CFG_AR_RELEASE_MAJOR_VERSION       (4)
#define CDDTRG_CFG_AR_RELEASE_MINOR_VERSION       (4)
#define CDDTRG_CFG_AR_RELEASE_REVISION_VERSION    (0)
#define CDDTRG_CFG_SW_MAJOR_VERSION               (1)
#define CDDTRG_CFG_SW_MINOR_VERSION               (0)
#define CDDTRG_CFG_SW_PATCH_VERSION               (0)
/*==================================================================================================
                                                DEFINES AND MACROS
==================================================================================================*/
/**
* @brief            Pre-compile Support.
*/
#define CDDTRG_FIXED_PB_CONFIG                    (STD_OFF)


/**
* @brief   Switches the Development Error Detection and Notification ON or OFF.
*/
#define CDDTRG_DEV_ERROR_DETECT                   (STD_OFF)

/**
 * @brief   Switches the Version Information API ON or OFF.
 */
#define CDDTRG_VERSION_INFO_API                   (STD_ON)

/**
 * @brief        Adds / removes the service CddTrg_DeInit() from the code.
 */
#define CDDTRG_DE_INIT_API                        (STD_ON)

/**
 * @brief        Adds / removes the service CddTrg_SetTmuTriggerSource() from the code.
 */
#define CDDTRG_SET_TMU_TRIGGER_SOURCE_API         (STD_ON)

/**
 * @brief        Adds / removes the service CddTrg_GetTmuTriggerTarget() from the code.
 */
#define CDDTRG_GET_TMU_TRIGGER_SOURCE_API          (STD_ON)   

/**
 * @brief        Adds / removes the service CddTrg_EnablePtuInstance() and CddTrg_DisablePtuInstance() from the code.
 */
#define CDDTRG_ENABLE_PTU_INSTANCE_API            (STD_OFF)

/**
 * @brief        Adds / removes the service CddTrg_SetPtuSoftTrigger() from the code.
 */
#define CDDTRG_SET_PTU_SOFT_TRIGGER_API           (STD_OFF)

/**
 * @brief        Adds / removes the service for modify the mod time, interrupt delay time and channel trigger delay time from the code.
 */
#define CDDTRG_SET_PTU_TIMER_API                  (STD_OFF)

#ifdef CDDTRG_USER_MODE_SUPPORT
#ifndef MCAL_ENABLE_USER_MODE_SUPPORT
#error "Must define MCAL_ENABLE_USER_MODE_SUPPORT if CDDTRG_USER_MODE_SUPPORT is defined"
#endif
#endif

/**
* @brief Support for SchM: sync/atomic operations, global interrupt disable/enable.
*        If this parameter has been configured to 'STD_ON', the MCAL driver code supports sync/atomic operations for key resource protection.
*        If it is enabled, all the SchM codes in MCAL Adc driver codes will work and support sync/atomic operation with CPU global interrupt
*        enable/disable for key resource protection.Disable it can reduce code size, but may cause potential risks when access to some critical
*        resource!
*/
#define CDDTRG_SCHM_SUPPORT  (STD_ON) 

/*The Tmu feature defined*/
#define CDDTRG_TMU_ENABLE

#define CDDTRG_TMU_LINKER_TOTAL_COUNT   (128U)




/*==================================================================================================
                                                EXTERNAL CONSTANTS
==================================================================================================*/
/*==================================================================================================
                                                ENUMS
==================================================================================================*/
/**
 * @brief   Definition of Tmu module item
 */
typedef enum {
    TMU_TRIG_SOURCE_DISABLED = 0,
    TMU_TRIG_SOURCE_VDD = 1,
    TMU_TRIG_SOURCE_TMU_IN0 = 2,
    TMU_TRIG_SOURCE_TMU_IN1 = 3,
    TMU_TRIG_SOURCE_TMU_IN2 = 4,
    TMU_TRIG_SOURCE_TMU_IN3 = 5,
    TMU_TRIG_SOURCE_TMU_IN4 = 6,
    TMU_TRIG_SOURCE_TMU_IN5 = 7,
    TMU_TRIG_SOURCE_TMU_IN6 = 8,
    TMU_TRIG_SOURCE_TMU_IN7 = 9,
    TMU_TRIG_SOURCE_TMU_IN8 = 10,
    TMU_TRIG_SOURCE_TMU_IN9 = 11,
    TMU_TRIG_SOURCE_TMU_IN10 = 12,
    TMU_TRIG_SOURCE_TMU_IN11 = 13,
    TMU_TRIG_SOURCE_ACMP0_OUT = 14,
    TMU_TRIG_SOURCE_ACMP1_OUT = 15,
    TMU_TRIG_SOURCE_pTMR_CH0 = 17,
    TMU_TRIG_SOURCE_pTMR_CH1 = 18,
    TMU_TRIG_SOURCE_pTMR_CH2 = 19,
    TMU_TRIG_SOURCE_pTMR_CH3 = 20,
    TMU_TRIG_SOURCE_lpTMR0 = 21,
    TMU_TRIG_SOURCE_eTMR0_INIT_TRIG = 22,
    TMU_TRIG_SOURCE_eTMR0_EXT_TRIG = 23,
    TMU_TRIG_SOURCE_eTMR1_INIT_TRIG = 24,
    TMU_TRIG_SOURCE_eTMR1_EXT_TRIG = 25,
    TMU_TRIG_SOURCE_eTMR2_INIT_TRIG = 26,
    TMU_TRIG_SOURCE_eTMR2_EXT_TRIG = 27,
    TMU_TRIG_SOURCE_eTMR3_INIT_TRIG = 28,
    TMU_TRIG_SOURCE_eTMR3_EXT_TRIG = 29,
    TMU_TRIG_SOURCE_ADC0_EOC = 30,
    TMU_TRIG_SOURCE_ADC0_AWD = 31,
    TMU_TRIG_SOURCE_ADC1_EOC = 32,
    TMU_TRIG_SOURCE_ADC1_AWD = 33,
    TMU_TRIG_SOURCE_PTU0_TRIG = 34,
    TMU_TRIG_SOURCE_PTU0_PULSE_OUT = 36,
    TMU_TRIG_SOURCE_PTU1_TRIG = 37,
    TMU_TRIG_SOURCE_PTU1_PULSE_OUT = 39,
    TMU_TRIG_SOURCE_RTC_ALARM = 43,
    TMU_TRIG_SOURCE_RTC_SECOND = 44,
    TMU_TRIG_SOURCE_I2C0_MASTER_TRIG = 55,
    TMU_TRIG_SOURCE_I2C0_SLAVE_TRIG = 56,
    TMU_TRIG_SOURCE_SPI0_FRAME = 59,
    TMU_TRIG_SOURCE_SPI0_RX_DATA = 60,
    TMU_TRIG_SOURCE_SPI1_FRAME = 61,
    TMU_TRIG_SOURCE_SPI1_RX_DATA = 62,
    TMU_TRIG_SOURCE_CIM_SW_TRIG = 63,
    TMU_TRIG_SOURCE_I2C1_MASTER_TRIG = 67,
    TMU_TRIG_SOURCE_I2C1_SLAVE_TRIG = 68,
    TMU_TRIG_SOURCE_eTMR4_INIT_TRIG = 69,
    TMU_TRIG_SOURCE_eTMR4_EXT_TRIG = 70,
    TMU_TRIG_SOURCE_eTMR5_INIT_TRIG = 71,
    TMU_TRIG_SOURCE_eTMR5_EXT_TRIG = 72,
    TMU_TRIG_SOURCE_SPI2_FRAME = 77,
    TMU_TRIG_SOURCE_SPI2_RX_DATA = 78,
    TMU_TRIG_SOURCE_SPI3_FRAME = 79,
    TMU_TRIG_SOURCE_SPI3_RX_DATA = 80,
    TMU_TRIG_SOURCE_SPI4_FRAME = 81,
    TMU_TRIG_SOURCE_SPI4_RX_DATA = 82,
    TMU_TRIG_SOURCE_SPI5_FRAME = 83,
    TMU_TRIG_SOURCE_SPI5_RX_DATA = 84,
    TMU_TRIG_SOURCE_I2C2_MASTER_TRIG = 85,
    TMU_TRIG_SOURCE_I2C2_SLAVE_TRIG = 86,
    TMU_TRIG_SOURCE_PTMR1_CH0 = 87,
    TMU_TRIG_SOURCE_PTMR1_CH1 = 88,
    TMU_TRIG_SOURCE_PTMR1_CH2 = 89,
    TMU_TRIG_SOURCE_PTMR1_CH3 = 90,
    TMU_TRIG_SOURCE_PTMR2_CH0 = 91,
    TMU_TRIG_SOURCE_PTMR2_CH1 = 92,
    TMU_TRIG_SOURCE_PTMR2_CH2 = 93,
    TMU_TRIG_SOURCE_PTMR2_CH3 = 94,
    TMU_TRIG_SOURCE_I2C3_MASTER_TRIG = 100,
    TMU_TRIG_SOURCE_I2C3_SLAVE_TRIG = 101,
    TMU_TRIG_SOURCE_I2C4_MASTER_TRIG = 102,
    TMU_TRIG_SOURCE_I2C4_SLAVE_TRIG = 103,
    TMU_TRIG_SOURCE_SPI6_FRAME = 104,
    TMU_TRIG_SOURCE_SPI6_RX_DATA = 105,
    TMU_TRIG_SOURCE_SPI7_FRAME = 106,
    TMU_TRIG_SOURCE_SPI7_RX_DATA = 107,
    TMU_TRIG_SOURCE_CM7_TXEV = 110,
    TMU_TRIG_SOURCE_FMU_ERR_DO0 = 112,
    TMU_TRIG_SOURCE_FMU_ERR_DO1 = 113,
    TMU_TRIG_SOURCE_MPWM0_TRIG_OUT0_3 = 116,
    TMU_TRIG_SOURCE_MPWM0_TRIG_OUT4_7 = 117,
    TMU_TRIG_SOURCE_MPWM0_TRIG_OUT8_11 = 118,
    TMU_TRIG_SOURCE_MPWM0_TRIG_OUT12_15 = 119,
    TMU_TRIG_SOURCE_MPWM1_TRIG_OUT0_3 = 120,
    TMU_TRIG_SOURCE_MPWM1_TRIG_OUT4_7 = 121,
    TMU_TRIG_SOURCE_MPWM1_TRIG_OUT8_11 = 122,
    TMU_TRIG_SOURCE_MPWM1_TRIG_OUT12_15 = 123,
    TMU_TRIG_SOURCE_MPWM2_TRIG_OUT0_3 = 124,
    TMU_TRIG_SOURCE_MPWM2_TRIG_OUT4_7 = 125,
    TMU_TRIG_SOURCE_MPWM2_TRIG_OUT8_11 = 126,
    TMU_TRIG_SOURCE_MPWM2_TRIG_OUT12_15 = 127,
}CddTrg_TmuTriggerSourceType;

typedef enum {
    TMU_TRIG_TARGET_TMU_OUT0 = 4,
    TMU_TRIG_TARGET_TMU_OUT1 = 5,
    TMU_TRIG_TARGET_TMU_OUT2 = 6,
    TMU_TRIG_TARGET_TMU_OUT3 = 7,
    TMU_TRIG_TARGET_TMU_OUT4 = 8,
    TMU_TRIG_TARGET_TMU_OUT5 = 9,
    TMU_TRIG_TARGET_TMU_OUT6 = 10,
    TMU_TRIG_TARGET_TMU_OUT7 = 11,
    TMU_TRIG_TARGET_ADC0_EXT_TRIG0 = 12,
    TMU_TRIG_TARGET_ADC0_EXT_TRIG1 = 13,
    TMU_TRIG_TARGET_ADC0_EXT_TRIG2 = 14,
    TMU_TRIG_TARGET_ADC0_EXT_TRIG3 = 15,
    TMU_TRIG_TARGET_ADC1_EXT_TRIG0 = 16,
    TMU_TRIG_TARGET_ADC1_EXT_TRIG1 = 17,
    TMU_TRIG_TARGET_ADC1_EXT_TRIG2 = 18,
    TMU_TRIG_TARGET_ADC1_EXT_TRIG3 = 19,
    TMU_TRIG_TARGET_TMU_OUT8 = 24,
    TMU_TRIG_TARGET_TMU_OUT9 = 25,
    TMU_TRIG_TARGET_TMU_OUT10 = 26,
    TMU_TRIG_TARGET_TMU_OUT11 = 27,
    TMU_TRIG_TARGET_ACMP0_SAMPLE_INPUT = 28,
    TMU_TRIG_TARGET_ACMP1_SAMPLE_INPUT = 29,
    TMU_TRIG_TARGET_MPWM_TRIG0 = 30,
    TMU_TRIG_TARGET_MPWM_TRIG1 = 31,
    TMU_TRIG_TARGET_MPWM_TRIG2 = 32,
    TMU_TRIG_TARGET_MPWM_TRIG3 = 33,
    TMU_TRIG_TARGET_MPWM_TRIG4 = 34,
    TMU_TRIG_TARGET_MPWM_TRIG5 = 35,
    TMU_TRIG_TARGET_MPWM_TRIG6 = 36,
    TMU_TRIG_TARGET_MPWM_TRIG7 = 37,
    TMU_TRIG_TARGET_eTMR0_HWTRIG0 = 40,
    TMU_TRIG_TARGET_eTMR0_FAULT0 = 41,
    TMU_TRIG_TARGET_eTMR0_FAULT1 = 42,
    TMU_TRIG_TARGET_eTMR0_FAULT2 = 43,
    TMU_TRIG_TARGET_eTMR1_HWTRIG1 = 44,
    TMU_TRIG_TARGET_eTMR1_FAULT0 = 45,
    TMU_TRIG_TARGET_eTMR1_FAULT1 = 46,
    TMU_TRIG_TARGET_eTMR1_FAULT2 = 47,
    TMU_TRIG_TARGET_eTMR2_HWTRIG2 = 48,
    TMU_TRIG_TARGET_eTMR2_FAULT0 = 49,
    TMU_TRIG_TARGET_eTMR2_FAULT1 = 50,
    TMU_TRIG_TARGET_eTMR2_FAULT2 = 51,
    TMU_TRIG_TARGET_eTMR3_HWTRIG3 = 52,
    TMU_TRIG_TARGET_eTMR3_FAULT0 = 53,
    TMU_TRIG_TARGET_eTMR3_FAULT1 = 54,
    TMU_TRIG_TARGET_eTMR3_FAULT2 = 55,
    TMU_TRIG_TARGET_PTU0_TRIG_IN = 56,
    TMU_TRIG_TARGET_PTU1_TRIG_IN = 60,
    TMU_TRIG_TARGET_eTMR0_CH0_IN = 64,
    TMU_TRIG_TARGET_eTMR0_CH1_IN = 65,
    TMU_TRIG_TARGET_eTMR0_CH2_IN = 66,
    TMU_TRIG_TARGET_eTMR0_CH3_IN = 67,
    TMU_TRIG_TARGET_eTMR1_CH0_IN = 68,
    TMU_TRIG_TARGET_eTMR1_CH1_IN = 69,
    TMU_TRIG_TARGET_eTMR1_CH2_IN = 70,
    TMU_TRIG_TARGET_eTMR1_CH3_IN = 71,
    TMU_TRIG_TARGET_eTMR2_CH0_IN = 72,
    TMU_TRIG_TARGET_eTMR2_CH1_IN = 73,
    TMU_TRIG_TARGET_eTMR2_CH2_IN = 74,
    TMU_TRIG_TARGET_eTMR2_CH3_IN = 75,
    TMU_TRIG_TARGET_LINFlexD0_TRIG = 76,
    TMU_TRIG_TARGET_LINFlexD1_TRIG = 77,
    TMU_TRIG_TARGET_LINFlexD2_TRIG = 78,
    TMU_TRIG_TARGET_LINFlexD3_TRIG = 79,
    TMU_TRIG_TARGET_LINFlexD4_TRIG = 80,
    TMU_TRIG_TARGET_LINFlexD5_TRIG = 81,
    TMU_TRIG_TARGET_LINFlexD6_TRIG = 82,
    TMU_TRIG_TARGET_LINFlexD7_TRIG = 83,
    TMU_TRIG_TARGET_I2C0_TRIG = 84,
    TMU_TRIG_TARGET_LINFlexD8_TRIG = 85,
    TMU_TRIG_TARGET_LINFlexD9_TRIG = 86,
    TMU_TRIG_TARGET_eTMR3_CH0_IN = 88,
    TMU_TRIG_TARGET_eTMR3_CH1_IN = 89,
    TMU_TRIG_TARGET_eTMR3_CH2_IN = 90,
    TMU_TRIG_TARGET_eTMR3_CH3_IN = 91,
    TMU_TRIG_TARGET_SPI0_TRIG = 92,
    TMU_TRIG_TARGET_SPI1_TRIG = 96,
    TMU_TRIG_TARGET_SPI2_TRIG = 97,
    TMU_TRIG_TARGET_SPI3_TRIG = 98,
    TMU_TRIG_TARGET_SPI4_TRIG = 99,
    TMU_TRIG_TARGET_lpTMR0_ALT0 = 100,
    TMU_TRIG_TARGET_CM7_RXEV = 101,
    TMU_TRIG_TARGET_SPI5_TRIG = 104,
    TMU_TRIG_TARGET_SPI6_TRIG = 105,
    TMU_TRIG_TARGET_SPI7_TRIG = 106,
    TMU_TRIG_TARGET_I2C1_TRIG = 108,
    TMU_TRIG_TARGET_I2C2_TRIG = 109,
    TMU_TRIG_TARGET_I2C3_TRIG = 110,
    TMU_TRIG_TARGET_I2C4_TRIG = 111,
    TMU_TRIG_TARGET_eTMR4_HWTRIG0 = 112,
    TMU_TRIG_TARGET_eTMR5_HWTRIG0 = 116,
    TMU_TRIG_TARGET_MPWM_TRIG8 = 119,
    TMU_TRIG_TARGET_MPWM_TRIG9 = 120,
    TMU_TRIG_TARGET_MPWM_TRIG10 = 121,
    TMU_TRIG_TARGET_MPWM_TRIG11 = 122,
    TMU_TRIG_TARGET_MPWM_TRIG12 = 123,
    TMU_TRIG_TARGET_MPWM_TRIG13 = 124,
    TMU_TRIG_TARGET_MPWM_TRIG14 = 125,
    TMU_TRIG_TARGET_MPWM_TRIG15 = 126,
}CddTrg_TmuTriggerTargetType;



/*==================================================================================================
                                                FUNCTION PROTOTYPES
==================================================================================================*/
#ifdef __cplusplus
}
#endif

#endif /* End of file CddTrg_Cfg.h */

