/**
* @file    CddTrg_Cfg.c
*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : CddTrg_Cfg
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V1.0.0.HF001
*
*   (c) Copyright 2020-2025 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifdef __cplusplus
extern "C"
{
#endif

/*==================================================================================================
                                              INCLUDE FILES
==================================================================================================*/
#include "CddTrg.h"
/*==================================================================================================
                                      SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define CDDTRG_CFG_VENDOR_ID_C                      (180)
#define CDDTRG_CFG_AR_RELEASE_MAJOR_VERSION_C       (4)
#define CDDTRG_CFG_AR_RELEASE_MINOR_VERSION_C       (4)
#define CDDTRG_CFG_AR_RELEASE_REVISION_VERSION_C    (0)
#define CDDTRG_CFG_SW_MAJOR_VERSION_C               (1)
#define CDDTRG_CFG_SW_MINOR_VERSION_C               (0)
#define CDDTRG_CFG_SW_PATCH_VERSION_C               (0)
/*==================================================================================================
                                            FILE VERSION CHECKS
==================================================================================================*/
/* Check if source file and CDDTRG_CFG header file are of the same vendor */
#if (CDDTRG_CFG_VENDOR_ID_C != CDDTRG_CFG_VENDOR_ID)
#error "CddTrg_Cfg.c and CddTrg_Cfg.h have different vendor ids"
#endif

/* Check if source file and CDDTRG_CFG header file are of the same Autosar version */
#if (( CDDTRG_CFG_AR_RELEASE_MAJOR_VERSION_C != CDDTRG_CFG_AR_RELEASE_MAJOR_VERSION) || \
      ( CDDTRG_CFG_AR_RELEASE_MINOR_VERSION_C != CDDTRG_CFG_AR_RELEASE_MINOR_VERSION) || \
      ( CDDTRG_CFG_AR_RELEASE_REVISION_VERSION_C != CDDTRG_CFG_AR_RELEASE_REVISION_VERSION))
#error "AutoSar Version Numbers of CddTrg_Cfg.c and CddTrg_Cfg.h are different"
#endif

/* Check if source file and CDDTRG_CFG header file are of the same Software version */
#if (( CDDTRG_CFG_SW_MAJOR_VERSION_C != CDDTRG_CFG_SW_MAJOR_VERSION) || \
      ( CDDTRG_CFG_SW_MINOR_VERSION_C != CDDTRG_CFG_SW_MINOR_VERSION) || \
      ( CDDTRG_CFG_SW_PATCH_VERSION_C != CDDTRG_CFG_SW_PATCH_VERSION))
#error "Software Version Numbers of CddTrg_Cfg.c and CddTrg_Cfg.h are different"
#endif

/*==================================================================================================
                                                GLOBAL VARIABLES
==================================================================================================*/
/*==================================================================================================
                                                LOCAL VARIABLES
==================================================================================================*/
/*==================================================================================================
                                                LOCAL CONSTANTS
==================================================================================================*/
/*==================================================================================================
                                                LOCAL MACROS
==================================================================================================*/
/*==================================================================================================
                                                LOCAL FUNCTIONS
==================================================================================================*/
/*==================================================================================================
                                                GLOBAL FUNCTIONS
==================================================================================================*/

#ifdef __cplusplus
}
#endif

/* End of file CddTrg_Cfg.c */

