/*
 *  Copyright 2020-2024 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file undefined
 * @brief 
 * 
 */

#include "Adc.h"
#include "Adc_Cfg.h"
#ifdef ADC_DMA_SUPPORTED
#include "CddDma_Cfg.h"
#endif

/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define ADC_VENDOR_ID_PBCFG_C                      (180)
#define ADC_AR_RELEASE_MAJOR_VERSION_PBCFG_C       (4)
#define ADC_AR_RELEASE_MINOR_VERSION_PBCFG_C       (4)
#define ADC_AR_RELEASE_REVISION_VERSION_PBCFG_C    (0)
#define ADC_SW_MAJOR_VERSION_PBCFG_C               (1)
#define ADC_SW_MINOR_VERSION_PBCFG_C               (0)
#define ADC_SW_PATCH_VERSION_PBCFG_C               (0)

/*================================================================================================== */
/**
 * @brief          Config number of ADC Hw units.
 */
#define ADC_UNIT_NUMBER                         (1U)

/**
 * @brief          Max number of ADC Hw units.
 */
#define ADC_GROUP_NUMBER                        (1U)

/*****************************************************************************************************/
extern void Adc0_HwTrgGroupNotification(void); 

#define ADC_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Adc_MemMap.h"

/*Group channels definetion*/
ADC_CONST static const Adc_ChannelType Adc0_HwTrgGroup_Channel[4] = 
{
    ADC0_VDD_INT0_ADCH37,
    ADC0_PMCVREF_INT0_ADCH33,
    ADC0_VDD25_INT0_ADCH39,
    ADC0_TEMP_INT0_ADCH32,
};

/**/

ADC_CONST static const Adc_GroupDefType Adc0_HwTrgGroup_ChannelsInf = 
{
    .GroupChannels       = &Adc0_HwTrgGroup_Channel[0],
    .GroupChannelsNum    = 4,
    .GroupInHwUnitId     = ADC_0,
};


#if (ADC_UNIT_NUMBER != 0)
#if (ADC_UNIT_NUMBER > ADC_MAX_HW_UNITS)
    #error "Config too many ADC Hw Unit !"
#else
ADC_CONST const Adc_HwUnitType Adc_HwUnitConfiguration[ADC_UNIT_NUMBER] = {
{ 
    .HwUnitId = ADC_0,
    .ClockSource = ADC_BUSCLK,
    .Prescale = 1,
        .StartupTime = 49,
    .InternalTempSensor = TRUE,
},
};
#endif /* ADC_UNIT_NUMBER > ADC_MAX_HW_UNITS */
#endif /* ADC_UNIT_NUMBER != 0 */

ADC_CONST const Adc_ChannelSampleType Adc0_HwTrgGroup_ChannelSample = {
    .ChannelSampTime = 34,
    .ChannelConvTime = 0,
    .ChannelRefVoltsrcHigh = 0,
    .ChannelRefVoltsrcLow = 0,
    .ChannelResolution = ADC_RESOLUTION_12BIT,
};

ADC_CONST const Adc_GroupSampleType Adc0_HwTrgGroup_Configuration = 
{
    .GroupAccessMode = ADC_ACCESS_MODE_SINGLE,
    .GroupConversionMode = ADC_CONV_MODE_ONESHOT,
#if (ADC_PRIORITY_IMPLEMENTATION != ADC_PRIORITY_NONE)
    .GroupPriority = 0,
#endif /* (ADC_PRIORITY_IMPLEMENTATION != ADC_PRIORITY_NONE) */
    .GroupReplacement = ADC_GROUP_REPL_ABORT_RESTART,
    .GroupTriggSrc = ADC_TRIGG_SRC_HW,
#if (ADC_HW_TRIGGER_API == STD_ON)
    .HwTrigSrc = CDDTRG_TMU_SYNC_FUNCLK,
#endif /* (ADC_HW_TRIGGER_API == STD_ON) */
    .StreamingBufferMode = ADC_STREAM_BUFFER_LINEAR,
    .StreamingNumSamples = 1,
    .GroupDefinition = &Adc0_HwTrgGroup_ChannelsInf,
    .NotificationFunc = Adc0_HwTrgGroupNotification,
    .IntcAndDmaCfg = ADC_INTC_ENABLED,
};

ADC_CONST const Adc_GroupConfigType Adc_GourpsConfiguration[1] = 
{
    {
        .GroupId = AdcConf_AdcConfigSet_Adc0_HwTrgGroup,
        .GroupSample = &Adc0_HwTrgGroup_Configuration,
        .ChannelSample = &Adc0_HwTrgGroup_ChannelSample,
    },
};
ADC_CONST const Adc_ConfigType Adc_Config =
{
    .GroupCfgNum    = ADC_GROUP_NUMBER,
    .HwUnitCfgNum   = ADC_UNIT_NUMBER,
    .HwUnitUserCfg = &Adc_HwUnitConfiguration[0],
    .GroupUserCfg  = &Adc_GourpsConfiguration[0],
};

#define ADC_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Adc_MemMap.h"

