/* USER CODE BEGIN Header */
/* you can remove the copyright */

/*
 *  Copyright 2020-2023 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 *
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 *
 * @file main.c
 * @brief
 *
 */

/* USER CODE END Header */
#include "Mcal.h"
/* Includes ------------------------------------------------------------------*/

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */
/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */
/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
/* USER CODE BEGIN PV */
/*The software result FIFO for all Adc group*/
Adc_ValueGroupType Adc0_SwTrigGroupRstFIFO[Adc0_SwTrgGroup_CHANNEL_NUMBER];
Adc_ValueGroupType Adc0_HwTrigGroupRstFIFO[Adc0_HwTrgGroup_CHANNEL_NUMBER];

uint16 Adc0_SwTrigGroupRseultPhys[Adc0_SwTrgGroup_CHANNEL_NUMBER];
uint16 Adc0_HwTrigGroupRseultPhys[Adc0_HwTrgGroup_CHANNEL_NUMBER];


volatile uint32 Adc0_SwTrigGroupConCompCnt = 0;
volatile uint32 Adc0_HwTrigGroupConCompCnt = 0;
volatile uint32 Adc0_ResultNotMachCnt = 0;
volatile uint8 Adc_DataCheckEnable = 0;

/* USER CODE END PV */

/* Private function declare --------------------------------------------------*/
/* USER CODE BEGIN PFDC */


/*Call Back functions which are needed for integration test*/
void Adc0_HwTrgGroupNotification(void)
{
    Adc0_HwTrigGroupConCompCnt++;
    if(Adc_GetGroupStatus(AdcConf_AdcConfigSet_Adc0_HwTrgGroup)==ADC_STREAM_COMPLETED)
    {
        Adc_ReadGroup(AdcConf_AdcConfigSet_Adc0_HwTrgGroup, Adc0_HwTrigGroupRseultPhys);
        for(uint8 LoopCnt = 0; LoopCnt<Adc0_HwTrgGroup_CHANNEL_NUMBER; LoopCnt++)
        {
            Adc0_HwTrigGroupRseultPhys[LoopCnt] = (uint32)Adc0_HwTrigGroupRseultPhys[LoopCnt]*5000/4095;
        }

        Adc_DisableHardwareTrigger(AdcConf_AdcConfigSet_Adc0_HwTrgGroup);
    }
}

void Adc0_SwTrgGroupNotification(void)
{
    Adc_EnableHardwareTrigger(AdcConf_AdcConfigSet_Adc0_HwTrgGroup);
    Adc0_SwTrigGroupConCompCnt++;
    if(ADC_STREAM_COMPLETED==Adc_GetGroupStatus(AdcConf_AdcConfigSet_Adc0_SwTrgGroup))
    {
        Adc_ReadGroup(AdcConf_AdcConfigSet_Adc0_SwTrgGroup, Adc0_SwTrigGroupRseultPhys);
        uint8 i = 0;
        for(i = 0; i<Adc0_SwTrgGroup_CHANNEL_NUMBER; i++)
        {
            Adc0_SwTrigGroupRseultPhys[i] = (uint32)Adc0_SwTrigGroupRseultPhys[i]*5000/4095;
        }
        Adc_DataCheckEnable = TRUE;
    }
}

/* USER CODE END PFDC */
static void Board_Init(void);

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */
/* USER CODE END 0 */


/**
 * @brief  The application entry point.
 * @retval int
 */
int main(void)
{
    /* USER CODE BEGIN 1 */
    uint16 LoopCnt=0;
    Mcu_Init(&Mcu_Config);
    Mcu_InitClock(0);
#if (MCU_NO_PLL == STD_OFF)
    while (MCU_PLL_LOCKED != Mcu_GetPllStatus())
    {
        /* Wait until PLL is locked */
    }
    Mcu_DistributePllClock();
#endif
    /* USER CODE END 1 */ 
    Board_Init();
    /* USER CODE BEGIN 2 */
    Adc_SetupResultBuffer(AdcConf_AdcConfigSet_Adc0_SwTrgGroup, Adc0_SwTrigGroupRstFIFO);
    Adc_SetupResultBuffer(AdcConf_AdcConfigSet_Adc0_HwTrgGroup, Adc0_HwTrigGroupRstFIFO);

    Adc_EnableGroupNotification(AdcConf_AdcConfigSet_Adc0_SwTrgGroup);
    Adc_EnableGroupNotification(AdcConf_AdcConfigSet_Adc0_HwTrgGroup);

    Adc_StartGroupConversion(AdcConf_AdcConfigSet_Adc0_SwTrgGroup);
    Adc_EnableHardwareTrigger(AdcConf_AdcConfigSet_Adc0_HwTrgGroup);


    /* USER CODE END 2 */

    /* Infinite loop */
    /* USER CODE BEGIN WHILE */
    while(1)
    {
        /*Check VDD25 in sw group and hw group*/
        if(TRUE == Adc_DataCheckEnable)
        {
            if((Adc0_HwTrigGroupRseultPhys[4]>(Adc0_SwTrigGroupRseultPhys[7]+30U))||(Adc0_HwTrigGroupRseultPhys[4]<(Adc0_SwTrigGroupRseultPhys[7]-30U)))
            {
                ++Adc0_ResultNotMachCnt;
            }

            Adc_DataCheckEnable = FALSE;
        }

        for(LoopCnt = 0; LoopCnt < 1000U; ++LoopCnt)
        {
            __ASM("NOP");
            __ASM("NOP");
        }

        /* USER CODE END WHILE */
        /* USER CODE BEGIN 3 */
    }
    /* USER CODE END 3 */
}

static void Board_Init(void)
{
    Platform_Init(NULL_PTR);
    Port_Init(&Port_Config);
    Adc_Init(&Adc_Config);
    CddTrg_Init(&CddTrg_Config);
    Pwm_Init(&Pwm_Config);
}

/* USER CODE BEGIN 4 */
/* USER CODE END 4 */
