# Adc示例代码

## 工程名称：Adc_PwmTrig_Demo

---
## 功能描述

本示例用于演示 MCAL PWM触发ADC转换的方法:

- **Adc**: 
  - 配置两个Group(Adc0_HwTrgGroup/Adc0_SwTrgGroup), 分别配置为硬件触发采集与软件触发采集模式, Adc0_SwTrgGroup配置为连续模式。

- **Pwm**
  - 配置MPWM0_CH0输出10kHz 50% PWM波，并使能MPWM0_CH0 `PwmMpwmPeriodMatchTriggerOutput`用于触发Adc0。

- **CddTrg**
  - 配置`TMU_TRIG_TARGET_ADC0_EXT_TRIG0`的触发源为`TMU_TRIG_SOURCE_MPWM0_TRIG_OUT0_3`,同时配置`TMU_TRIG_TARGET_TMU_OUT4`用于观察触发信号。

- **Adc_PwmTrig_Demo硬件连接需求**
  | 功能 | MCU引脚 | EVB 插针|
  | ---- | ------- | ------ |
  | MPWM0_CH0 | PTB1 | P6_3P |
  | TMU_OUT4 | PTE10 | P2_6P |
  | ADC0_S0 | PTA0 | P8_3P |
  | ADC0_S1 | PTA1 | P7_3P |

在该示例中Adc0_HwTrgGroup与Adc0_SwTrgGroup交替进行数据转化。MCU复位并完成初始化后，分别使能Adc0_HwTrgGroup、Adc0_SwTrgGroup以及PWM输出，硬件触发信号产生后，Adc先转换Adc0_HwTrgGroup，并在其完成的通知函数中，关闭Adc0_HwTrgGroup，将Adc硬件交还给Adc0_SwTrgGroup，Adc0_SwTrgGroup开始转换。Adc0_SwTrgGroup完成转换后再次使能Adc0_HwTrgGroup，此时Adc0_HwTrgGroup等待PWM触发信号，并在信号产生后开始转换，循环往复。在While(1)中检查两个Group的转换结果是否一致。

---


## 硬件需求
+ **EVB**: YTM32B1HA01-EVB-Q176-Rev.A
+ **调试器**： J-Link HW v9 或更高版本，安装了 YUNTU YTM32B1HA01 补丁（支持包）。

---

## 软件需求

+ **配置和代码生成工具**
  + **MCAL**:     Yuntu Config Tool(YCT) v2.6 或更高版本
+ **编译器工具链**
  + **GCC**     : GNU GCC v10.3 或更高版本
  + **Keil/MDK**: ARM Keil/MDK v5.36 或更高版本
  + **IAR**     : IAR v8.40 或更高版本
  + **VS Code**  : Microsoft Visual Studio Code IDE v1.76 或更高版本（需要 C/C++ 支持，GNU 工具链，CMake v3.25，ninja，Cortex-Debug 扩展安装）
+ **Debugger driver**
    + **J-Link**              : SEGGER J-Link v7.82 或更高版本，需要安装 YUNTU YTM32B1HA01 补丁（支持包）。
    + **Ozone Debugger tool**  : SEGGER Ozone v3.28 或更高版本。

    ***注意***: * 需要安装 **YTM32B1HA0** 补丁，补丁可通过 **YCT** 工具或联系 ***云途 销售/FAE 团队***获取.

---

## 操作步骤

+ ***步骤1***：使用 YCT 工具打开示例的配置工程文件（`Adc_PwmTrig_Demo.yct`），根据您的需求配置工具链（默认使用 VS Code + GCC）。
+ ***步骤2***：生成代码，如果需要，您可以更改配置（以适应您自己的硬件设计），如果这样做，请确保所有修改都正确无误，并且在生成代码之前没有错误存在。
+ ***步骤3***：根据您的配置，使用相应的工具（VS Code/IAR/Keil IDE）打开生成的工程。
+ ***步骤4***：编译生成的工程，打开 EVB 电源并通过可用的调试器（如 J-Link 调试探针）将编译好的可执行文件下载到 EVB。
+ ***步骤5***：调试、运行示例代码。
  
---