# Adc Example Code

## Project Name：Adc_PwmTrig_Demo

---
## Function description

This project is designed to demonstrate how to trigger ADC conversion by PWM in MCAL:

- **Adc**: 
  - Configure two groups (Adc0_HwTrgGroup and Adc0_SwTrgGroup).The Adc0_HwTrgGroup is configured to hardware tigger and one short mode. The Adc0_SwTrgGroup is configured to software tigger and continuous mode. 

- **Pwm**:
  - Configure MPWM0_CH0 to output a 10kHz 50% PWM wave and enable MPWM0_CH0 'PwmMpwmPeriodMatchTriggerOutput' to trigger Adc0.

- **CddTrg**
  - Configure the trigger source for 'TMU_TRIG_TARGET_ADC0_EXT_TRIG0' to be 'TMU_TRIG_SOURCE_MPWM0_TRIG_OUT0_3' and configure 'TMU_TRIG_TARGET_TMU_OUT4' to observe the trigger signal.
 

+ ***Adc_PwmTrig_Demo HW connection diagram***

  | Function | MCU Pin | EVB pin header|
  | ---- | ------- | ------ |
  | MPWM0_CH0 | PTB1 | P6_3P |
  | TMU_OUT4 | PTE10 | P2_6P |
  | ADC0_S0 | PTA0 | P8_3P |
  | ADC0_S1 | PTA1 | P7_3P |


 In this demo, Adc0_HwTrgGroup and Adc0_SwTrgGroup alternate in performing data conversion. After the MCU resets and completes initialization, it enables Adc0_HwTrgGroup, Adc0_SwTrgGroup, and the PWM output. The  Adc0_HwTrgGroup is converted firstly when the hardware trigger signal is generated by PWM. The Adc0_HwTrgGroup is diabled and the Adc0_SwTrgGroup start converting in Adc0_HwTrgGroup's completion notification function  After Adc0_SwTrgGroup completes conversion, it enables Adc0_HwTrgGroup again. At this point, Adc0_HwTrgGroup waits for the PWM trigger signal and begins conversion when the signal is generated. The process repeats. In the While(1) loop, the results of both groups are checked to see if they are consistent.

---

## HW requirement
+ **EVB**: YTM32B1HA01-EVB-Q176-Rev.A
+ **Debugger**: J-Link HW v9 or later with YUNTU YTM32B1HA01 patch(support package) installed.

---

## SW requirement

+ **Config & Code Generation Tool**
  + **MCAL**:     Yuntu Config Tool(YCT) v2.6 or later version
+ **Compiler Toolchain**
  + **GCC**     : GNU GCC v10.3 or later version
  + **Keil/MDK**: ARM Keil/MDK v5.36 or later version
  + **IAR**     : IAR v8.40 or later version
  + **VS Code**  : Microsoft Visual Studio Code IDE v1.76 or later version(C/C++ support, GNU toolchain, CMake v3.25, ninja, Cortex-Debug extensions installation required)
+ **Debugger driver**
    + **J-Link**              : SEGGER J-Link v7.82 or later version, YUNTU YTM32B1HA01 patch(support package) installation required.
    + **Ozone Debugger tool**  : SEGGER Ozone v3.28 or later version.

    ***Note***:  **YTM32B1HA0** patch install required which can be obtained via **YCT** or contact ***YUNTU sales/FAE team***.

---

## Setup

+ ***Step1***: Open the `Adc_PwmTrig_Demo.yct` with the YCT tool, config the toolchain per your required(by default, the VS code + GCC are used)
+ ***Step2***：Generate the codes， you can change the configurations if needed(to adapt to your own HW design), if so, please ensure all the modifications are OK with no any errors exist before generating the code.
+ ***Step3***: Open the generated project with VS code/IAR/Keil IDE per your selected.
+ ***Step4***: Compile the project, power on the EVB and download it to the EVB via the available debugger, such as a J-Link debugger probe.
+ ***Step5***: At last, enjoy the demo example.
  
---