/**
 * @file    SchM_Gpt.h
 * @version V1.0.0
 *
 * @brief   AUTOSAR SchM_Gpt module interface
 * @details API implementation for GPT driver
 *
 * @addtogroup SCHM_GPT_MODULE
 * @{
 */
/*==================================================================================================
 *   Project              : YTMicro AUTOSAR 4.4.0 MCAL
 *   Platform             : ARM
 *   Peripheral           : Lptmr, Ptmr, Tmr, Rtc
 *   Dependencies         : none
 *
 *   Autosar Version      : V4.4.0
 *   Autosar Revision     : ASR_REL_4_4_REV_0000
 *   Autosar Conf.Variant :
 *   SW Version           : V1.0.0.HF001
 *   
 *
 *   (c) Copyright 2020-2025 Yuntu Microelectronics co.,ltd.
 *   All Rights Reserved.
==================================================================================================*/

#ifndef SCHM_GPT_H
#define SCHM_GPT_H

#ifdef __cplusplus
extern "C" {
#endif

/* PRQA S 0777,0779 EOF */
/*==================================================================================================
 *                               SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define SCHM_GPT_VENDOR_ID             		    (180U)
#define SCHM_GPT_AR_RELEASE_MAJOR_VERSION       (4U)
#define SCHM_GPT_AR_RELEASE_MINOR_VERSION       (4U)
#define SCHM_GPT_AR_RELEASE_REVISION_VERSION    (0U)
#define SCHM_GPT_SW_MAJOR_VERSION               (1)
#define SCHM_GPT_SW_MINOR_VERSION               (0)
#define SCHM_GPT_SW_PATCH_VERSION               (0)

/*==================================================================================================
 *                                       DEFINES AND MACROS                                       
==================================================================================================*/
#ifndef NUMBER_OF_CORES
#define NUMBER_OF_CORES (1U)
#endif

/*==================================================================================================
 *                                       FUNCTION PROTOTYPES
==================================================================================================*/
#define RTE_START_SEC_CODE
#include "Rte_MemMap.h"

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_00(void);
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_00(void);

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_01(void);
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_01(void);

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_02(void);
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_02(void);

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_03(void);
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_03(void);

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_04(void);
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_04(void);

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_05(void);
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_05(void);

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_06(void);
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_06(void);

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_07(void);
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_07(void);

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_08(void);
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_08(void);

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_09(void);
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_09(void);

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_10(void);
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_10(void);

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_11(void);
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_11(void);

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_12(void);
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_12(void);

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_13(void);
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_13(void);

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_14(void);
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_14(void);

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_15(void);
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_15(void);

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_16(void);
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_16(void);

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_17(void);
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_17(void);

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_18(void);
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_18(void);

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_19(void);
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_19(void);

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_20(void);
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_20(void);

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_21(void);
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_21(void);

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_22(void);
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_22(void);

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_23(void);
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_23(void);

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_24(void);
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_24(void);

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_25(void);
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_25(void);

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_26(void);
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_26(void);

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_27(void);
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_27(void);

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_28(void);
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_28(void);

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_29(void);
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_29(void);

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_30(void);
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_30(void);

RTE_FUNC extern void SchM_Enter_Gpt_GPT_EXCLUSIVE_AREA_31(void);
RTE_FUNC extern void SchM_Exit_Gpt_GPT_EXCLUSIVE_AREA_31(void);

#define RTE_STOP_SEC_CODE
#include "Rte_MemMap.h"

#ifdef __cplusplus
}
#endif

#endif /* SCHM_GPT_H */

/** @} */

