/*
* @file    SchM_CddTrg.h
*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : SchM_CddTrg
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V1.0.0.HF001
*
*   (c) Copyright 2020-2025 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifndef SCHM_CDDTRG_H
#define SCHM_CDDTRG_H

/**
*   @file    SchM_CddTrg.h
*
*   @addtogroup SCHM_CDDTRG_MODULE
*   @{
*/

#ifdef __cplusplus
extern "C" {
#endif

/* PRQA S 0777,0779 EOF */
/*==================================================================================================
                                              INCLUDE FILES
==================================================================================================*/
/*==================================================================================================
                                      HEADER FILE VERSION INFORMATION
==================================================================================================*/
#define SCHM_CDDTRG_VENDOR_ID                      (180)
#define SCHM_CDDTRG_AR_RELEASE_MAJOR_VERSION       (4)
#define SCHM_CDDTRG_AR_RELEASE_MINOR_VERSION       (4)
#define SCHM_CDDTRG_AR_RELEASE_REVISION_VERSION    (0)
#define SCHM_CDDTRG_SW_MAJOR_VERSION               (1)
#define SCHM_CDDTRG_SW_MINOR_VERSION               (0)
#define SCHM_CDDTRG_SW_PATCH_VERSION               (0)
/*==================================================================================================
                                                DEFINES AND MACROS
==================================================================================================*/

/* Number of cores id */
#ifndef NUMBER_OF_CORES
#define NUMBER_OF_CORES         (uint8)(1U)
#endif /* NUMBER_OF_CORES */

/*==================================================================================================
                                                EXTERNAL CONSTANTS
==================================================================================================*/
/*==================================================================================================
                                                ENUMS
==================================================================================================*/
/*==================================================================================================
                                                FUNCTION PROTOTYPES
==================================================================================================*/

extern void SchM_Enter_CddTrg_CDDTRG_EXCLUSIVE_AREA_00(void);
extern void SchM_Exit_CddTrg_CDDTRG_EXCLUSIVE_AREA_00(void);

extern void SchM_Enter_CddTrg_CDDTRG_EXCLUSIVE_AREA_01(void);
extern void SchM_Exit_CddTrg_CDDTRG_EXCLUSIVE_AREA_01(void);

extern void SchM_Enter_CddTrg_CDDTRG_EXCLUSIVE_AREA_02(void);
extern void SchM_Exit_CddTrg_CDDTRG_EXCLUSIVE_AREA_02(void);

extern void SchM_Enter_CddTrg_CDDTRG_EXCLUSIVE_AREA_03(void);
extern void SchM_Exit_CddTrg_CDDTRG_EXCLUSIVE_AREA_03(void);

#ifdef __cplusplus
}
#endif

/** @} */

#endif /* End of file SchM_CddTrg.h */

