/**
 * @file    Pwm_Lld_Mpwm_Reg.h
 * @version V1.0.0
 *
 * @brief   YUNTU Pwm_Lld_Mpwm module interface
 * @details API implementation for Pwm_Lld_Mpwm driver
 *
 * @addtogroup PWM_LLD_MPWM_MODULE
 * @{
 */
/*==================================================================================================
 *   Project              : YTMicro AUTOSAR 4.4.0 MCAL
 *   Platform             : ARM
 *   Peripheral           : MPWM
 *   Dependencies         : none
 *
 *   Autosar Version      : V4.4.0
 *   Autosar Revision     : ASR_REL_4_4_REV_0000
 *   Autosar Conf.Variant :
 *   SW Version           : V1.0.0.HF001
 *
 *   (c) Copyright 2020-2025 Yuntu Microelectronics co.,ltd.
 *   All Rights Reserved.
==================================================================================================*/

#ifndef PWM_LLD_MPWM_REG_H
#define PWM_LLD_MPWM_REG_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
 *                                      INCLUDE FILES
==================================================================================================*/

#include "pSIP_Mpwm.h"

/*==================================================================================================
 *                               SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define PWM_LLD_MPWM_REG_VENDOR_ID                      (180)
#define PWM_LLD_MPWM_REG_MODULE_ID              (121)
#define PWM_LLD_MPWM_REG_AR_RELEASE_MAJOR_VERSION       (4)
#define PWM_LLD_MPWM_REG_AR_RELEASE_MINOR_VERSION       (4)
#define PWM_LLD_MPWM_REG_AR_RELEASE_REVISION_VERSION    (0)
#define PWM_LLD_MPWM_REG_SW_MAJOR_VERSION               (1)
#define PWM_LLD_MPWM_REG_SW_MINOR_VERSION               (0)
#define PWM_LLD_MPWM_REG_SW_PATCH_VERSION               (0)

#ifdef __cplusplus
}
#endif

#endif /* PWM_LLD_MPWM_REG_H */

/** @} */

