/*
 * Copyright 2020-2025 Yuntu Microelectronics co.,ltd
 * All rights reserved.
 *
 * YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software. The production use license in
 * Section 2.3 is expressly granted for this software.
 */

#include "secure_boot_YTM32B1HA0.h"

#if defined (__ARMCC_VERSION)
extern uint32 Image$$IVT_start$$Base;
#define IVT_START ((uint32 *) &Image$$IVT_start$$Base)
#else
extern uint32 IVT_start[1U];
#define IVT_START ((uint32 *) &IVT_start)
#endif

/*
 * add the CAMC result array definition of sections as below with "SB_CMAC_SEG" to place it into
 * section ".sb_cmac" allocated in linker file
 */
#if defined (__ICCARM__)
__root const uint8 Cma0[16] SB_CMAC_SEG = {0};
__root const uint8 Cma1[16] SB_CMAC_SEG = {0};
#else
const uint8 Cma0[16] SB_CMAC_SEG = {0};
const uint8 Cma1[16] SB_CMAC_SEG = {0};
#endif

/* add the secure boot section config structure definitions as below with "SB_CONFIG_SECTION_SEG"
 * to place it into section ".sb_config_section" allocated in linker file
 */
#if defined (__ICCARM__)
__root const SBOOT_SectionConfigType SBOOT_Section0 SB_CONFIG_SECTION_SEG = {
#else
const SBOOT_SectionConfigType SBOOT_Section0 SB_CONFIG_SECTION_SEG = {
#endif
    .SBootMarker    = SECURE_BOOT_SECTION_MARKER,
    .AesKeySize     = KEY_LEN_128_BITS,
    .KeySlot        = 1,
    .StartAddr      = 0x02000800,
    .Length         = 0x200,
    .CmacAddr       = (uint32)&Cma0[0],
};

#if defined (__ICCARM__)
__root const SBOOT_SectionConfigType SBOOT_Section1 SB_CONFIG_SECTION_SEG = {
#else
const SBOOT_SectionConfigType SBOOT_Section1 SB_CONFIG_SECTION_SEG = {
#endif
    .SBootMarker    = SECURE_BOOT_SECTION_MARKER,
    .AesKeySize     = KEY_LEN_128_BITS,
    .KeySlot        = 2,
    .StartAddr      = 0x02000A00,
    .Length         = 0x0200,
    .CmacAddr       = (uint32)&Cma1[0],
};

/* add the secure boot group config structure definitions as below with "SB_CONFIG_GROUP_SEG"
 * to place it into section ".sb_group_section" allocated in linker file
 */
#if defined (__ICCARM__)
__root const SBOOT_GroupConfigType SBOOT_Group SB_CONFIG_SECTION_SEG = {
#else
const SBOOT_GroupConfigType SBOOT_Group SB_CONFIG_SECTION_SEG = {
#endif
    .GroupMarker            = SECURE_BOOT_GROUP_MARKER,
    .SectionNum             = 2,
    .Encrypt                = TRUE,
    .AesKeySize             = KEY_LEN_128_BITS,
    .KeySlot                = 0,
    {
        (uint32)&SBOOT_Section0,
        (uint32)&SBOOT_Section1
    }
};

/* BVT Header section
 * include configuration refer to BVT_t
 */

#define BOOT_CONFIG_WORD  (BVT_BCW_CPDIVS_SET(1) | CM7_0_M_EN)

/* define the timeout of ADG watchdog of the application main core */
#define APP_WDG_TIMEOUT (120000)    /* 10ms respect to 12MHz SIRC as reference clock*/
/* Flash erased status */
#define RESERVED        ( 0xFFFFFFFF )

/* BVT Header configuration */
#if defined (__ICCARM__)
__root const BVT_HeaderConfigType BVT_Header BVT_HEADER_SEG = {
#else
const BVT_HeaderConfigType BVT_Header BVT_HEADER_SEG = {
#endif
    BVT_VALID_MARK,         /* BVT marker */
    BOOT_CONFIG_WORD,       /* Boot configuration word */
    (uint32)&SBOOT_Group,   /* secure boot start address */
    RESERVED,               /* lifecycle configuration */
    (uint32)IVT_START, /* CM7_0 main core start address */
    RESERVED,               /* Reserved for CM7_0_SECONDARY_APP_ADDR */
    RESERVED,               /* Reserved for CM7_1_MAIN_APP_ADDR */
    RESERVED,               /* Reserved for CM7_1_SECONDARY_APP_ADDR */
    RESERVED,               /* Reserved for CM7_2_MAIN_APP_ADDR */
    RESERVED,               /* Reserved for CM7_2_SECONDARY_APP_ADDR */
    APP_WDG_TIMEOUT,        /* timeout set of the WDG watchdog of the  application core */
};

/*******************************************************************************
 * EOF
 ******************************************************************************/

