/**
*   @file    pSIP_Intm.h
*   @version
*
*   @brief   AUTOSAR Intm register map
*   @details Register map for INTM
*
*   @addtogroup ADC_MODULE
*   @{
*/
/*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : Adc
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   Autosar Conf.Variant :
*   SW Version           : V1.0.0.HF001
*
*   (c) Copyright 2020-2025 YTMicro Semiconductor, Inc.
*   All Rights Reserved.
==================================================================================================*/
/*==================================================================================================
==================================================================================================*/

#ifndef PSIP_INTM_H
#define PSIP_INTM_H

/*=================================================================================================
*                                        INCLUDE FILES
=================================================================================================*/

#include "Std_Types.h"

/*==================================================================================================
*                              INTM REGISTER MAP
==================================================================================================*/

/**
 * @addtogroup INTM_Peripheral_Access_Layer INTM Peripheral Access Layer
 * @{
 */


/** INTM - Size of Registers Arrays */
#define INTM_MON_COUNT           (4)

/* INTM Register Layout Typedef */
typedef struct {
    uint32 GCTRL;                              /**< Global Control Register, offset: 0x0000 */
    uint32 GINTACK;                            /**< Global Interrupt Acknowledge Register, offset: 0x0004 */
    uint32 RESERVED0[ 2];                      /**< RESERVED0, offset: 0x0008 */
    struct {
        uint32 SEL;                                /**< Monitor Channel Selection Register, offset: 0x0010 */
        uint32 THD;                                /**< Monitor Timer Threshold Register, offset: 0x0014 */
        uint32 TMR;                                /**< Monitor Timer Value Register, offset: 0x0018 */
        uint32 STS;                                /**< Monitor Status Register, offset: 0x001C */

    } MON[4];

} INTM_Type, *INTM_MemMapPtr;

/** Number of instances of the INTM module. */
#define INTM_INSTANCE_COUNT                        (1u)

/* INTM base address */
#define INTM_BASE_ADDR32                                  (0x401C4000U)
#define INTM                                              ((volatile INTM_Type *)(INTM_BASE_ADDR32))

/** Array initializer of INTM peripheral base addresses */
#define INTM_BASE_ADDRS                                    { INTM_BASE_ADDR32 }
/** Array initializer of INTM peripheral base pointers */
#define INTM_BASE_PTRS                                     { INTM }

#define INTM_GCTRL_OFFSET32                                (0x0000U)                    /**< Offset for Global Control Register */
#define INTM_GINTACK_OFFSET32                              (0x0004U)                    /**< Offset for Global Interrupt Acknowledge Register */
#define INTM_MON_OFFSET32(x)                               (0x0010U + ((x) * (16U)))    /**< Offset for Channel Monitor Descriptor */

#define INTM_MON_SEL_OFFSET32(x)                           (0x0010U + ((x) * (16U)))    /**< Offset for Monitor Channel Selection Register */
#define INTM_MON_THD_OFFSET32(x)                           (0x0014U + ((x) * (16U)))    /**< Offset for Monitor Timer Threshold Register */
#define INTM_MON_TMR_OFFSET32(x)                           (0x0018U + ((x) * (16U)))    /**< Offset for Monitor Timer Value Register */
#define INTM_MON_STS_OFFSET32(x)                           (0x001CU + ((x) * (16U)))    /**< Offset for Monitor Status Register */



/**
 * @addtogroup INTM Register Mask
 * @{
 */
/* INTM_GCTRL Register */
#define INTM_GCTRL_GEN_MASK                                 (0x1U)
#define INTM_GCTRL_GEN_SHIFT                                (0U)
#define INTM_GCTRL_GEN(x)                                   (((uint32)(((uint32)(x)) << INTM_GCTRL_GEN_SHIFT)) & INTM_GCTRL_GEN_MASK)
/* INTM_GINTACK Register */
#define INTM_GINTACK_SRC_MASK                               (0xFFU)
#define INTM_GINTACK_SRC_SHIFT                              (0U)
#define INTM_GINTACK_SRC(x)                                 (((uint32)(((uint32)(x)) << INTM_GINTACK_SRC_SHIFT)) & INTM_GINTACK_SRC_MASK)
/* INTM_MON_SEL Register */
#define INTM_MON_SEL_EN_MASK                                    (0x80000000U)
#define INTM_MON_SEL_EN_SHIFT                                   (31U)
#define INTM_MON_SEL_EN(x)                                      (((uint32)(((uint32)(x)) << INTM_MON_SEL_EN_SHIFT)) & INTM_MON_SEL_EN_MASK)
#define INTM_MON_SEL_IRQ_MASK                                   (0xFFU)
#define INTM_MON_SEL_IRQ_SHIFT                                  (0U)
#define INTM_MON_SEL_IRQ(x)                                     (((uint32)(((uint32)(x)) << INTM_MON_SEL_IRQ_SHIFT)) & INTM_MON_SEL_IRQ_MASK)
/* INTM_MON_THD Register */
#define INTM_MON_THD_THRESHOLD_WIDTH                            (24)
#define INTM_MON_THD_THRESHOLD_MASK                             (0xFFFFFFU)
#define INTM_MON_THD_THRESHOLD_SHIFT                            (0U)
#define INTM_MON_THD_THRESHOLD(x)                               (((uint32)(((uint32)(x)) << INTM_MON_THD_THRESHOLD_SHIFT)) & INTM_MON_THD_THRESHOLD_MASK)
/* INTM_MON_TMR Register */
#define INTM_MON_TMR_CNT_MASK                                   (0xFFFFFFU)
#define INTM_MON_TMR_CNT_SHIFT                                  (0U)
#define INTM_MON_TMR_CNT(x)                                     (((uint32)(((uint32)(x)) << INTM_MON_TMR_CNT_SHIFT)) & INTM_MON_TMR_CNT_MASK)
/* INTM_MON_STS Register */
#define INTM_MON_STS_OF_MASK                                    (0x1U)
#define INTM_MON_STS_OF_SHIFT                                   (0U)
#define INTM_MON_STS_OF(x)                                      (((uint32)(((uint32)(x)) << INTM_MON_STS_OF_SHIFT)) & INTM_MON_STS_OF_MASK)



/**
 * @}
 */ /* end of group INTM_Register_Masks */


/**
 * @}
 */ /* end of group INTM_Peripheral_Access_Layer */

#endif /* PSIP_INTM_H */

