/**
 * @file    Gpt_Lld_Tmr_Reg.h
 * @version V1.0.0
 *
 * @brief   AUTOSAR Gpt module interface
 * @details API implementation for Gpt driver
 *
 * @addtogroup GPT_LLD_TMR_MODULE
 * @{
 */
/*==================================================================================================
 *   Project              : YTMicro AUTOSAR 4.4.0 MCAL
 *   Platform             : ARM
 *   Peripheral           : Tmr
 *   Dependencies         : none
 *
 *   Autosar Version      : V4.4.0
 *   Autosar Revision     : ASR_REL_4_4_REV_0000
 *   Autosar Conf.Variant :
 *   SW Version           : V1.0.0.HF001
 *
 *   (c) Copyright 2020-2025 Yuntu Microelectronics co.,ltd.
 *   All Rights Reserved.
==================================================================================================*/

#ifndef GPT_LLD_TMR_REG_H
#define GPT_LLD_TMR_REG_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
 *                                      INCLUDE FILES
==================================================================================================*/
#include "pSIP_Tmr.h"

/*==================================================================================================
 *                               SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define GPT_LLD_TMR_REG_VENDOR_ID                      (180)
#define GPT_LLD_TMR_REG_AR_RELEASE_MAJOR_VERSION       (4)
#define GPT_LLD_TMR_REG_AR_RELEASE_MINOR_VERSION       (4)
#define GPT_LLD_TMR_REG_AR_RELEASE_REVISION_VERSION    (0)
#define GPT_LLD_TMR_REG_SW_MAJOR_VERSION               (1)
#define GPT_LLD_TMR_REG_SW_MINOR_VERSION               (0)
#define GPT_LLD_TMR_REG_SW_PATCH_VERSION               (0)

#ifdef __cplusplus
}
#endif

#endif /* GPT_LLD_TMR_REG_H */

/** @} */

