/*
* @file    CddTrg_Types.h
*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : CddTrg_Types
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V1.0.0.HF001
*
*   (c) Copyright 2020-2025 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifndef CDDTRG_TYPES_H
#define CDDTRG_TYPES_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
                                              INCLUDE FILES
==================================================================================================*/
#include "CddTrg_Cfg.h"
#if defined (CDDTRG_TMU_ENABLE)
#include "CddTrg_Lld_Tmu_Types.h"
#endif
#if defined (CDDTRG_PTU_ENABLE)
#include "CddTrg_Lld_Ptu_Types.h"
#endif
/*==================================================================================================
                                      HEADER FILE VERSION INFORMATION
==================================================================================================*/
#define CDDTRG_TYPES_VENDOR_ID                      (180)
#define CDDTRG_TYPES_AR_RELEASE_MAJOR_VERSION       (4)
#define CDDTRG_TYPES_AR_RELEASE_MINOR_VERSION       (4)
#define CDDTRG_TYPES_AR_RELEASE_REVISION_VERSION    (0)
#define CDDTRG_TYPES_SW_MAJOR_VERSION               (1)
#define CDDTRG_TYPES_SW_MINOR_VERSION               (0)
#define CDDTRG_TYPES_SW_PATCH_VERSION               (0)
/*==================================================================================================
                                                DEFINES AND MACROS
==================================================================================================*/
/*==================================================================================================
                                                EXTERNAL CONSTANTS
==================================================================================================*/
/*==================================================================================================
                                                TYPEDEFS
==================================================================================================*/
/**
* @brief The PTU module running status type
*/
#if defined (CDDTRG_PTU_ENABLE)
typedef enum
{
    CDDTRG_PTU_IDLE = 0U,
    CDDTRG_PTU_RUNNING = 1U
} CddTrg_Ptu_RunningStatusType;
#endif
/**
 * @brief The CddTrg module configuration type
 */
typedef struct
{
#if defined (CDDTRG_TMU_ENABLE)
    CddTrg_Lld_Tmu_ConfigType const * TmuCfgPtr;   /*!< The Tmu module configuration pointer */
#endif
#if defined (CDDTRG_PTU_ENABLE)
    CddTrg_Lld_Ptu_ConfigType const * PtuCfgPtr;   /*!< The Ptu module configuration pointer */
#endif
} CddTrg_ConfigType;
/*==================================================================================================
                                                FUNCTION PROTOTYPES
==================================================================================================*/
#ifdef __cplusplus
}
#endif

#endif /* End of file CddTrg_Types.h */

