/*
* @file    CddTrg_Lld_Tmu_Types.h
*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : CddTrg_Lld_Tmu_Types
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V1.0.0.HF001
*
*   (c) Copyright 2020-2025 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifndef CDDTRG_LLD_TMU_TYPES_H
#define CDDTRG_LLD_TMU_TYPES_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
                                              INCLUDE FILES
==================================================================================================*/
#include "Std_Types.h"
#include "CddTrg_Cfg.h"
/*==================================================================================================
                                      HEADER FILE VERSION INFORMATION
==================================================================================================*/
#define CDDTRG_LLD_TMU_TYPES_VENDOR_ID                      (180)
#define CDDTRG_LLD_TMU_TYPES_AR_RELEASE_MAJOR_VERSION       (4)
#define CDDTRG_LLD_TMU_TYPES_AR_RELEASE_MINOR_VERSION       (4)
#define CDDTRG_LLD_TMU_TYPES_AR_RELEASE_REVISION_VERSION    (0)
#define CDDTRG_LLD_TMU_TYPES_SW_MAJOR_VERSION               (1)
#define CDDTRG_LLD_TMU_TYPES_SW_MINOR_VERSION               (0)
#define CDDTRG_LLD_TMU_TYPES_SW_PATCH_VERSION               (0)
/*==================================================================================================
                                                DEFINES AND MACROS
==================================================================================================*/
/*==================================================================================================
                                                EXTERNAL CONSTANTS
==================================================================================================*/
/*==================================================================================================
                                                TYPEDEFS
==================================================================================================*/
/**
 * @brief The Tmu channel index type
 */
typedef uint8 CddTrg_Lld_Tmu_LinkerIdType;

/**
 * @brief The Tmu channel configuration type
 */ 
typedef struct
{
    CddTrg_Lld_Tmu_LinkerIdType TmuChannelId;   /*!< The tmu channel index in config tools */
    CddTrg_TmuTriggerTargetType TiggerTarget;   /*!< The trigger target selected*/ 
    CddTrg_TmuTriggerSourceType TiggerSource;   /*!< The trigger source selected*/
    boolean SourceChangeAble;                   /*!< The trigger source changeable or not for configurated target channel*/
} CddTrg_Lld_Tmu_LinkerType;

/**
 * @brief The Tmu module configuration type
 */
typedef struct
{
    uint8 LinkerCount;                    /*!< The number of configurated channels in the Tmu module*/
    CddTrg_Lld_Tmu_LinkerType const * LinkerPtr;   /*!< The pointer to the configurated channels in the Tmu module*/
} CddTrg_Lld_Tmu_ConfigType;

/*==================================================================================================
                                                FUNCTION PROTOTYPES
==================================================================================================*/
#ifdef __cplusplus
}
#endif

#endif /* End of file CddTrg_Lld_Tmu_Types.h */

