/**
 * @file    CddTrg_Lld_Tmu_Reg.h
 * @version V1.0.0
 *
 * @brief   YUNTU CddTrg_Lld_Tmu module interface
 * @details API implementation for CddTrg_Lld_Tmu driver
 *
 * @addtogroup CDDTRG_LLD_TMU_MODULE
 * @{
 */
/*==================================================================================================
 *   Project              : YTMicro AUTOSAR 4.4.0 MCAL
 *   Platform             : ARM
 *   Peripheral           : TMU
 *   Dependencies         : none
 *
 *   Autosar Version      : V4.4.0
 *   Autosar Revision     : ASR_REL_4_4_REV_0000
 *   Autosar Conf.Variant :
 *   SW Version           : V1.0.0.HF001
 *
 *   (c) Copyright 2020-2025 Yuntu Microelectronics co.,ltd.
 *   All Rights Reserved.
==================================================================================================*/

#ifndef CDDTRG_LLD_TMU_REG_H
#define CDDTRG_LLD_TMU_REG_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
                                              INCLUDE FILES
==================================================================================================*/
#include "pSIP_Tmu.h"

/*==================================================================================================
                                      HEADER FILE VERSION INFORMATION
==================================================================================================*/
#define CDDTRG_LLD_TMU_REG_VENDOR_ID                      (180)
#define CDDTRG_LLD_TMU_REG_AR_RELEASE_MAJOR_VERSION       (4)
#define CDDTRG_LLD_TMU_REG_AR_RELEASE_MINOR_VERSION       (4)
#define CDDTRG_LLD_TMU_REG_AR_RELEASE_REVISION_VERSION    (0)
#define CDDTRG_LLD_TMU_REG_SW_MAJOR_VERSION               (1)
#define CDDTRG_LLD_TMU_REG_SW_MINOR_VERSION               (0)
#define CDDTRG_LLD_TMU_REG_SW_PATCH_VERSION               (0)

#ifdef __cplusplus
}
#endif

#endif /* End of file CddTrg_Lld_Tmu_Reg.h */

