/*
* @file    CddTrg_Lld_Tmu.h
*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : CddTrg_Lld_Tmu
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V1.0.0.HF001
*
*   (c) Copyright 2020-2025 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifndef CDDTRG_LLD_TMU_H
#define CDDTRG_LLD_TMU_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
                                              INCLUDE FILES
==================================================================================================*/
#include "Std_Types.h"
#include "CddTrg_Lld_Tmu_Types.h"
#include "CddTrg_Cfg.h"
/*==================================================================================================
                                      HEADER FILE VERSION INFORMATION
==================================================================================================*/
#define CDDTRG_LLD_TMU_VENDOR_ID                      (180)
#define CDDTRG_LLD_TMU_AR_RELEASE_MAJOR_VERSION       (4)
#define CDDTRG_LLD_TMU_AR_RELEASE_MINOR_VERSION       (4)
#define CDDTRG_LLD_TMU_AR_RELEASE_REVISION_VERSION    (0)
#define CDDTRG_LLD_TMU_SW_MAJOR_VERSION               (1)
#define CDDTRG_LLD_TMU_SW_MINOR_VERSION               (0)
#define CDDTRG_LLD_TMU_SW_PATCH_VERSION               (0)
/*==================================================================================================
 *                                     FILE VERSION CHECKS
==================================================================================================*/
/* Check if CddTrg_Lld_Tmu.h and CddTrg_Lld_Tmu_Types.h are of the same vendor */
#if (CDDTRG_LLD_TMU_VENDOR_ID != CDDTRG_LLD_TMU_TYPES_VENDOR_ID)
#error "CddTrg_Lld_Tmu.h and CddTrg_Lld_Tmu_Types.h have different vendor ids"
#endif
/* Check if CddTrg_Lld_Tmu.h and CddTrg_Lld_Tmu_Types.h are of the same Autosar version */
#if ((CDDTRG_LLD_TMU_AR_RELEASE_MAJOR_VERSION != CDDTRG_LLD_TMU_TYPES_AR_RELEASE_MAJOR_VERSION) || \
     (CDDTRG_LLD_TMU_AR_RELEASE_MINOR_VERSION != CDDTRG_LLD_TMU_TYPES_AR_RELEASE_MINOR_VERSION) || \
     (CDDTRG_LLD_TMU_AR_RELEASE_REVISION_VERSION != CDDTRG_LLD_TMU_TYPES_AR_RELEASE_REVISION_VERSION))
#error "AutoSar Version Numbers of CddTrg_Lld_Tmu.h and CddTrg_Lld_Tmu_Types.h are different"
#endif
/* Check if CddTrg_Lld_Tmu.h and CddTrg_Lld_Tmu_Types.h are of the same software version */
#if ((CDDTRG_LLD_TMU_SW_MAJOR_VERSION != CDDTRG_LLD_TMU_TYPES_SW_MAJOR_VERSION) || \
     (CDDTRG_LLD_TMU_SW_MINOR_VERSION != CDDTRG_LLD_TMU_TYPES_SW_MINOR_VERSION) || \
     (CDDTRG_LLD_TMU_SW_PATCH_VERSION != CDDTRG_LLD_TMU_TYPES_SW_PATCH_VERSION))
#error "Software Version Numbers of CddTrg_Lld_Tmu.h and CddTrg_Lld_Tmu_Types.h are different"
#endif
/*==================================================================================================
                                                DEFINES AND MACROS
==================================================================================================*/
/*==================================================================================================
                                                EXTERNAL CONSTANTS
==================================================================================================*/
/*==================================================================================================
                                                ENUMS
==================================================================================================*/
/*==================================================================================================
                                                FUNCTION PROTOTYPES
==================================================================================================*/
/**
 * @brief Init the Tmu module
 * @details This function initializes the Tmu module
 * @param TmuCfgPtr  Pointer to the configuration structure
 * @return void
 */
extern void CddTrg_Lld_Tmu_Init(CddTrg_Lld_Tmu_ConfigType const * TmuCfgPtr);

/**
 * @brief DeInit the Tmu module
 * @details This function deinitializes the Tmu module
 * @param void
 * @return void
 */
extern void CddTrg_Lld_Tmu_DeInit(void);

/**
 * @brief Set the trigger source for the target
 * @details This function sets the trigger source for the tmu target channel
 * @param TiggerTarget  The target to set
 * @param TiggerSource  The source to set
 * @return void
 */
extern void CddTrg_Lld_Tmu_SetTriggerSource(CddTrg_TmuTriggerTargetType TiggerTarget, CddTrg_TmuTriggerSourceType TiggerSource);

/**
 * @brief Get the trigger source for the target
 * @details This function gets the trigger source for the tmu target channel
 * @param TiggerTarget  The target to get
 * @return CddTrg_TmuTriggerSourceType
 */
extern CddTrg_TmuTriggerSourceType CddTrg_Lld_Tmu_GetTriggerSource(CddTrg_TmuTriggerTargetType TiggerTarget);

#ifdef __cplusplus
}
#endif

#endif /* End of file CddTrg_Lld_Tmu.h */

