/* USER CODE END Header */
#include "Mcal.h"

uint32 			debug_time[5];
/**************************************************************************************
     ܣ׼usʱ   
 ˵    clk=8M,ʱ537s
**************************************************************************************/
uint32 precise_us_time(uint8 mode)
{
	static uint32 count[2];
    uint32 temp=0;
	switch(mode){
		case 0:	// ʼ
            count[0] = Gpt_GetTimeElapsed(0); 
			break;
		case 1:	// ֹͣ
            count[1] =  Gpt_GetTimeElapsed(0);           
            if(count[1] >=count[0]) temp =count[1]-count[0];
            else                    temp = 0xffffffff-(count[0]-count[1]-1);  
            temp = temp/50;                                                             // 1us(clk=8M)  
			break;
		default:break;
	}
	return(temp);
}


/* Private variables ---------------------------------------------------------*/
Adc_ValueGroupType Adc0_HwTrigGroupRstFIFO[Adc0_HwTrgGroup_CHANNEL_NUMBER];
uint16 Adc0_HwTrigGroupRseultPhys[Adc0_HwTrgGroup_CHANNEL_NUMBER];

volatile uint32 Adc0_HwTrigGroupConCompCnt = 0;

/*Call Back functions which are needed for integration test*/
uint16 max_adc[Adc0_HwTrgGroup_CHANNEL_NUMBER];
uint16 min_adc[Adc0_HwTrgGroup_CHANNEL_NUMBER];


void Adc0_HwTrgGroupNotification(void)
{
debug_time[0]=precise_us_time(1); precise_us_time(0); 
  
    Adc0_HwTrigGroupConCompCnt++;
    if(Adc_GetGroupStatus(AdcConf_AdcConfigSet_Adc0_HwTrgGroup)==ADC_STREAM_COMPLETED)
    {
        Adc_ReadGroup(AdcConf_AdcConfigSet_Adc0_HwTrgGroup, Adc0_HwTrigGroupRseultPhys); 
        for(uint8 LoopCnt = 0; LoopCnt<Adc0_HwTrgGroup_CHANNEL_NUMBER; LoopCnt++)
        {
            Adc0_HwTrigGroupRseultPhys[LoopCnt] = (uint32)Adc0_HwTrigGroupRseultPhys[LoopCnt]*5000/4095;
            // Сֵ
            if(Adc0_HwTrigGroupConCompCnt<1000) {
                max_adc[LoopCnt] = Adc0_HwTrigGroupRseultPhys[LoopCnt];
                min_adc[LoopCnt] = Adc0_HwTrigGroupRseultPhys[LoopCnt];
            }
            else{
                if(Adc0_HwTrigGroupRseultPhys[LoopCnt]>max_adc[LoopCnt]) max_adc[LoopCnt] = Adc0_HwTrigGroupRseultPhys[LoopCnt];
                if(Adc0_HwTrigGroupRseultPhys[LoopCnt]<min_adc[LoopCnt]) min_adc[LoopCnt] = Adc0_HwTrigGroupRseultPhys[LoopCnt];
            }
            
            
        }
    }
}

/* USER CODE END PFDC */
static void Board_Init(void);

/**
 * @brief  The application entry point.
 * @retval int
 */
int main(void)
{
    Mcu_Init(&Mcu_Config);
    Mcu_InitClock(0);
#if (MCU_NO_PLL == STD_OFF)
    while (MCU_PLL_LOCKED != Mcu_GetPllStatus());
    Mcu_DistributePllClock();
#endif
    /* USER CODE END 1 */ 
    Board_Init();
    Adc_SetupResultBuffer(AdcConf_AdcConfigSet_Adc0_HwTrgGroup, Adc0_HwTrigGroupRstFIFO);
    Adc_EnableGroupNotification(AdcConf_AdcConfigSet_Adc0_HwTrgGroup);
    Adc_EnableHardwareTrigger(AdcConf_AdcConfigSet_Adc0_HwTrgGroup);

    while(1);
}

static void Board_Init(void)
{
    Platform_Init(NULL_PTR);
    Port_Init(&Port_Config);
    Adc_Init(&Adc_Config);
    CddTrg_Init(&CddTrg_Config);
    Pwm_Init(&Pwm_Config);
    
    // 4-Gptʱ,ʱ=1s(ʱʱ=8M)
    Gpt_Init(&Gpt_Config);      
    Gpt_StartTimer(0, 0xffffffff);   
    
    
}

/* USER CODE BEGIN 4 */
/* USER CODE END 4 */
