# Adc示例代码

## 工程名称：Adc_HwTrig_Demo

---
## 功能描述

本示例用于演示 MCAL Adc 模块的配置和使用:

- **Adc**: 
  - 该示例展示ADC硬件触发模式配置及使用。
  - 该示例配置了五个通道组组。通道组0到3属于ADC0。通道组4属于ADC1，ADC1配置为硬件触发转换模式，由TMU_IN11触发。
  - ADC0配置为中断模式，所有通道组均配置为软件触发模式进行转换。
  - ADC1配置为DMA模式，所有通道组均配置为硬件触发模式进行转换。
  - PTA0、PTA1、PTA2、PTA3配置为模拟输入引脚，PTA0与PTA1短接，PTA2与PTA3短接。PTA20配置为GPIO OUT，PTC10配置为TMU_IN11。PTA20与PC10短接，作为ADC1的触发信号。

- **Adc_HwTrig_Demo硬件连接需求**
  | 功能 | MCU引脚 | EVB 插针|
  | ---- | ------- | ------ |
  | GPIO | PTA20 | P2_2P |
  | TMU_IN11 | PTC10 | P5_3P |
  | ADC0_S0 | PTA0 | P8_3P |
  | ADC0_S1 | PTA1 | P7_3P |
  | ADC1_S0 | PTA2 | P5_19P |
  | ADC1_S1 | PTA3 | P5_20P |
  **PTA20(P2_2P) 与 PTC10(P5_3P) 短接.**
  **PTA0(P8_3P) 与 PTA2(P5_19P) 短接.**
  **PTA1(P7_3P) 与 PTA3(P5_20P) 短接.**

复位后，初始化Adc模块，然后为所有通道组设置结果缓存区，为需要的通道组启用通知，并启动所有通道组转换。所有通道组将重复启动转换并在while(1)循环中读取结果。所有通道组转换完成后，来自通道组1/2/3的ADC0_VDD25_INT0_ADCH39通道转换结果将相互检查。ADC1 AN0与ADC0 AN0，ADC1 AN1与ADC0 AN1也会相互进行结果检查。

---


## 硬件需求
+ **EVB**: YTM32B1HA01-EVB-Q176-Rev.A
+ **调试器**： J-Link HW v9 或更高版本，安装了 YUNTU YTM32B1HA01 补丁（支持包）。

---

## 软件需求

+ **配置和代码生成工具**
  + **MCAL**:     Yuntu Config Tool(YCT) v2.6 或更高版本
+ **编译器工具链**
  + **GCC**     : GNU GCC v10.3 或更高版本
  + **Keil/MDK**: ARM Keil/MDK v5.36 或更高版本
  + **IAR**     : IAR v8.40 或更高版本
  + **VS Code**  : Microsoft Visual Studio Code IDE v1.76 或更高版本（需要 C/C++ 支持，GNU 工具链，CMake v3.25，ninja，Cortex-Debug 扩展安装）
+ **Debugger driver**
    + **J-Link**              : SEGGER J-Link v7.82 或更高版本，需要安装 YUNTU YTM32B1HA01 补丁（支持包）。
    + **Ozone Debugger tool**  : SEGGER Ozone v3.28 或更高版本。

    ***注意***: * 需要安装 **YTM32B1HA0** 补丁，补丁可通过 **YCT** 工具或联系 ***云途 销售/FAE 团队***获取.

---

## 操作步骤

+ ***步骤1***：使用 YCT 工具打开示例的配置工程文件（`Adc_HwTrig_Demo.yct`），根据您的需求配置工具链（默认使用 VS Code + GCC）。
+ ***步骤2***：生成代码，如果需要，您可以更改配置（以适应您自己的硬件设计），如果这样做，请确保所有修改都正确无误，并且在生成代码之前没有错误存在。
+ ***步骤3***：根据您的配置，使用相应的工具（VS Code/IAR/Keil IDE）打开生成的工程。
+ ***步骤4***：编译生成的工程，打开 EVB 电源并通过可用的调试器（如 J-Link 调试探针）将编译好的可执行文件下载到 EVB。
+ ***步骤5***：调试、运行示例代码。
  
---