# Adc Example Code

## Project Name：Adc_HwTrig_Demo

---
## Function description

This project is designed to demonstrate the MCAL Adc module configuration and usage:
- **Adc**: 
  - This demo shows how the hardware trigger mode of the ADC module works.
  - There are five groups configured in Adc_Config. The groups identified 0 to 3 belong to ADC0. The group identified 4 belongs to ADC1, which is configured to be triggered by TMU_IN11.
  - ADC0 performs conversions with interrupts, and all groups are configured to convert using software trigger mode.
  - ADC1 performs conversions with interrupts, and all groups are configured to convert using hardware trigger mode.
  - The PTA0,PTA1,PTA2,PTA3 are configured to ANx, the PTA0 short to PTA1, adn PTA2 short to PTA3. PTA20 is configured to GPIO pin, and the PTC10 is configured to TMU_IN11. The PTA20 is short to PTC10 as a trigger signal for ADC1. 

+ ***Adc_HwTrig_Demo HW connection diagram***

  | Function | MCU Pin | EVB pin header|
  | ---- | ------- | ------ |
  | GPIO | PTA20 | P2_2P |
  | TMU_IN11 | PTC10 | P5_3P |
  | ADC0_S0 | PTA0 | P8_3P |
  | ADC0_S1 | PTA1 | P7_3P |
  | ADC1_S0 | PTA2 | P5_19P |
  | ADC1_S1 | PTA3 | P5_20P |
  **PTA20(P2_2P) and PTC10(P5_3P) short connect.**
  **PTA0(P8_3P) and PTA2(P5_19P) short connect.**
  **PTA1(P7_3P) and PTA3(P5_20P) short connect.**


After reset, the demo project will initialize the Adc driver , set up result buffers for all group , enable notification for  the necessary groups, and start all group to conversion. All group will be repeatedly start conversion and read the result in while(1). After all channel groups are converted, the ADC0_VDD25_INT0_ADCH39 channel conversion results from group1/2/3 are mutually checked. 

---

## HW requirement
+ **EVB**: YTM32B1HA01-EVB-Q176-Rev.A
+ **Debugger**: J-Link HW v9 or later with YUNTU YTM32B1HA01 patch(support package) installed.

---

## SW requirement

+ **Config & Code Generation Tool**
  + **MCAL**:     Yuntu Config Tool(YCT) v2.6 or later version
+ **Compiler Toolchain**
  + **GCC**     : GNU GCC v10.3 or later version
  + **Keil/MDK**: ARM Keil/MDK v5.36 or later version
  + **IAR**     : IAR v8.40 or later version
  + **VS Code**  : Microsoft Visual Studio Code IDE v1.76 or later version(C/C++ support, GNU toolchain, CMake v3.25, ninja, Cortex-Debug extensions installation required)
+ **Debugger driver**
    + **J-Link**              : SEGGER J-Link v7.82 or later version, YUNTU YTM32B1HA01 patch(support package) installation required.
    + **Ozone Debugger tool**  : SEGGER Ozone v3.28 or later version.

    ***Note***:  **YTM32B1HA0** patch install required which can be obtained via **YCT** or contact ***YUNTU sales/FAE team***.

---

## Setup

+ ***Step1***: Open the `Adc_HwTrig_Demo.yct` with the YCT tool, config the toolchain per your required(by default, the VS code + GCC are used)
+ ***Step2***：Generate the codes， you can change the configurations if needed(to adapt to your own HW design), if so, please ensure all the modifications are OK with no any errors exist before generating the code.
+ ***Step3***: Open the generated project with VS code/IAR/Keil IDE per your selected.
+ ***Step4***: Compile the project, power on the EVB and download it to the EVB via the available debugger, such as a J-Link debugger probe.
+ ***Step5***: At last, enjoy the demo example.
  
---