/* USER CODE BEGIN Header */
/* you can remove the copyright */

/*
 *  Copyright 2020-2023 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 *
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 *
 * @file main.c
 * @brief
 *
 */

/* USER CODE END Header */
#include "Mcal.h"
/* Includes ------------------------------------------------------------------*/

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */
/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
#define GPT_TIMEOUT_PERIOD 250000 /*Task period 5ms*/
/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */
/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
/* USER CODE BEGIN PV */
/*The software result FIFO for all Adc group*/
Adc_ValueGroupType Adc0_Group0RstFIFO[ADC0_GP0_OMSA_CHANNEL_NUMBER];
Adc_ValueGroupType Adc0_Group0RstFIFO[ADC0_GP0_OMSA_CHANNEL_NUMBER];
Adc_ValueGroupType Adc0_Group1RstFIFO[ADC0_GP1_CMSA_CHANNEL_NUMBER];
Adc_ValueGroupType Adc0_Group2RstFIFO[ADC0_GP2_CMLSA_CHANNEL_NUMBER * ADC0_GP2_CMLSA_STEAMING_NUMBER];
Adc_ValueGroupType Adc0_Group3RstFIFO[ADC0_GP3_CMCSA_CHANNEL_NUMBER * ADC0_GP3_CMCSA_STEAMING_NUMBER];

/*The result FIFO for Dma group need to be defined in Non-Cacheable memory*/
#define ADC_START_SEC_VAR_CLEARED_UNSPECIFIED_NO_CACHEABLE
#include "Adc_MemMap.h"
ADC_VAR Adc_ValueGroupType Adc1_Group0RstFIFO[ADC1_GP0_CMSA_CHANNEL_NUMBER];
ADC_VAR Adc_ValueGroupType Adc1_Group1RstFIFO[(ADC1_GP1_CMCSA_CHANNEL_NUMBER)*ADC1_GP1_CMCSA_STEAMING_NUMBER];
#define ADC_STOP_SEC_VAR_CLEARED_UNSPECIFIED_NO_CACHEABLE
#include "Adc_MemMap.h"

Adc_ValueGroupType *Adc_TestResultPtr = NULL_PTR;
uint16 Adc0_Group0RseultPhys[ADC0_GP0_OMSA_CHANNEL_NUMBER];
uint16 Adc0_Group1RseultPhys[ADC0_GP1_CMSA_CHANNEL_NUMBER];
uint16 Adc0_Group2RseultPhys[ADC0_GP2_CMLSA_CHANNEL_NUMBER];
uint16 Adc0_Group3RseultPhys[ADC0_GP3_CMCSA_CHANNEL_NUMBER];
uint16 Adc1_Group0RseultPhys[ADC1_GP0_CMSA_CHANNEL_NUMBER];
uint16 Adc1_Group1RseultPhys[ADC1_GP1_CMCSA_CHANNEL_NUMBER];


volatile uint32 Adc0_Group0ConCompCnt = 0;
volatile uint32 Adc0_Group1ConCompCnt = 0;
volatile uint32 Adc0_Group2ConCompCnt = 0;
volatile uint32 Adc0_Group3ConCompCnt = 0;
volatile uint32 Adc1_Group0ConCompCnt = 0;
volatile uint32 Adc1_Group1ConCompCnt = 0;

uint8 Adc0_ResultNotMatchCnt = 0;
uint8 Adc1_ResultNotMatchCnt = 0;
uint32 Task5msCnt = 0;

volatile boolean Task5msFlag = FALSE;
volatile boolean Task10msFlag = FALSE;
volatile boolean Task20msFlag = FALSE;
volatile boolean Task100msFlag = FALSE;
volatile boolean Task200msFlag = FALSE;
volatile boolean Task500msFlag = FALSE;

uint16 Adc_Group0Chn1RstPre = 0;


/* USER CODE END PV */

/* Private function declare --------------------------------------------------*/
/* USER CODE BEGIN PFDC */

void Callback_PtmrCh0Notifacation(void)
{
    Task5msCnt++;
    Task5msFlag = 1;
    if (0 == (Task5msCnt % 2))
    {
        Task10msFlag = TRUE;
    }

    if (0 == (Task5msCnt % 4))
    {
        Task20msFlag = TRUE;
    }

    if (0 == (Task5msCnt % 20))
    {
        Task100msFlag = TRUE;
    }

    if (0 == (Task5msCnt % 40))
    {
        Task200msFlag = TRUE;
    }

    if (0 == (Task5msCnt % 100))
    {
        Task500msFlag = TRUE;
    }

    if (Task5msCnt >= 200)
    {
        Task5msCnt = 0;
    }
}


/*Call Back functions which are needed for integration test*/
void ADC1_Group0CallBack(void)
{
    Adc1_Group0ConCompCnt++;
}

void ADC1_Group1CallBack(void)
{
    Adc1_Group1ConCompCnt++;
}

void ADC0_Group2CallBack(void)
{
    Adc0_Group2ConCompCnt++;
    if (ADC_STREAM_COMPLETED == Adc_GetGroupStatus(AdcConf_AdcConfigSet_ADC0_GP2_CMLSA))
    {
        Adc_ReadGroup(AdcConf_AdcConfigSet_ADC0_GP2_CMLSA, Adc0_Group2RseultPhys);
        uint8 i = 0;
        for (i = 0; i < ADC0_GP2_CMLSA_CHANNEL_NUMBER; i++)
        {
            Adc0_Group2RseultPhys[i] = (uint32)Adc0_Group2RseultPhys[i] * 5000 / 4096;
        }
    }
    else
    {
    }

}

void ADC0_Group3CallBack(void)
{
    Adc0_Group3ConCompCnt++;

}

/* USER CODE END PFDC */
static void Board_Init(void);

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */
/* USER CODE END 0 */


/**
 * @brief  The application entry point.
 * @retval int
 */
int main(void)
{
    /* USER CODE BEGIN 1 */
    uint16 Adc0_Group1Ch0Rst = 0;
    uint16 Adc0_Group2Ch0Rst = 0;
    uint16 Adc0_Group3Ch0Rst = 0;
    uint32 i = 0;
    Mcu_Init(&Mcu_Config);
    Mcu_InitClock(0);
#if (MCU_NO_PLL == STD_OFF)
    while (MCU_PLL_LOCKED != Mcu_GetPllStatus())
    {
        /* Wait until PLL is locked */
    }
    Mcu_DistributePllClock();
#endif
    /* USER CODE END 1 */ 
    Board_Init();
    /* USER CODE BEGIN 2 */
    /* Start the Gpt timer */
    Gpt_StartTimer(GptConf_GptChannelConfiguration_GptChannelConfiguration_0, GPT_TIMEOUT_PERIOD);
    /* Enable the Gpt notification. */
    Gpt_EnableNotification(GptConf_GptChannelConfiguration_GptChannelConfiguration_0);
    Adc_SetupResultBuffer(AdcConf_AdcConfigSet_ADC0_GP0_OMSA, Adc0_Group0RstFIFO);
    Adc_SetupResultBuffer(AdcConf_AdcConfigSet_ADC0_GP1_CMSA, Adc0_Group1RstFIFO);
    Adc_SetupResultBuffer(AdcConf_AdcConfigSet_ADC0_GP2_CMLSA, Adc0_Group2RstFIFO);
    Adc_SetupResultBuffer(AdcConf_AdcConfigSet_ADC0_GP3_CMCSA, Adc0_Group3RstFIFO);
    Adc_SetupResultBuffer(AdcConf_AdcConfigSet_ADC1_GP0_CMSA, Adc1_Group0RstFIFO);
    Adc_SetupResultBuffer(AdcConf_AdcConfigSet_ADC1_GP1_CMCSA, Adc1_Group1RstFIFO);

    Adc_EnableGroupNotification(AdcConf_AdcConfigSet_ADC0_GP2_CMLSA);
    Adc_EnableGroupNotification(AdcConf_AdcConfigSet_ADC0_GP3_CMCSA);
    Adc_EnableGroupNotification(AdcConf_AdcConfigSet_ADC1_GP0_CMSA);
    Adc_EnableGroupNotification(AdcConf_AdcConfigSet_ADC1_GP1_CMCSA);
    Adc0_Group0ConCompCnt = 0;
    Adc0_Group1ConCompCnt = 0;
    Adc0_Group2ConCompCnt = 0;
    Adc0_Group3ConCompCnt = 0;
    Adc1_Group0ConCompCnt = 0;
    Adc1_Group1ConCompCnt = 0;

    Adc_StartGroupConversion(AdcConf_AdcConfigSet_ADC0_GP0_OMSA);
    Adc_StartGroupConversion(AdcConf_AdcConfigSet_ADC0_GP1_CMSA);
    Adc_StartGroupConversion(AdcConf_AdcConfigSet_ADC0_GP2_CMLSA);
    Adc_StartGroupConversion(AdcConf_AdcConfigSet_ADC0_GP3_CMCSA);
    Adc_StartGroupConversion(AdcConf_AdcConfigSet_ADC1_GP0_CMSA);
    Adc_StartGroupConversion(AdcConf_AdcConfigSet_ADC1_GP1_CMCSA);

    /* USER CODE END 2 */

    /* Infinite loop */
    /* USER CODE BEGIN WHILE */
    while (1)
    {
        /*5ms Task*/
        if (TRUE == Task5msFlag)
        {

            if (Adc_ReadGroup(AdcConf_AdcConfigSet_ADC0_GP0_OMSA, Adc0_Group0RseultPhys) == E_OK)
            {
                for (i = 0; i < ADC0_GP0_OMSA_CHANNEL_NUMBER; i++)
                {
                    Adc0_Group0RseultPhys[i] = (uint32)Adc0_Group0RseultPhys[i] * 5000 / 4096;
                }
                Adc0_Group0ConCompCnt++;

                if (Adc0_Group0ConCompCnt > 1)
                {

                    if ((Adc_Group0Chn1RstPre > (Adc0_Group0RseultPhys[1] + 100)) || (Adc_Group0Chn1RstPre < (Adc0_Group0RseultPhys[1] - 100)))
                    {
                        Adc0_ResultNotMatchCnt++;
                    }
                }
                else
                {

                }
                Adc_Group0Chn1RstPre = Adc0_Group0RseultPhys[1];
                Adc_StartGroupConversion(AdcConf_AdcConfigSet_ADC0_GP0_OMSA);
                while (Adc_GetGroupStatus(AdcConf_AdcConfigSet_ADC0_GP0_OMSA) == ADC_BUSY)
                {    }
            }
            Task5msFlag = FALSE;
        }
        /*10ms Task*/
        if (TRUE == Task10msFlag)
        {

            if(Adc_GetGroupStatus(AdcConf_AdcConfigSet_ADC0_GP1_CMSA) == ADC_STREAM_COMPLETED) 
            {
                Adc_ReadGroup(AdcConf_AdcConfigSet_ADC0_GP1_CMSA, Adc0_Group1RseultPhys);
                for (i = 0; i < ADC0_GP1_CMSA_CHANNEL_NUMBER; i++)
                {
                    Adc0_Group1RseultPhys[i] = (uint32)Adc0_Group1RseultPhys[i] * 5000 / 4096;
                }
                Adc0_Group1ConCompCnt++;
                Adc0_Group1Ch0Rst = Adc0_Group1RseultPhys[5];
            }
            if (Adc_GetGroupStatus(AdcConf_AdcConfigSet_ADC0_GP2_CMLSA) == ADC_IDLE)
            {
                Adc0_Group2Ch0Rst = Adc0_Group2RseultPhys[5];
                if ((Adc0_Group1Ch0Rst > (Adc0_Group2Ch0Rst + 100)) || (Adc0_Group1Ch0Rst < (Adc0_Group2Ch0Rst - 100)))
                {
                    Adc0_ResultNotMatchCnt++;
                }
                if (Adc0_Group2RseultPhys[5] > (Adc0_Group2RseultPhys[8] + 100) || (Adc0_Group2RseultPhys[5] < (Adc0_Group2RseultPhys[8] - 100)))
                {
                    Adc0_ResultNotMatchCnt++;
                }
                if (Adc0_Group2RseultPhys[0] > (Adc0_Group2RseultPhys[10] + 100) || (Adc0_Group2RseultPhys[0] < (Adc0_Group2RseultPhys[10] - 100)))
                {
                    Adc0_ResultNotMatchCnt++;
                }

                Adc_StartGroupConversion(AdcConf_AdcConfigSet_ADC0_GP2_CMLSA);
            }
            Task10msFlag = FALSE;
        }
        /*20ms Task*/
        if (TRUE == Task20msFlag)
        {
            if (Adc_GetGroupStatus(AdcConf_AdcConfigSet_ADC0_GP3_CMCSA) == ADC_STREAM_COMPLETED)
            {
                Adc_GetStreamLastPointer(AdcConf_AdcConfigSet_ADC0_GP3_CMCSA, &Adc_TestResultPtr);
                for (i = 0; i < ADC0_GP3_CMCSA_CHANNEL_NUMBER; i++)
                {
                    Adc0_Group3RseultPhys[i] = (uint32)Adc_TestResultPtr[i] * 5000 / 4096;
                }
                Adc0_Group3Ch0Rst = Adc0_Group3RseultPhys[5];
                if ((Adc0_Group1Ch0Rst > (Adc0_Group3Ch0Rst + 100)) || (Adc0_Group1Ch0Rst < (Adc0_Group3Ch0Rst - 100)))
                {
                    Adc0_ResultNotMatchCnt++;
                }
            }

            if (Adc_ReadGroup(AdcConf_AdcConfigSet_ADC1_GP0_CMSA, Adc1_Group0RseultPhys) == E_OK)
            {
                for (i = 0; i < ADC1_GP0_CMSA_CHANNEL_NUMBER; i++)
                {
                    Adc1_Group0RseultPhys[i] = (uint32)Adc1_Group0RseultPhys[i] * 5000 / 1024;
                }
                /*check the ADC1 channel 0 adn channel 1 conversion result*/
                if (((Adc1_Group0RseultPhys[0] > (Adc0_Group0RseultPhys[0] + 100)) || (Adc1_Group0RseultPhys[0] < (Adc0_Group0RseultPhys[0] - 100))||\
                    (Adc1_Group0RseultPhys[1] > (Adc0_Group0RseultPhys[1] + 100)) || (Adc1_Group0RseultPhys[1] < (Adc0_Group0RseultPhys[1] - 100)))&&\
                    (Adc0_Group0ConCompCnt > 0))
                {
                    Adc1_ResultNotMatchCnt++;
                }
            }

            if (Adc_ReadGroup(AdcConf_AdcConfigSet_ADC1_GP1_CMCSA, Adc1_Group1RseultPhys) == E_OK)
            {
                for (i = 0; i < ADC1_GP1_CMCSA_CHANNEL_NUMBER; i++)
                {
                    Adc1_Group1RseultPhys[i] = (uint32)Adc1_Group1RseultPhys[i] * 5000 / 1024;
                }
                /*check the ADC1 channel 0 adn channel 1 conversion result*/
                if (((Adc1_Group1RseultPhys[0] > (Adc0_Group0RseultPhys[0] + 100)) || (Adc1_Group1RseultPhys[0] < (Adc0_Group0RseultPhys[0] - 100))||\
                    (Adc1_Group1RseultPhys[1] > (Adc0_Group0RseultPhys[1] + 100)) || (Adc1_Group1RseultPhys[1] < (Adc0_Group0RseultPhys[1] - 100)))&&\
                    (Adc0_Group1ConCompCnt > 0))
                {
                    Adc1_ResultNotMatchCnt++;
                }
            }
            Task20msFlag = FALSE;
        }
        /*100ms Task*/
        if (TRUE == Task100msFlag)
        {

            Task100msFlag = FALSE;
        }
        /*200ms Task*/
        if (TRUE == Task200msFlag)
        {
            Dio_FlipChannel(DioConf_DioChannel_LEDR);
            Dio_FlipChannel(DioConf_DioChannel_LEDG);
            Task200msFlag = FALSE;
        }
        /*500ms Task*/
        if (TRUE == Task500msFlag)
        {

            Task500msFlag = FALSE;
        }

        /* USER CODE END WHILE */
        /* USER CODE BEGIN 3 */
    }
    /* USER CODE END 3 */
}

static void Board_Init(void)
{
    Port_Init(&Port_Config);
    CddDma_Init(&CddDma_Config);
    Adc_Init(&Adc_Config);
    Gpt_Init(&Gpt_Config);
    Platform_Init(NULL_PTR);
}

/* USER CODE BEGIN 4 */
/* USER CODE END 4 */
