# Adc Example Code

## Project Name：Adc_Demo

---

## Function description

This project is designed to demonstrate the MCAL Adc module configuration and usage:
- **Adc**: 
  - The demo varifies the Api of Adc ,including Init,read status，start conversion, etc.
  - ADC0 performs conversions with interrupts, after a group conversion completed, the data read from the ADC FIFO register to the result buffer in the IRQ handler.
  - ADC1 performs conversions with DMA, after a group conversion completed, the data is transferred from the ADC FIFO register into the result buffer by DMA.
  - There are six groups configured in Adc_Config. The groups identified 0 to 3 belong to ADC0. The groups identified 4 to 5 belong to ADC1, with ADC1 groups configured to transfer results via DMA. 
  - The PTA0,PTA1,PTA2,PTA3 configured to ANx, the PTA0 short to PTA1, adn PTA2 short to PTA3.
  
- **Adc_Demo HW connection diagram**

  | Function | MCU Pin | EVB pin header|
  | ---- | ------- | ------ |
  | ADC0_S0 | PTA0 | P8_3P |
  | ADC0_S1 | PTA1 | P7_3P |
  | ADC1_S0 | PTA2 | P5_19P |
  | ADC1_S1 | PTA3 | P5_20P |
  **PTA0(P8_3P) and PTA2(P5_19P) short connect.**
  **PTA1(P7_3P) and PTA3(P5_20P) short connect.**

+ ***The FIFOs defined for group with DMA***

  When the cache has been enabled in the Plaform module, the FIFOs for groups transsmitting with DMA must be allocated in a non-cacheable memory area,we can define the result FIFOs as following:

  ```c
  /*The result FIFO for Dma group need to be defined in Non-Cacheable memory*/
  #define ADC_START_SEC_VAR_CLEARED_UNSPECIFIED_NO_CACHEABLE
  #include "Adc_MemMap.h"
  ADC_VAR Adc_ValueGroupType Adc1_Group0RstFIFO[ADC1_GP0_CMSA_CHANNEL_NUMBER];
  ADC_VAR Adc_ValueGroupType Adc1_Group1RstFIFO[ADC1_GP1_CMCSA_CHANNEL_NUMBER];
  #define ADC_STOP_SEC_VAR_CLEARED_UNSPECIFIED_NO_CACHEABLE
  #include "Adc_MemMap.h"

  ```
After reset, the demo project will initialize the Adc driver, set up result buffers for all groups, enable notifications for the necessary groups, and start all groups for conversion. All group will repeatedly start conversion and read the result in while(1).After all channel groups are converted, the ADC0_VDD25_INT0_ADCH39 channel conversion results from group1/2/3 are mutually checked. The ADC1 AN0 need short to ADC0 AN0, and the ADC1 AN1 need short to ADC0 AN1, the conversion results of ADC1 groups will be checked.

---


## HW requirement
+ **EVB**: YTM32B1HA01-EVB-Q176-Rev.A
+ **Debugger**: J-Link HW v9 or later with YUNTU YTM32B1HA01 patch(support package) installed.

---

## SW requirement

+ **Config & Code Generation Tool**
  + **MCAL**:     Yuntu Config Tool(YCT) v2.6 or later version
+ **Compiler Toolchain**
  + **GCC**     : GNU GCC v10.3 or later version
  + **Keil/MDK**: ARM Keil/MDK v5.36 or later version
  + **IAR**     : IAR v8.40 or later version
  + **VS Code**  : Microsoft Visual Studio Code IDE v1.76 or later version(C/C++ support, GNU toolchain, CMake v3.25, ninja, Cortex-Debug extensions installation required)
+ **Debugger driver**
    + **J-Link**              : SEGGER J-Link v7.82 or later version, YUNTU YTM32B1HA01 patch(support package) installation required.
    + **Ozone Debugger tool**  : SEGGER Ozone v3.28 or later version.

    ***Note***:  **YTM32B1HA0** patch install required which can be obtained via **YCT** or contact ***YUNTU sales/FAE team***.

---

## Setup

+ ***Step1***: Open the `Adc_Demo.yct` with the YCT tool, config the toolchain per your required(by default, the VS code + GCC are used)
+ ***Step2***：Generate the codes， you can change the configurations if needed(to adapt to your own HW design), if so, please ensure all the modifications are OK with no any errors exist before generating the code.
+ ***Step3***: Open the generated project with VS code/IAR/Keil IDE per your selected.
+ ***Step4***: Compile the project, power on the EVB and download it to the EVB via the available debugger, such as a J-Link debugger probe.
+ ***Step5***: At last, enjoy the demo example.
  

---