# I2c_Master_Demo

---

## 硬件要求

- **EVB**: YTM32B1LE1-EVB-Q48

---

## 软件要求

- **SDK版本**: YTM32B1LE1_1_4_0 或更高版本
- **配置工具版本**: YCT v2.6.6 或更高版本

---

## EVB硬件设置

以下表格是例程中使用到的外部引脚配置：

|  引脚        |    功能       |
|  ------     |    -----      |
|  PTC9       |    UART1_TX   |
|  PTC8       |    UART1_RX   |
|  PTE5       |    GPIO_OUT   |
|  PTD1       |    I2C0_SCL   |
|  PTD0       |    I2C0_SDA   |

以下表格是EVB硬件连接设置，左端和右端短接：

|  左端        |    右端       |     描述       |
|  ------      |    -----     |     -----      |
|  J1-2        |    5VUSB     |     USB 5V供电  |
|  J2-2        |    5V        |     VDD 5V      |
|  J3-1        |    J3-2      |     单片机工作   |
|  J4-1        |    J4-2      |     VDDA 5V     |
|  J22-3       |    J22-4     |     UART1接收   |
|  J22-5       |    J22-6     |     UART1发送   |
|  J8-1        |    J8-2      |      GPIO OUTPUT     |
|  J8-3        |    J8-4      |      I2C0 SCL        |
|  J8-5        |    J8-6      |      I2C0 SDA        |

---

## 功能描述

- I2C 主机向 EEPROM 写入 8 个字节的数据，第一个字节作为地址，用于指定 EEPROM 的起始写入地址。
- 在从 EEPROM 读取之前，必须先写入一个字节的数据，指定要读取的起始地址。
- 发送地址后，I2C 主机从 EEPROM 读取 7 个字节的数据。
