# I2c_Master_Demo

---

## Hardware Requirements

- **EVB**: YTM32B1LE1-EVB-Q48

---

## Software Requirements

- **SDK Version**: YTM32B1LE1_1_4_0 or later version
- **Config Tool Version**: YCT v2.6.6 or later version

---

## Hardware Setup on EVB

The following table shows the pin configuration of demo:

|  Pin        |    Function   |
|  ------     |    -----      |
|  PTC9       |    UART1_TX   |
|  PTC8       |    UART1_RX   |
|  PTE5       |    GPIO_OUT   |
|  PTD1       |    I2C0_SCL   |
|  PTD0       |    I2C0_SDA   |

The following table shows the hardware connection on EVB, short-L is connected to short-R:

|  Short-L     |    Short-R   |      Description     |
|  ------      |    -----     |      -----           |
|  J1-2        |    5VUSB     |      USB 5V supply   |
|  J2-2        |    5V        |      VDD 5V          |
|  J3-1        |    J3-2      |      MCU work        |
|  J4-1        |    J4-2      |      VDDA 5V         |
|  J22-3       |    J22-4     |      UART1 RXD       |
|  J22-5       |    J22-6     |      UART1 TXD       |
|  J8-1        |    J8-2      |      GPIO OUTPUT     |
|  J8-3        |    J8-4      |      I2C0 SCL        |
|  J8-5        |    J8-6      |      I2C0 SDA        |
---

## Function Description

  - The I2C master writes 8 bytes of data to the EEPROM, with the first byte serving as the address to specify the starting address for writing to the EEPROM.
  - Before reading from the EEPROM, it is necessary to write a byte of data that specifies the starting address to be read.
  - After sending the address, the I2C master reads 7 bytes from the EEPROM.
