/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file Intm_Lld_CfgDefines.h
 * @brief 
 * 
 */


#ifndef INTM_LLD_CFGDEFINES_H
#define INTM_LLD_CFGDEFINES_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
                                              INCLUDE FILES                                          
==================================================================================================*/

#include "Std_Types.h"
#include "pSIP_Intm.h"

/*==================================================================================================
                                      HEADER FILE VERSION INFORMATION                                
==================================================================================================*/
#define INTM_LLD_CFG_DEFINES_VENDOR_ID             		  (180)
#define INTM_LLD_CFG_DEFINES_AR_REL_MAJOR_VER              (4)
#define INTM_LLD_CFG_DEFINES_AR_REL_MINOR_VER              (4)
#define INTM_LLD_CFG_DEFINES_AR_REL_REVISION_VER           (0)
#define INTM_LLD_CFG_DEFINES_SW_MAJOR_VER                  (2)
#define INTM_LLD_CFG_DEFINES_SW_MINOR_VER                  (2)
#define INTM_LLD_CFG_DEFINES_SW_PATCH_VER                  (0)
/*==================================================================================================
                                                DEFINES AND MACROS                                       
==================================================================================================*/

/* Development error detection */
#define INTM_LLD_DEV_ERROR_DETECT            (STD_ON)

/**
* @brief Support for User mode.
*        If this parameter has been configured to 'STD_ON', the INTM PLATFORM driver code can be executed from both supervisor and user mode.
*/
#define INTM_PLATFORM_ENABLE_USER_MODE_SUPPORT   (STD_OFF)

/*==================================================================================================
                                                EXTERNAL CONSTANTS                                        
==================================================================================================*/
/*==================================================================================================
                                                ENUMS                                        
==================================================================================================*/
/*==================================================================================================
                                                FUNCTION PROTOTYPES                                           
==================================================================================================*/


/**
* @brief          Enumeration exposing the available interrupt monitors.
* @implements     Intm_Lld_MonitorType_Class
*/
typedef enum
{
    /** @brief Interrupt monitor 0 */
    INTM_LLD_MONITOR0 = 0,
    /** @brief Interrupt monitor 1 */
    INTM_LLD_MONITOR1 = 1,
    /** @brief Interrupt monitor 2 */
    INTM_LLD_MONITOR2 = 2,
    /** @brief Interrupt monitor 3 */
    INTM_LLD_MONITOR3 = 3
}Intm_Lld_MonitorType;

#ifdef __cplusplus
}
#endif

#endif /* End of file Intm_Lld_CfgDefines.h */

