/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file undefined
 * @brief 
 * 
 */

#include "Fls_Types.h"

/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define FLS_VENDOR_ID_PBCFG_C               (180)
#define FLS_AR_REL_MAJOR_VER_PBCFG_C        (4)
#define FLS_AR_REL_MINOR_VER_PBCFG_C        (4)
#define FLS_AR_REL_REVISION_VER_PBCFG_C     (0)
#define FLS_SW_MAJOR_VER_PBCFG_C            (2)
#define FLS_SW_MINOR_VER_PBCFG_C            (2)
#define FLS_SW_PATCH_VER_PBCFG_C            (0)

/*==================================================================================================
 *                                       Function Prototypes
==================================================================================================*/

#define FLS_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "Fls_MemMap.h"
/*================================================================================================== */
FLS_CONST const Fls_SectorType Fls_SectorConfig[4] ={
    {
                        
        .SectorId = FlsConf_FlsConfigSet_DFLASH_0,
        .SectorStartAddress = 0x0U,
        .SectorSize = 0x800U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x100000U,
        .AsyncAccess = TRUE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_DFLASH_1,
        .SectorStartAddress = 0x800U,
        .SectorSize = 0x400U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x100800U,
        .AsyncAccess = TRUE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_PFLASH_0,
        .SectorStartAddress = 0xc00U,
        .SectorSize = 0x800U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0xde000U,
        .AsyncAccess = FALSE,
    },
    {
                        
        .SectorId = FlsConf_FlsConfigSet_DFLASH_2,
        .SectorStartAddress = 0x1400U,
        .SectorSize = 0x400U,
        .PageSize = 0x8U,
        .SectorHwStartAddress = 0x13fc00U,
        .AsyncAccess = TRUE,
    },
};

FLS_CONST const Fls_SectorProtectType Fls_SectorProtectConfig[FLS_INTERNAL_BLOCK_NUM] ={
                                
    0x0U,
    0x0U,
    0x80000000U,
};

FLS_CONST const Fls_ConfigType Fls_Config = {
    .AcEraseFunPtr = NULL_PTR,
    .AcWriteFunPtr = NULL_PTR,
    .JobEndNotificationFunPtr = NULL_PTR,
    .JobErrorNotificationFunPtr = NULL_PTR,
    .DefaultMode = MEMIF_MODE_SLOW,
    .MaxReadFastMode = 10240U,
    .MaxReadNormalMode = 1024U,
    .MaxWriteFastMode = 256U,
    .MaxWriteNormalMode = 8U,
    .ConfiguredSectorNumber = 4U,
    .SectorList = Fls_SectorConfig,
    .SectorProtection = Fls_SectorProtectConfig,
};

#define FLS_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "Fls_MemMap.h"

