/* USER CODE BEGIN Header */
/* you can remove the copyright */

/*
 *  Copyright 2020-2023 Yuntu Microelectronics co.,ltd
 *  All rights reserved.
 * 
 *  YUNTU Confidential. This software is owned or controlled by YUNTU and may only be
 *  used strictly in accordance with the applicable license terms. By expressly
 *  accepting such terms or by downloading, installing, activating and/or otherwise
 *  using the software, you are agreeing that you have read, and that you agree to
 *  comply with and are bound by, such license terms. If you do not agree to be
 *  bound by the applicable license terms, then you may not retain, install,
 *  activate or otherwise use the software. The production use license in
 *  Section 2.3 is expressly granted for this software.
 * 
 * @file main.c
 * @brief 
 * 
 */

/* USER CODE END Header */
#include "Mcal.h"
/* Includes ------------------------------------------------------------------*/

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */
/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */
/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
/* USER CODE BEGIN PV */
uint8 Fls_WriteData[2048] = {0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08};
uint8 Fls_ReadData[8] = {0};
/* USER CODE END PV */

/* Private function declare --------------------------------------------------*/
/* USER CODE BEGIN PFDC */
/* USER CODE END PFDC */
static void Board_Init(void);

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */
/* USER CODE END 0 */


/**
 * @brief  The application entry point.
 * @retval int
 */
int main(void)
{
    /* USER CODE BEGIN 1 */

  uint16 LoopCnt= 0;
  /* USER CODE END 1 */ 
    Board_Init();
    /* USER CODE BEGIN 2 */
    Fls_Init(&Fls_Config);

  /*Operate the sector FlsConf_FlsConfigSet_DFLASH_0,the step is as follows:
  *step I  :erase the sector,
  *step II :write Fls_WriteData to the sector 0 to 7 byte,
  *step III:read the sector 0 to 7 byte to Fls_ReadData,and check the data,
  *step IV :compare the data in flash,
  *step V  :if the Fls_WriteData and Fls_ReadData are equal,then the test is pass and erase the sector.
  *step VI :verify the Flash blank or not
  */

    /*step I :erase sector FlsConf_FlsConfigSet_DFLASH_0*/
    Fls_Erase(Fls_Config.SectorList[FlsConf_FlsConfigSet_DFLASH_0].SectorStartAddress, Fls_Config.SectorList[FlsConf_FlsConfigSet_DFLASH_0].SectorSize);
    do
    {
      Fls_MainFunction();
    } while (Fls_GetStatus() != MEMIF_IDLE);

    /*step II: write data to FlsConf_FlsConfigSet_DFLASH_0*/
    for(LoopCnt= 0; LoopCnt< 0x800; LoopCnt++)
    {
      Fls_WriteData[LoopCnt] = LoopCnt%0x100U;
    }
    Fls_Write(Fls_Config.SectorList[FlsConf_FlsConfigSet_DFLASH_0].SectorStartAddress, Fls_WriteData, 0x800U);
    do
    {
      Fls_MainFunction();
    } while (Fls_GetStatus() != MEMIF_IDLE);

    /*step III:read the sector FlsConf_FlsConfigSet_DFLASH_0 0 to 7 byte to Fls_ReadData*/
    for(LoopCnt = 0; LoopCnt < 8; LoopCnt++)
    {
      Fls_ReadData[LoopCnt] = 0;
    }
    Fls_Read(Fls_Config.SectorList[FlsConf_FlsConfigSet_DFLASH_0].SectorStartAddress, Fls_ReadData, 8U);
    do
    {
      Fls_MainFunction();
    } while (Fls_GetStatus() != MEMIF_IDLE);

    for(LoopCnt = 0; LoopCnt < 8; LoopCnt++)
    {
      if(Fls_ReadData[LoopCnt] != Fls_WriteData[LoopCnt])
      {
        while(1);
      }
    }

    for(LoopCnt = 0; LoopCnt < 8; LoopCnt++)
    {
      Fls_ReadData[LoopCnt] = 0;
    }
    Fls_Read((Fls_Config.SectorList[FlsConf_FlsConfigSet_DFLASH_0].SectorStartAddress+0x7F8), Fls_ReadData, 8);
    do
    {
      Fls_MainFunction();
    } while (Fls_GetStatus() != MEMIF_IDLE);

    for(LoopCnt = 0; LoopCnt < 8; LoopCnt++)
    {
      if(Fls_ReadData[LoopCnt] != Fls_WriteData[LoopCnt+0x7F8])
      {
        while(1);
      }
    }

    /*step IV :compare the data in flash,*/
    Fls_Compare(Fls_Config.SectorList[FlsConf_FlsConfigSet_DFLASH_0].SectorStartAddress, Fls_WriteData, 0x800);
    do
    {
      Fls_MainFunction();
    } while (Fls_GetStatus() != MEMIF_IDLE);

    while((Fls_GetJobResult() != MEMIF_JOB_OK))
    {}

    /*step V  : erase sector FlsConf_FlsConfigSet_DFLASH_0*/
    Fls_Erase(Fls_Config.SectorList[FlsConf_FlsConfigSet_DFLASH_0].SectorStartAddress, Fls_Config.SectorList[FlsConf_FlsConfigSet_DFLASH_0].SectorSize);
    do
    {
      Fls_MainFunction();
    } while (Fls_GetStatus() != MEMIF_IDLE);

    /* step VI :verify the Flash blank or not */
    Fls_BlankCheck(Fls_Config.SectorList[FlsConf_FlsConfigSet_DFLASH_0].SectorStartAddress, Fls_Config.SectorList[FlsConf_FlsConfigSet_DFLASH_0].SectorSize);
    do
    {
      Fls_MainFunction();
    } while (Fls_GetStatus() != MEMIF_IDLE);

    while((Fls_GetJobResult() != MEMIF_JOB_OK))
    {}

  /*FlsConf_FlsConfigSet_PFLASH_0 sector test,the step as follow:
  *step I  :erase the FlsConf_FlsConfigSet_PFLASH_0,
  *step II :write Fls_WriteData to the FlsConf_FlsConfigSet_PFLASH_0 0 to 7 byte,
  *step III:read the FlsConf_FlsConfigSet_PFLASH_0 0 to 7 byte to Fls_ReadData,
  *step IV :compare the Fls_WriteData and Fls_ReadData,if not pass ,while(1),else erase the FlsConf_FlsConfigSet_PFLASH_0,
  *step V  :erase the FlsConf_FlsConfigSet_PFLASH_0.
  */
    /*step I :erase sector FlsConf_FlsConfigSet_PFLASH_0*/
    Fls_Erase(Fls_Config.SectorList[FlsConf_FlsConfigSet_PFLASH_0].SectorStartAddress, Fls_Config.SectorList[FlsConf_FlsConfigSet_PFLASH_0].SectorSize);
    do
    {
      Fls_MainFunction();
    } while (Fls_GetStatus() != MEMIF_IDLE);

    /*step II: write data to FlsConf_FlsConfigSet_PFLASH_0*/
    Fls_Write(Fls_Config.SectorList[FlsConf_FlsConfigSet_PFLASH_0].SectorStartAddress, Fls_WriteData, 8);
    do
    {
      Fls_MainFunction();
    } while (Fls_GetStatus() != MEMIF_IDLE);
    
    /*step III:read the sector FlsConf_FlsConfigSet_PFLASH_0 0 to 7 byte to Fls_ReadData*/
    for(LoopCnt = 0; LoopCnt < 8; LoopCnt++)
    {
      Fls_ReadData[LoopCnt] = 0;
    }
    Fls_Read(Fls_Config.SectorList[FlsConf_FlsConfigSet_PFLASH_0].SectorStartAddress, Fls_ReadData, 8);
    do
    {
      Fls_MainFunction();
    } while (Fls_GetStatus() != MEMIF_IDLE);
    for(LoopCnt = 0; LoopCnt < 8; LoopCnt++)
    {
      if(Fls_ReadData[LoopCnt] != Fls_WriteData[LoopCnt])
      {
        while(1);
      }
    }

    /*step V  : erase sector FlsConf_FlsConfigSet_PFLASH_0*/
    Fls_Erase(Fls_Config.SectorList[FlsConf_FlsConfigSet_PFLASH_0].SectorStartAddress, Fls_Config.SectorList[FlsConf_FlsConfigSet_PFLASH_0].SectorSize);
    do
    {
      Fls_MainFunction();
    } while (Fls_GetStatus() != MEMIF_IDLE);

    /*FlsConf_FlsConfigSet_DFLASH_2 sector test,the step as follow:
     It's a protected sector, can't be erased.
    */
    Fls_Erase(Fls_Config.SectorList[FlsConf_FlsConfigSet_DFLASH_2].SectorStartAddress, Fls_Config.SectorList[FlsConf_FlsConfigSet_DFLASH_2].SectorSize);
    do
    {
      Fls_MainFunction();
    } while (Fls_GetStatus() != MEMIF_IDLE);
    if(Fls_GetJobResult() != MEMIF_JOB_FAILED)
    {
      while(1);
    }
  /* USER CODE END 2 */

    /* Infinite loop */
    /* USER CODE BEGIN WHILE */
    while (1)
    {
      /* USER CODE END WHILE */
        /* USER CODE BEGIN 3 */
    }
  /* USER CODE END 3 */
}

static void Board_Init(void)
{
}

/* USER CODE BEGIN 4 */
/* USER CODE END 4 */
