# Fls示例代码

## 工程名称：Fls_Demo

---
## 功能描述

本示例用于演示 MCAL Fls 模块的配置和使用:

- **Fls**: 
  - 测试 Fls 的擦除、写入、读取、比较以及空白检查等API；
  - 配置 PFLASH 和 DFLASH 扇区；
  - 测试 EFM 扇区保护功能；

复位后，初始化 Fls 模块并执行以下测试:
+ 擦除在 Fls_Config 中配置的扇区 0(DFLASH)；
+ 将 2048 字节数据写入地址 0 到 0x7FF（虚拟地址）中；
+ 从地址 0 到 7 读取数据并与写入的数据进行比较是否相同； 
+ 使用 Fls_Compare 比较 0x00 到 0x7FF 范围内的数据，以验证其是否与写入数据相同；
+ 再次擦除在 Fls_Config 中配置的扇区 0；
+ 检查擦除操作后扇区0是否为空白区域；
+ 在 Fls_Config 中配置的 PFLASH 扇区以同步模式重复进行上述操作；
+ 最后 8 个 DFLASH 扇区使能扇区保护功能。擦除这些受保护的扇区时，操作将失败，Fls结果读取API返回为MEMIF_JOB_FAILED；

---


## 硬件需求
+ **EVB**: YTM32B1ME0-Q144-EVB-REVB
+ **调试器**： J-Link HW v9 或更高版本，安装了 YUNTU YTM32B1ME0 补丁（支持包）。

---

## 软件需求

+ **配置和代码生成工具**
  + **MCAL**:     Yuntu Config Tool(YCT) v2.6 或更高版本
+ **编译器工具链**
  + **GCC**     : GNU GCC v10.3 或更高版本
  + **Keil/MDK**: ARM Keil/MDK v5.36 或更高版本
  + **IAR**     : IAR v8.40 或更高版本
  + **VS Code**  : Microsoft Visual Studio Code IDE v1.76 或更高版本（需要 C/C++ 支持，GNU 工具链，CMake v3.25，ninja，Cortex-Debug 扩展安装）
+ **Debugger driver**
    + **J-Link**              : SEGGER J-Link v7.82 或更高版本，需要安装 YUNTU YTM32B1ME0 补丁（支持包）。
    + **Ozone Debugger tool**  : SEGGER Ozone v3.28 或更高版本。

    ***注意***: * 需要安装 **YTM32B1ME0** 补丁，补丁可通过 **YCT** 工具或联系 ***云途 销售/FAE 团队***获取.

---

## 操作步骤

+ ***步骤1***：使用 YCT 工具打开示例的配置工程文件（`Fls_Demo.yct`），根据您的需求配置工具链（默认使用 VS Code + GCC）。
+ ***步骤2***：生成代码，如果需要，您可以更改配置（以适应您自己的硬件设计），如果这样做，请确保所有修改都正确无误，并且在生成代码之前没有错误存在。
+ ***步骤3***：根据您的配置，使用相应的工具（VS Code/IAR/Keil IDE）打开生成的工程。
+ ***步骤4***：编译生成的工程，打开 EVB 电源并通过可用的调试器（如 J-Link 调试探针）将编译好的可执行文件下载到 EVB。
+ ***步骤5***：调试、运行示例代码。
  
---