# Fls Example Code

## Project Name：Fls_Demo


---


## Function description

This project is designed to demonstrate the MCAL Fls module config and usage:
- **Fls**: 
  - Test the Api of Fls Erase, Write, Read, Compare and BlankCheck
  - PFLASH and DFLASH sectors are configured
  - Test the EFM sector protected

After reset, the demo project initializes the Fls driver and performs the following tests:
+ Erase the sector 0(DFLASH) which configured in Fls_Config.
+ Wirte 2048 byte data to address 0 to 0x7FF.
+ Read data from address 0 to 7 and compare the write data. 
+ Compare the data in the range from 0x00 to 0x7FF using Fls_Compare to verify if it matches the write buffer.
+ Erase the sector 0 again.
+ Check if the sector is blank after the erase operation.
+ The PFLASH sectors configured in Fls_Config is operated similarly to the above steps in sync mode. 
+ The last 8 DFLASH sectors are configured for sector protection testing in the demo. When attempting to erase these protected sectors, the operation will result in failure.
  
---


## HW requirement
+ **EVB**: YTM32B1ME0-Q144-EVB-REVB
+ **Debugger**: J-Link HW v9 or later with YUNTU YTM32B1ME0 patch(support package) installed.

---

## SW requirement

+ **Config & Code Generation Tool**
  + **MCAL**:     Yuntu Config Tool(YCT) v2.6 or later version
+ **Compiler Toolchain**
  + **GCC**     : GNU GCC v10.3 or later version
  + **Keil/MDK**: ARM Keil/MDK v5.36 or later version
  + **IAR**     : IAR v8.40 or later version
  + **VS Code**  : Microsoft Visual Studio Code IDE v1.76 or later version(C/C++ support, GNU toolchain, CMake v3.25, ninja, Cortex-Debug extensions installation required)
+ **Debugger driver**
    + **J-Link**              : SEGGER J-Link v7.82 or later version, YUNTU YTM32B1ME0 patch(support package) installation required.
    + **Ozone Debugger tool**  : SEGGER Ozone v3.28 or later version.

    ***Note***:  **YTM32B1ME0** patch install required which can be obtained via **YCT** or contact ***YUNTU sales/FAE team***.

---

## Setup

+ ***Step1***: Open the `Fls_Demo.yct` with the YCT tool, config the toolchain per your required(by default, the VS code + GCC are used)
+ ***Step2***：Generate the codes， you can change the configurations if needed(to adapt to your own HW design), if so, please ensure all the modifications are OK with no any errors exist before generating the code.
+ ***Step3***: Open the generated project with VS code/IAR/Keil IDE per your selected.
+ ***Step4***: Compile the project, power on the EVB and download it to the EVB via the available debugger, such as a J-Link debugger probe.
+ ***Step5***: At last, enjoy the demo example.


---