cmake_minimum_required(VERSION 3.16)



set(sources
    ${PROJ_DIR}/Mcal/Mcu/src/Mcu.c
    ${PROJ_DIR}/Mcal/Mcu/src/Mcu_Lld.c
    ${PROJ_DIR}/Mcal/Mcu/src/Mcu_Lld_Irq.c
    ${PROJ_DIR}/Mcal/Rte/src/SchM_Mcu.c
    ${PROJ_DIR}/Mcal/Rte/src/SchM_Can.c
    ${PROJ_DIR}/Mcal/Rte/src/SchM_Crc.c
    ${PROJ_DIR}/Mcal/Rte/src/SchM_Dio.c
    ${PROJ_DIR}/Mcal/Rte/src/SchM_Fls.c
    ${PROJ_DIR}/Mcal/Rte/src/SchM_Gpt.c
    ${PROJ_DIR}/Mcal/Rte/src/SchM_Port.c
    ${PROJ_DIR}/Mcal/Rte/src/SchM_Wdg_180_Inst0.c
    ${PROJ_DIR}/Mcal/Rte/src/SchM_Platform.c
    ${PROJ_DIR}/Mcal/Rte/src/SchM_CddUart.c
    ${PROJ_DIR}/Mcal/Rte/src/SchM_DmaTst.c
    ${PROJ_DIR}/Mcal/Rte/src/SchM_IntTst.c
    ${PROJ_DIR}/Mcal/Rte/src/SchM_RamTst.c
    ${PROJ_DIR}/Mcal/Rte/src/SchM_CorTst.c
    ${PROJ_DIR}/Mcal/Can/src/Can.c
    ${PROJ_DIR}/Mcal/Can/src/Can_Lld.c
    ${PROJ_DIR}/Mcal/Can/src/Can_Lld_Irq.c
    ${PROJ_DIR}/Mcal/Crc/src/Crc.c
    ${PROJ_DIR}/Mcal/Crc/src/Crc_Lld.c
    ${PROJ_DIR}/Mcal/Dio/src/Dio_Lld.c
    ${PROJ_DIR}/Mcal/Dio/src/Dio.c
    ${PROJ_DIR}/Mcal/CanIf/src/CanIf.c
    ${PROJ_DIR}/Mcal/Det/src/Det.c
    ${PROJ_DIR}/Mcal/Fls/src/Fls.c
    ${PROJ_DIR}/Mcal/Fls/src/Fls_Mld.c
    ${PROJ_DIR}/Mcal/Fls/src/Fls_Lld.c
    ${PROJ_DIR}/Mcal/Gpt/src/Gpt.c
    ${PROJ_DIR}/Mcal/Gpt/src/Gpt_Mld.c
    ${PROJ_DIR}/Mcal/Gpt/src/Gpt_Lld_Lptmr.c
    ${PROJ_DIR}/Mcal/Gpt/src/Gpt_Lld_Lptmr_Irq.c
    ${PROJ_DIR}/Mcal/Gpt/src/Gpt_Lld_Ptmr.c
    ${PROJ_DIR}/Mcal/Gpt/src/Gpt_Lld_Ptmr_Irq.c
    ${PROJ_DIR}/Mcal/Gpt/src/Gpt_Lld_Tmr.c
    ${PROJ_DIR}/Mcal/Gpt/src/Gpt_Lld_Tmr_Irq.c
    ${PROJ_DIR}/Mcal/Gpt/src/Gpt_Lld_Rtc.c
    ${PROJ_DIR}/Mcal/Gpt/src/Gpt_Lld_Rtc_Irq.c
    ${PROJ_DIR}/Mcal/Port/src/Port.c
    ${PROJ_DIR}/Mcal/Port/src/Port_Lld.c
    ${PROJ_DIR}/Mcal/Wdg/src/Wdg_Mld_Irq.c
    ${PROJ_DIR}/Mcal/Wdg/src/Wdg_180_Inst0.c
    ${PROJ_DIR}/Mcal/Wdg/src/Wdg_Lld.c
    ${PROJ_DIR}/Mcal/Wdg/src/Wdg_Lld_Irq.c
    ${PROJ_DIR}/Mcal/WdgIf/src/WdgIf.c
    ${PROJ_DIR}/Mcal/Platform/src/exceptions.c
    ${PROJ_DIR}/Mcal/Platform/src/IntCtrl_Lld.c
    ${PROJ_DIR}/Mcal/Platform/src/OsIf.c
    ${PROJ_DIR}/Mcal/Platform/src/Platform_Mld.c
    ${PROJ_DIR}/Mcal/Platform/src/Platform.c
    ${PROJ_DIR}/Mcal/Platform/src/System_Lld.c
    ${PROJ_DIR}/Mcal/Platform/src/Mpu_Lld_M33.c
    ${PROJ_DIR}/Mcal/Platform/src/Intm_Lld.c
    ${PROJ_DIR}/Mcal/Dem/src/Dem.c
    ${PROJ_DIR}/Mcal/CddUart/src/CddUart.c
    ${PROJ_DIR}/Mcal/CddUart/src/CddUart_Mld.c
    ${PROJ_DIR}/Mcal/CddUart/src/CddUart_Lld_LinFlexD.c
    ${PROJ_DIR}/Mcal/CddUart/src/CddUart_Lld_LinFlexD_Irq.c
    ${PROJ_DIR}/SafLib/DmaTst/src/DmaTst.c
    ${PROJ_DIR}/SafLib/DmaTst/src/DmaTst_Lld.c
    ${PROJ_DIR}/SafLib/IntTst/src/IntTst.c
    ${PROJ_DIR}/SafLib/IntTst/src/IntTst_Lld_Intm.c
    ${PROJ_DIR}/SafLib/IntTst/src/IntTst_Lld_Ptmr.c
    ${PROJ_DIR}/SafLib/ClkTst/src/ClkTst.c
    ${PROJ_DIR}/SafLib/ClkTst/src/ClkTst_Lld.c
    ${PROJ_DIR}/SafLib/RamTst/src/RamTst.c
    ${PROJ_DIR}/SafLib/RamTst/src/RamTst_Lld.c
    ${PROJ_DIR}/SafLib/EccTst/src/EccTst.c
    ${PROJ_DIR}/SafLib/EccTst/src/EccTst_Lld_Fls.c
    ${PROJ_DIR}/SafLib/EccTst/src/EccTst_Lld_Can.c
    ${PROJ_DIR}/SafLib/EccTst/src/EccTst_Lld_Ram.c
    ${PROJ_DIR}/SafLib/WdgTst/src/SchM_WdgTst.c
    ${PROJ_DIR}/SafLib/WdgTst/src/WdgTst.c
    ${PROJ_DIR}/SafLib/WdgTst/src/WdgTst_Lld.c
    ${PROJ_DIR}/SafLib/CrcTst/src/CrcTst.c
    ${PROJ_DIR}/SafLib/CrcTst/src/SchM_CrcTst.c
    ${PROJ_DIR}/SafLib/CrcTst/src/CrcTst_Lld_Crc.c
    ${PROJ_DIR}/SafLib/FlsTst/src/FlsTst.c
    ${PROJ_DIR}/SafLib/FlsTst/src/SchM_FlsTst.c
    ${PROJ_DIR}/SafLib/StkTst/src/StkTst.c
    ${PROJ_DIR}/SafLib/EfmTst/src/EfmTst.c
    ${PROJ_DIR}/SafLib/EfmTst/src/EfmTst_Lld.c
    ${PROJ_DIR}/SafLib/PpuTst/src/PpuTst.c
    ${PROJ_DIR}/SafLib/PpuTst/src/PpuTst_Lld.c
    ${PROJ_DIR}/SafLib/CorTst/Asm/m33_cst_exception_lib.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/m33_cst_exception_wrappers.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/m33_cst_fpu_lib.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/m33_cst_lib.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/m33_cst_vector_table.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_alu_test1.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_alu_test2.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_alu_test3.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_alu_test4.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_branch_test1.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_branch_test2.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_branch_test3.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_div_test.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_exception_bus_fault_test.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_exception_hard_fault_test1.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_exception_hard_fault_test2.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_exception_mem_fault_test.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_exception_nmi_test.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_exception_pendsv_test.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_exception_systick_test.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_exception_test_svc.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_exception_usage_fault_test.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_fetch_test.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_forwarding_test1.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_forwarding_test2.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_forwarding_test3.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_forwarding_test4.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_loadstore_test1.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_loadstore_test2.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_loadstore_test3.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_loadstore_test4.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_loadstore_test5.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_loadstore_test6.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_mac_test.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_mpu_test.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_regbank_test.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_simdsat_test1.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_simdsat_test2.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_simdsat_test3.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_simdsat_test4.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_spfpu_adder_test.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_spfpu_cmp_test.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_spfpu_convert_test1.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_spfpu_convert_test2.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_spfpu_div.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_spfpu_exception_stack_test.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_spfpu_forwarding_test.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_spfpu_loadstore_test.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_spfpu_mac_test.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_spfpu_minmax.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_spfpu_regbank_test1.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_spfpu_regbank_test2.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_spfpu_rounding_test.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_status_test1.S
    ${PROJ_DIR}/SafLib/CorTst/Asm/tests/m33_cst_status_test2.S
    ${PROJ_DIR}/SafLib/CorTst/src/CorTst_Data.c
    ${PROJ_DIR}/SafLib/CorTst/src/CorTst_Shell.c
    ${PROJ_DIR}/SafLib/CorTst/src/CorTst.c
)
set(includes
    ${PROJ_DIR}/Mcal/Mcu/inc
    ${PROJ_DIR}/Mcal/Rte/inc
    ${PROJ_DIR}/Mcal/Can/inc
    ${PROJ_DIR}/Mcal/Crc/inc
    ${PROJ_DIR}/Mcal/Dio/inc
    ${PROJ_DIR}/Mcal/CanIf/inc
    ${PROJ_DIR}/Mcal/Det/inc
    ${PROJ_DIR}/Mcal/Fls/inc
    ${PROJ_DIR}/Mcal/Gpt/inc
    ${PROJ_DIR}/Mcal/MemIf/inc
    ${PROJ_DIR}/Mcal/Port/inc
    ${PROJ_DIR}/Mcal/Wdg/inc
    ${PROJ_DIR}/Mcal/WdgIf/inc
    ${PROJ_DIR}/Mcal/Platform/inc
    ${PROJ_DIR}/Mcal/Platform/core
    ${PROJ_DIR}/Mcal/Platform/YTM32B1ME0/feature
    ${PROJ_DIR}/Mcal/Platform/YTM32B1ME0/regmap
    ${PROJ_DIR}/Mcal/Dem/inc
    ${PROJ_DIR}/Mcal/CddUart/inc
    ${PROJ_DIR}/SafLib/DmaTst/inc
    ${PROJ_DIR}/SafLib/IntTst/inc
    ${PROJ_DIR}/SafLib/ClkTst/inc
    ${PROJ_DIR}/SafLib/RamTst/inc
    ${PROJ_DIR}/SafLib/EccTst/inc
    ${PROJ_DIR}/SafLib/WdgTst/inc
    ${PROJ_DIR}/SafLib/CrcTst/inc
    ${PROJ_DIR}/SafLib/FlsTst/inc
    ${PROJ_DIR}/SafLib/StkTst/inc
    ${PROJ_DIR}/SafLib/EfmTst/inc
    ${PROJ_DIR}/SafLib/PpuTst/inc
    ${PROJ_DIR}/SafLib/CorTst/inc
)
set(priIncludes
)

add_library(GENERATED_SDK_TARGET STATIC ${sources})

target_include_directories(GENERATED_SDK_TARGET PUBLIC ${includes})


target_include_directories(GENERATED_SDK_TARGET PRIVATE ${priIncludes})
configcore(GENERATED_SDK_TARGET ${CMAKE_SOURCE_DIR})

target_compile_definitions(GENERATED_SDK_TARGET PUBLIC
    YTM32B1ME0
    CPU_YTM32B1ME0
)
target_compile_options(GENERATED_SDK_TARGET PUBLIC
    -fdiagnostics-color=always
)



target_link_libraries(GENERATED_SDK_TARGET
    GENERATED_CONFIG_TARGET
)
