
/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file vector.S
 * @brief 
 * 
 */

    
    SECTION .isr_vector:DATA:ROOT(2)
    EXTERN DefaultISR
    EXTERN STACK_end   /* Top of Stack for Initial Stack Pointer */
    EXTERN Reset_Handler             /* Reset Handler */
    EXTERN NMI_Handler
    EXTERN HardFault_Handler
    EXTERN MemManage_Handler
    EXTERN BusFault_Handler
    EXTERN UsageFault_Handler
    EXTERN SVC_Handler
    EXTERN DebugMon_Handler
    EXTERN PendSV_Handler
    EXTERN SysTick_Handler
    EXTERN DMA0_IRQHandler
    EXTERN DMA1_IRQHandler
    EXTERN DMA2_IRQHandler
    EXTERN DMA3_IRQHandler
    EXTERN DMA4_IRQHandler
    EXTERN DMA5_IRQHandler
    EXTERN DMA6_IRQHandler
    EXTERN DMA7_IRQHandler
    EXTERN DMA8_IRQHandler
    EXTERN DMA9_IRQHandler
    EXTERN DMA10_IRQHandler
    EXTERN DMA11_IRQHandler
    EXTERN DMA12_IRQHandler
    EXTERN DMA13_IRQHandler
    EXTERN DMA14_IRQHandler
    EXTERN DMA15_IRQHandler
    EXTERN DMA_Error_IRQHandler
    EXTERN FPU_IRQHandler
    EXTERN EFM_IRQHandler
    EXTERN EFM_Error_IRQHandler
    EXTERN PCU_IRQHandler
    EXTERN EFM_Ecc_IRQHandler
    EXTERN Wdg_Mld_Isr
    EXTERN RCU_IRQHandler
    EXTERN I2C0_Master_IRQHandler
    EXTERN I2C0_Slave_IRQHandler
    EXTERN SPI0_IRQHandler
    EXTERN SPI1_IRQHandler
    EXTERN SPI2_IRQHandler
    EXTERN I2C1_Master_IRQHandler
    EXTERN I2C1_Slave_IRQHandler
    EXTERN LINFlexD0_IRQHandler
    EXTERN LINFlexD1_IRQHandler
    EXTERN LINFlexD2_IRQHandler
    EXTERN ADC0_IRQHandler
    EXTERN ADC1_IRQHandler
    EXTERN ACMP0_IRQHandler
    EXTERN EMU_SB_IRQHandler
    EXTERN RTC_IRQHandler
    EXTERN RTC_Seconds_IRQHandler
    EXTERN pTMR_Ch0_IRQHandler
    EXTERN pTMR_Ch1_IRQHandler
    EXTERN pTMR_Ch2_IRQHandler
    EXTERN pTMR_Ch3_IRQHandler
    EXTERN PTU0_IRQHandler
    EXTERN SCU_IRQHandler
    EXTERN lpTMR0_IRQHandler
    EXTERN GPIOA_IRQHandler
    EXTERN GPIOB_IRQHandler
    EXTERN GPIOC_IRQHandler
    EXTERN GPIOD_IRQHandler
    EXTERN GPIOE_IRQHandler
    EXTERN PTU1_IRQHandler
    EXTERN CAN0_ORed_IRQHandler
    EXTERN CAN0_Error_IRQHandler
    EXTERN CAN0_Wake_Up_IRQHandler
    EXTERN CAN0_ORed_0_15_MB_IRQHandler
    EXTERN CAN0_ORed_16_31_MB_IRQHandler
    EXTERN CAN0_ORed_32_47_MB_IRQHandler
    EXTERN CAN0_ORed_48_63_MB_IRQHandler
    EXTERN CAN1_ORed_IRQHandler
    EXTERN CAN1_Error_IRQHandler
    EXTERN CAN1_Wake_Up_IRQHandler
    EXTERN CAN1_ORed_0_15_MB_IRQHandler
    EXTERN CAN1_ORed_16_31_MB_IRQHandler
    EXTERN CAN1_ORed_32_47_MB_IRQHandler
    EXTERN CAN1_ORed_48_63_MB_IRQHandler
    EXTERN CAN2_ORed_IRQHandler
    EXTERN CAN2_Error_IRQHandler
    EXTERN CAN2_Wake_Up_IRQHandler
    EXTERN CAN2_ORed_0_15_MB_IRQHandler
    EXTERN CAN2_ORed_16_31_MB_IRQHandler
    EXTERN CAN2_ORed_32_47_MB_IRQHandler
    EXTERN CAN2_ORed_48_63_MB_IRQHandler
    EXTERN eTMR0_Ch0_Ch1_IRQHandler
    EXTERN eTMR0_Ch2_Ch3_IRQHandler
    EXTERN eTMR0_Ch4_Ch5_IRQHandler
    EXTERN eTMR0_Ch6_Ch7_IRQHandler
    EXTERN eTMR0_Fault_IRQHandler
    EXTERN eTMR0_Ovf_IRQHandler
    EXTERN eTMR1_Ch0_Ch1_IRQHandler
    EXTERN eTMR1_Ch2_Ch3_IRQHandler
    EXTERN eTMR1_Ch4_Ch5_IRQHandler
    EXTERN eTMR1_Ch6_Ch7_IRQHandler
    EXTERN eTMR1_Fault_IRQHandler
    EXTERN eTMR1_Ovf_IRQHandler
    EXTERN eTMR2_Ch0_Ch1_IRQHandler
    EXTERN eTMR2_Ch2_Ch3_IRQHandler
    EXTERN eTMR2_Ch4_Ch5_IRQHandler
    EXTERN eTMR2_Ch6_Ch7_IRQHandler
    EXTERN eTMR2_Fault_IRQHandler
    EXTERN eTMR2_Ovf_IRQHandler
    EXTERN eTMR3_Ch0_Ch1_IRQHandler
    EXTERN eTMR3_Ch2_Ch3_IRQHandler
    EXTERN eTMR3_Ch4_Ch5_IRQHandler
    EXTERN eTMR3_Ch6_Ch7_IRQHandler
    EXTERN eTMR3_Fault_IRQHandler
    EXTERN eTMR3_Ovf_IRQHandler
    EXTERN eTMR4_Ch0_Ch1_IRQHandler
    EXTERN eTMR4_Ch2_Ch3_IRQHandler
    EXTERN eTMR4_Ch4_Ch5_IRQHandler
    EXTERN eTMR4_Ch6_Ch7_IRQHandler
    EXTERN eTMR4_Fault_IRQHandler
    EXTERN eTMR4_Ovf_IRQHandler
    EXTERN eTMR5_Ch0_Ch1_IRQHandler
    EXTERN eTMR5_Ch2_Ch3_IRQHandler
    EXTERN eTMR5_Ch4_Ch5_IRQHandler
    EXTERN eTMR5_Ch6_Ch7_IRQHandler
    EXTERN eTMR5_Fault_IRQHandler
    EXTERN eTMR5_Ovf_IRQHandler
    EXTERN TRNG_IRQHandler
    EXTERN HCU_IRQHandler
    EXTERN INTM_IRQHandler
    EXTERN TMR0_Ch0_IRQHandler
    EXTERN TMR0_Ch1_IRQHandler
    EXTERN TMR0_Ch2_IRQHandler
    EXTERN TMR0_Ch3_IRQHandler
    EXTERN LINFlexD3_IRQHandler
    EXTERN LINFlexD4_IRQHandler
    EXTERN LINFlexD5_IRQHandler
    EXTERN I2C2_Master_IRQHandler
    EXTERN I2C2_Slave_IRQHandler
    EXTERN SPI3_IRQHandler
    EXTERN SPI4_IRQHandler
    EXTERN SPI5_IRQHandler
    EXTERN CAN3_ORed_IRQHandler
    EXTERN CAN3_Error_IRQHandler
    EXTERN CAN3_Wake_Up_IRQHandler
    EXTERN CAN3_ORed_0_15_MB_IRQHandler
    EXTERN CAN3_ORed_16_31_MB_IRQHandler
    EXTERN CAN4_ORed_IRQHandler
    EXTERN CAN4_Error_IRQHandler
    EXTERN CAN4_Wake_Up_IRQHandler
    EXTERN CAN4_ORed_0_15_MB_IRQHandler
    EXTERN CAN4_ORed_16_31_MB_IRQHandler
    EXTERN CAN5_ORed_IRQHandler
    EXTERN CAN5_Error_IRQHandler
    EXTERN CAN5_Wake_Up_IRQHandler
    EXTERN CAN5_ORed_0_15_MB_IRQHandler
    EXTERN CAN5_ORed_16_31_MB_IRQHandler
    EXTERN WKU_IRQHandler

__vector_table

    DCD STACK_end   /* Top of Stack for Initial Stack Pointer */
    DCD Reset_Handler             /* Reset Handler */
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD NMI_Handler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD HardFault_Handler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD MemManage_Handler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD BusFault_Handler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD UsageFault_Handler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD SVC_Handler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DebugMon_Handler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD PendSV_Handler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD SysTick_Handler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA0_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA1_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA2_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA3_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA4_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA5_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA6_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA7_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA8_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA9_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA10_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA11_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA12_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA13_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA14_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA15_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DMA_Error_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD FPU_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD EFM_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD EFM_Error_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD PCU_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD EFM_Ecc_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD Wdg_Mld_Isr
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD RCU_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD I2C0_Master_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD I2C0_Slave_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD SPI0_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD SPI1_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD SPI2_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD I2C1_Master_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD I2C1_Slave_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD LINFlexD0_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD LINFlexD1_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD LINFlexD2_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD ADC0_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD ADC1_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD ACMP0_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD EMU_SB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD RTC_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD RTC_Seconds_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD pTMR_Ch0_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD pTMR_Ch1_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD pTMR_Ch2_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD pTMR_Ch3_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD PTU0_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD SCU_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD lpTMR0_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD GPIOA_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD GPIOB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD GPIOC_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD GPIOD_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD GPIOE_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD PTU1_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN0_ORed_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN0_Error_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN0_Wake_Up_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN0_ORed_0_15_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN0_ORed_16_31_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN0_ORed_32_47_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN0_ORed_48_63_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN1_ORed_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN1_Error_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN1_Wake_Up_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN1_ORed_0_15_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN1_ORed_16_31_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN1_ORed_32_47_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN1_ORed_48_63_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN2_ORed_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN2_Error_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN2_Wake_Up_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN2_ORed_0_15_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN2_ORed_16_31_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN2_ORed_32_47_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN2_ORed_48_63_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR0_Ch0_Ch1_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR0_Ch2_Ch3_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR0_Ch4_Ch5_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR0_Ch6_Ch7_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR0_Fault_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR0_Ovf_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR1_Ch0_Ch1_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR1_Ch2_Ch3_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR1_Ch4_Ch5_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR1_Ch6_Ch7_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR1_Fault_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR1_Ovf_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR2_Ch0_Ch1_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR2_Ch2_Ch3_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR2_Ch4_Ch5_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR2_Ch6_Ch7_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR2_Fault_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR2_Ovf_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR3_Ch0_Ch1_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR3_Ch2_Ch3_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR3_Ch4_Ch5_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR3_Ch6_Ch7_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR3_Fault_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR3_Ovf_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR4_Ch0_Ch1_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR4_Ch2_Ch3_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR4_Ch4_Ch5_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR4_Ch6_Ch7_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR4_Fault_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR4_Ovf_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR5_Ch0_Ch1_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR5_Ch2_Ch3_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR5_Ch4_Ch5_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR5_Ch6_Ch7_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR5_Fault_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD eTMR5_Ovf_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD TRNG_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD HCU_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD INTM_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD TMR0_Ch0_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD TMR0_Ch1_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD TMR0_Ch2_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD TMR0_Ch3_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD LINFlexD3_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD LINFlexD4_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD LINFlexD5_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD I2C2_Master_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD I2C2_Slave_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD SPI3_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD SPI4_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD SPI5_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN3_ORed_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN3_Error_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN3_Wake_Up_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN3_ORed_0_15_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN3_ORed_16_31_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN4_ORed_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN4_Error_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN4_Wake_Up_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN4_ORed_0_15_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN4_ORed_16_31_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD DefaultISR
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN5_ORed_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN5_Error_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN5_Wake_Up_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN5_ORed_0_15_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD CAN5_ORed_16_31_MB_IRQHandler
#endif
#ifdef USING_OS_AUTOSAROS
    DCD DefaultISR
#else
    DCD WKU_IRQHandler
#endif
    END

