/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file undefined
 * @brief 
 * 
 */


#ifndef WDGTST_CFG_H
#define WDGTST_CFG_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
 *                                        INCLUDE FILES
==================================================================================================*/
#include "Std_Types.h"

/*==================================================================================================
 *                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define WDGTST_VENDOR_ID_CFG                      (180)
#define WDGTST_AR_RELEASE_MAJOR_VERSION_CFG       (4)
#define WDGTST_AR_RELEASE_MINOR_VERSION_CFG       (4)
#define WDGTST_AR_RELEASE_REVISION_VERSION_CFG    (0)
#define WDGTST_SW_MAJOR_VERSION_CFG               (2)
#define WDGTST_SW_MINOR_VERSION_CFG               (0)
#define WDGTST_SW_PATCH_VERSION_CFG               (0)

/*==================================================================================================
 *                                        WdgTstPrecompile
==================================================================================================*/
/**
 * @brief   Pre-compile configuration constants.
 */
#define WDGTST_PRECOMPILE_SUPPORT           (STD_ON)

/*==================================================================================================
 *                                          WdgTstConfig
==================================================================================================*/
/**
 * @brief   Switch to enable the WDG test.
 */
#define WDGTST_WDG_ENABLE                   (STD_ON)

/**
 * @brief   Switch to enable the EWDG test.
 */
#define WDGTST_EWDG_ENABLE                  (STD_OFF)

/*==================================================================================================
 *                                          WdgTstGeneral
==================================================================================================*/

/**
 * @brief   Switch to enable the development error detection.
 */
#define WDGTST_DEV_ERROR_DETECT             (STD_ON)

/**
 * @brief   Switch to enable the user mode support.
 */

#ifdef WDGTST_USER_MODE_SUPPORT
#ifndef MCAL_ENABLE_USER_MODE_SUPPORT
#error "Must define MCAL_ENABLE_USER_MODE_SUPPORT if WDGTST_USER_MODE_SUPPORT is defined"
#endif
#endif

/**
 * @brief   Switch to enable the SchM support.
 */
#define WDGTST_SCHM_SUPPORT                 (STD_ON)

/**
 * @brief   Specifies the wdg timeout for the interrupt.
 */
#define WDGTST_WDG_INTERRUPT_TIMEOUT            (9228U)


/**
 * @brief   EWDG clock selection
 */
#define WDGTST_EWDG_HAS_CLKSEL             (STD_ON)

/**
 * @brief   Specifies the InstanceId of this module instance. If only one instance is present it
 *          shall have the Id 0.
 */
#define WDGTST_INDEX                        (0U)

#define WDGTST_ERROR_NOTIFICATION            (STD_ON)

/*==================================================================================================
 *                                     WdgTstConfigApiServices
==================================================================================================*/
/**
 * @brief   Adds / removes the service WdgTst_GetResult() from the code.
 */
#define WDGTST_GET_RESULT_API               (STD_ON)

/**
 * @brief   Adds / removes the service WdgTst_GetVersionInfo() from the code.
 */
#define WDGTST_VERSION_INFO_API             (STD_OFF)

#ifdef __cplusplus
}
#endif

#endif /* WDGTST_CFG_H */


