/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file undefined
 * @brief 
 * 
 */


#ifndef STKTST_CFG_H
#define STKTST_CFG_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
 *                                        INCLUDE FILES
==================================================================================================*/

/*==================================================================================================
 *                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define STKTST_VENDOR_ID_CFG                      (180)
#define STKTST_AR_RELEASE_MAJOR_VERSION_CFG       (4)
#define STKTST_AR_RELEASE_MINOR_VERSION_CFG       (4)
#define STKTST_AR_RELEASE_REVISION_VERSION_CFG    (0)
#define STKTST_SW_MAJOR_VERSION_CFG               (2)
#define STKTST_SW_MINOR_VERSION_CFG               (0)
#define STKTST_SW_PATCH_VERSION_CFG               (0)

/*==================================================================================================
 *                                       DEFINES AND MACROS
==================================================================================================*/

/*==================================================================================================
 *                                        StkTstPrecompile
==================================================================================================*/
/**
 * @brief   Pre-compile configuration constants.
 */
#define STKTST_PRECOMPILE_SUPPORT           (STD_ON)

/*==================================================================================================
 *                                   StkTstDemEventParameterRefs
==================================================================================================*/
/**
 * @brief   Switch to enable the extended production error report.
 */
#define STKTST_DEM_EVENT_REPORT             (STD_OFF)

/*==================================================================================================
 *                                          StkTstGeneral
==================================================================================================*/

/**
 * @brief   Switch to enable the development error detection.
 */
#define STKTST_DEV_ERROR_DETECT             (STD_ON)

/**
 * @brief   Switch to indicate that the notification is supported.
 */
#define STKTST_NOTIFICATION_SUPPORTED       (STD_ON)

/*==================================================================================================
 *                                     StkTstConfigApiServices
==================================================================================================*/
/**
 * @brief   Adds / removes the service StkTst_DeInit() from the code.
 */
#define STKTST_DEINIT_API                   (STD_ON)

/**
 * @brief   Adds / removes the service StkTst_GetResult) from the code.
 */
#define STKTST_GET_RESULT_API               (STD_ON)

/**
 * @brief   Adds / removes the service StkTst_GetVersionInfo() from the code.
 */
#define STKTST_VERSION_INFO_API             (STD_OFF)

/*==================================================================================================
 *                                       FUNCTION PROTOTYPES
==================================================================================================*/

#ifdef __cplusplus
}
#endif

#endif /* STKTST_CFG_H */

/** @} */

