/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file StkTst_Cfg.c
 * @brief 
 * 
 */


#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
 *                                        INCLUDE FILES
==================================================================================================*/
#include "StkTst.h"

/*==================================================================================================
 *                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define STKTST_VENDOR_ID_CFG_C                      (180)
#define STKTST_AR_RELEASE_MAJOR_VERSION_CFG_C       (4)
#define STKTST_AR_RELEASE_MINOR_VERSION_CFG_C       (4)
#define STKTST_AR_RELEASE_REVISION_VERSION_CFG_C    (0)
#define STKTST_SW_MAJOR_VERSION_CFG_C               (2)
#define STKTST_SW_MINOR_VERSION_CFG_C               (0)
#define STKTST_SW_PATCH_VERSION_CFG_C               (0)

/*==================================================================================================
 *                                     FILE VERSION CHECKS
==================================================================================================*/
/* Check if source file and STKTST header file are of the same vendor */
#if (STKTST_VENDOR_ID_CFG_C != STKTST_VENDOR_ID)
#error "EfmTst.c and EfmTst.h have different vendor ids"
#endif

/* Check if source file and STKTST header file are of the same Autosar version */
#if ((STKTST_AR_RELEASE_MAJOR_VERSION_CFG_C != STKTST_AR_RELEASE_MAJOR_VERSION) || \
     (STKTST_AR_RELEASE_MINOR_VERSION_CFG_C != STKTST_AR_RELEASE_MINOR_VERSION) || \
     (STKTST_AR_RELEASE_REVISION_VERSION_CFG_C != STKTST_AR_RELEASE_REVISION_VERSION) \
    )
#error "AutoSar Version Numbers of StkTst_Cfg.c and StkTst.h are different"
#endif

/* Check if source file and STKTST header file are of the same Software version */
#if ((STKTST_SW_MAJOR_VERSION_CFG_C != STKTST_SW_MAJOR_VERSION) || \
     (STKTST_SW_MINOR_VERSION_CFG_C != STKTST_SW_MINOR_VERSION) || \
     (STKTST_SW_PATCH_VERSION_CFG_C != STKTST_SW_PATCH_VERSION) \
    )
#error "Software Version Numbers of StkTst_Cfg.c and StkTst.h are different"
#endif

/*==================================================================================================
 *                                      GLOBAL CONSTANTS
==================================================================================================*/
/**************************StkTst Test Failed Callback declaration********************************************/
extern void SafLib_TestError_Notification(uint16 ModuleId);

#define STKTST_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "StkTst_MemMap.h"

/**
 * @brief   StkTst Configuration
 */
STKTST_CONST const StkTst_ConfigType StkTst_Config =
{
    .BotAddr = 0x2000fc00U,
    .PadValue = 0xDEADBEAFU,
    .DetSize = 16U,
    .OrgSign = 0x7AB6FABCU,
    .OvfCbk = SafLib_TestError_Notification
};

#define STKTST_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "StkTst_MemMap.h"

#ifdef __cplusplus
}
#endif



