/**
* @file    RamTst_Cfg.c
*==================================================================================================
*   Project              : YTMicro AUTOSAR 4.4.0 MCAL
*   Platform             : ARM
*   Peripheral           : RamTst_Cfg
*   Dependencies         : none
*
*   Autosar Version      : V4.4.0
*   Autosar Revision     : ASR_REL_4_4_REV_0000
*   SW Version           : V2.0.0
*
*   (c) Copyright 2020-2025 Yuntu Microelectronics co.,ltd.
*   All Rights Reserved.
==================================================================================================*/

#ifdef __cplusplus
extern "C"
{
#endif

/*==================================================================================================
                                              INCLUDE FILES
==================================================================================================*/
#include "RamTst.h"
/*==================================================================================================
                                      SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define RAMTST_VENDOR_ID_CFG_C                     (180U)
#define RAMTST_AR_REL_MAJOR_VER_CFG_C              (4U)
#define RAMTST_AR_REL_MINOR_VER_CFG_C              (4U)
#define RAMTST_AR_REL_REVISION_VER_CFG_C           (0U)
#define RAMTST_SW_MAJOR_VER_CFG_C                  (2U)
#define RAMTST_SW_MINOR_VER_CFG_C                  (0U)
#define RAMTST_SW_PATCH_VER_CFG_C                  (0U)
/*==================================================================================================
                                            FILE VERSION CHECKS
==================================================================================================*/
/* Check if source file and RAMTST header file are of the same vendor */
#if (RAMTST_VENDOR_ID_CFG_C != RAMTST_VENDOR_ID)
#error "RamTst_Cfg.c and RamTst.h have different vendor ids"
#endif

/* Check if source file and RAMTST header file are of the same Autosar version */
#if (( RAMTST_AR_REL_MAJOR_VER_CFG_C != RAMTST_AR_REL_MAJOR_VER) || \
     ( RAMTST_AR_REL_MINOR_VER_CFG_C != RAMTST_AR_REL_MINOR_VER) || \
     ( RAMTST_AR_REL_REVISION_VER_CFG_C != RAMTST_AR_REL_REVISION_VER))
#error "AutoSar Version Numbers of RamTst_Cfg.c and RamTst.h are different"
#endif

/* Check if source file and RAMTST header file are of the same Software version */
#if (( RAMTST_SW_MAJOR_VER_CFG_C != RAMTST_SW_MAJOR_VER) || \
     ( RAMTST_SW_MINOR_VER_CFG_C != RAMTST_SW_MINOR_VER) || \
     ( RAMTST_SW_PATCH_VER_CFG_C != RAMTST_SW_PATCH_VER))
#error "Software Version Numbers of RamTst_Cfg.c and RamTst.h are different"
#endif

/*==================================================================================================
                                                EXTERNAL FUNCTIONS PROTOTYPES
==================================================================================================*/
/* Notification function for RamTst test completed */
extern void RamTst_CompletedCallback(uint16 ModuleId);

/* Notification function for RamTst test error */
extern void SafLib_TestError_Notification(uint16 ModuleId);

/*==================================================================================================
                                                LOCAL VARIABLES
==================================================================================================*/
#define RAMTST_START_SEC_CONFIG_DATA_UNSPECIFIED
#include "RamTst_MemMap.h"

/**
 * @brief RamTst block configuration
 */
RAMTST_CONST static const RamTst_BlockConfigType RamTstBlockParamsCfg_0[4] =
{
    /** The configuration for Block_1 */
    {
        .RamTstBlockId = 1U,
        .RamTstBlockRegion = BLOCK_REGION_IS_STACK,
        .RamTstEndAddress = 0x2000ffffU,
        .RamTstStartAddress = 0x2000fc00U,
        .RamTstFillPattern = 0U,
        .RamTstPolicy = RAMTST_NON_DESTRUCTIVE,
    },
    /** The configuration for Block_2 */
    {
        .RamTstBlockId = 2U,
        .RamTstBlockRegion = BLOCK_REGION_IS_BACKUP,
        .RamTstEndAddress = 0x2000fbffU,
        .RamTstStartAddress = 0x2000f800U,
        .RamTstFillPattern = 0x5a5a5a5aU,
        .RamTstPolicy = RAMTST_DESTRUCTIVE,
    },
    /** The configuration for Block_3 */
    {
        .RamTstBlockId = 3U,
        .RamTstBlockRegion = BLOCK_REGION_IS_NORMAL,
        .RamTstEndAddress = 0x1fff03ffU,
        .RamTstStartAddress = 0x1fff0000U,
        .RamTstFillPattern = 0U,
        .RamTstPolicy = RAMTST_NON_DESTRUCTIVE,
    },
    /** The configuration for Block_4 */
    {
        .RamTstBlockId = 4U,
        .RamTstBlockRegion = BLOCK_REGION_IS_NORMAL,
        .RamTstEndAddress = 0x2000f6ffU,
        .RamTstStartAddress = 0x1fff0400U,
        .RamTstFillPattern = 0U,
        .RamTstPolicy = RAMTST_NON_DESTRUCTIVE,
    },
};
RAMTST_CONST static const RamTst_BlockConfigType RamTstBlockParamsCfg_1[4] =
{
    /** The configuration for Block_1 */
    {
        .RamTstBlockId = 1U,
        .RamTstBlockRegion = BLOCK_REGION_IS_STACK,
        .RamTstEndAddress = 0x2000ffffU,
        .RamTstStartAddress = 0x2000fc00U,
        .RamTstFillPattern = 0U,
        .RamTstPolicy = RAMTST_NON_DESTRUCTIVE,
    },
    /** The configuration for Block_2 */
    {
        .RamTstBlockId = 2U,
        .RamTstBlockRegion = BLOCK_REGION_IS_BACKUP,
        .RamTstEndAddress = 0x2000fbffU,
        .RamTstStartAddress = 0x2000f800U,
        .RamTstFillPattern = 0x5a5a5a5aU,
        .RamTstPolicy = RAMTST_DESTRUCTIVE,
    },
    /** The configuration for Block_3 */
    {
        .RamTstBlockId = 3U,
        .RamTstBlockRegion = BLOCK_REGION_IS_NORMAL,
        .RamTstEndAddress = 0x1fff03ffU,
        .RamTstStartAddress = 0x1fff0000U,
        .RamTstFillPattern = 0U,
        .RamTstPolicy = RAMTST_NON_DESTRUCTIVE,
    },
    /** The configuration for Block_4 */
    {
        .RamTstBlockId = 4U,
        .RamTstBlockRegion = BLOCK_REGION_IS_NORMAL,
        .RamTstEndAddress = 0x2000f6ffU,
        .RamTstStartAddress = 0x1fff0400U,
        .RamTstFillPattern = 0U,
        .RamTstPolicy = RAMTST_NON_DESTRUCTIVE,
    },
};
RAMTST_CONST static const RamTst_BlockConfigType RamTstBlockParamsCfg_2[4] =
{
    /** The configuration for Block_1 */
    {
        .RamTstBlockId = 1U,
        .RamTstBlockRegion = BLOCK_REGION_IS_STACK,
        .RamTstEndAddress = 0x2000ffffU,
        .RamTstStartAddress = 0x2000fc00U,
        .RamTstFillPattern = 0U,
        .RamTstPolicy = RAMTST_NON_DESTRUCTIVE,
    },
    /** The configuration for Block_2 */
    {
        .RamTstBlockId = 2U,
        .RamTstBlockRegion = BLOCK_REGION_IS_BACKUP,
        .RamTstEndAddress = 0x2000fbffU,
        .RamTstStartAddress = 0x2000f800U,
        .RamTstFillPattern = 0x5a5a5a5aU,
        .RamTstPolicy = RAMTST_DESTRUCTIVE,
    },
    /** The configuration for Block_3 */
    {
        .RamTstBlockId = 3U,
        .RamTstBlockRegion = BLOCK_REGION_IS_NORMAL,
        .RamTstEndAddress = 0x1fff03ffU,
        .RamTstStartAddress = 0x1fff0000U,
        .RamTstFillPattern = 0U,
        .RamTstPolicy = RAMTST_NON_DESTRUCTIVE,
    },
    /** The configuration for Block_4 */
    {
        .RamTstBlockId = 4U,
        .RamTstBlockRegion = BLOCK_REGION_IS_NORMAL,
        .RamTstEndAddress = 0x2000f6ffU,
        .RamTstStartAddress = 0x1fff0400U,
        .RamTstFillPattern = 0U,
        .RamTstPolicy = RAMTST_NON_DESTRUCTIVE,
    },
};
RAMTST_CONST static const RamTst_BlockConfigType RamTstBlockParamsCfg_3[4] =
{
    /** The configuration for Block_1 */
    {
        .RamTstBlockId = 1U,
        .RamTstBlockRegion = BLOCK_REGION_IS_STACK,
        .RamTstEndAddress = 0x2000ffffU,
        .RamTstStartAddress = 0x2000fc00U,
        .RamTstFillPattern = 0U,
        .RamTstPolicy = RAMTST_NON_DESTRUCTIVE,
    },
    /** The configuration for Block_2 */
    {
        .RamTstBlockId = 2U,
        .RamTstBlockRegion = BLOCK_REGION_IS_BACKUP,
        .RamTstEndAddress = 0x2000fbffU,
        .RamTstStartAddress = 0x2000f800U,
        .RamTstFillPattern = 0x5a5a5a5aU,
        .RamTstPolicy = RAMTST_DESTRUCTIVE,
    },
    /** The configuration for Block_3 */
    {
        .RamTstBlockId = 3U,
        .RamTstBlockRegion = BLOCK_REGION_IS_NORMAL,
        .RamTstEndAddress = 0x1fff03ffU,
        .RamTstStartAddress = 0x1fff0000U,
        .RamTstFillPattern = 0U,
        .RamTstPolicy = RAMTST_NON_DESTRUCTIVE,
    },
    /** The configuration for Block_4 */
    {
        .RamTstBlockId = 4U,
        .RamTstBlockRegion = BLOCK_REGION_IS_NORMAL,
        .RamTstEndAddress = 0x2000f6ffU,
        .RamTstStartAddress = 0x1fff0400U,
        .RamTstFillPattern = 0U,
        .RamTstPolicy = RAMTST_NON_DESTRUCTIVE,
    },
};

/**
 * @brief RamTst algorithm configuration
 */
RAMTST_CONST static const RamTst_AlgConfigType RamTstAlgParamsCfg[4] =
{
    /** The configuration for Algorithm_1 */
    {
        .RamTstAlgParamsId = 1U,
        .RamTstAlgorithm = RAMTST_CHECKERBOARD_TEST,
        .RamTstExtNumberOfTestedCells = 256U,
        .RamTstMaxNumberOfTestedCells = 256U,
        .RamTstNumberOfTestedCells = 20U,
        .RamTstNumberOfBlocks = 4U,
        .RamTstBackupStartAddress = 0x2000f800U,
        .RamTstBackupEndAddress = 0x2000fbffU,
        .RamTstBlockParamsPtr = RamTstBlockParamsCfg_0,
    },
    /** The configuration for Algorithm_2 */
    {
        .RamTstAlgParamsId = 2U,
        .RamTstAlgorithm = RAMTST_MARCH_TEST,
        .RamTstExtNumberOfTestedCells = 256U,
        .RamTstMaxNumberOfTestedCells = 256U,
        .RamTstNumberOfTestedCells = 20U,
        .RamTstNumberOfBlocks = 4U,
        .RamTstBackupStartAddress = 0x2000f800U,
        .RamTstBackupEndAddress = 0x2000fbffU,
        .RamTstBlockParamsPtr = RamTstBlockParamsCfg_1,
    },
    /** The configuration for Algorithm_3 */
    {
        .RamTstAlgParamsId = 3U,
        .RamTstAlgorithm = RAMTST_WALK_PATH_TEST,
        .RamTstExtNumberOfTestedCells = 256U,
        .RamTstMaxNumberOfTestedCells = 256U,
        .RamTstNumberOfTestedCells = 20U,
        .RamTstNumberOfBlocks = 4U,
        .RamTstBackupStartAddress = 0x2000f800U,
        .RamTstBackupEndAddress = 0x2000fbffU,
        .RamTstBlockParamsPtr = RamTstBlockParamsCfg_2,
    },
    /** The configuration for Algorithm_4 */
    {
        .RamTstAlgParamsId = 4U,
        .RamTstAlgorithm = RAMTST_GALPAT_TEST,
        .RamTstExtNumberOfTestedCells = 256U,
        .RamTstMaxNumberOfTestedCells = 256U,
        .RamTstNumberOfTestedCells = 20U,
        .RamTstNumberOfBlocks = 4U,
        .RamTstBackupStartAddress = 0x2000f800U,
        .RamTstBackupEndAddress = 0x2000fbffU,
        .RamTstBlockParamsPtr = RamTstBlockParamsCfg_3,
    },
};

/*==================================================================================================
                                                GLOBAL VARIABLES
==================================================================================================*/
/**
 * @brief RamTst configuration
 */
RAMTST_CONST const RamTst_ConfigType RamTst_Config =
{
    .RamTstAlgConfigPtr = RamTstAlgParamsCfg,
    .RamTstDefaultAlgParamsId = 1U,
    .RamTstMinNumberOfTestedCells = 1U,
    .RamTstNumberOfAlgParamSets = 4U,
    .RamTstCompletedNotification = RamTst_CompletedCallback,
    .RamTstErrorNotification = SafLib_TestError_Notification,
};

#define RAMTST_STOP_SEC_CONFIG_DATA_UNSPECIFIED
#include "RamTst_MemMap.h"

#ifdef __cplusplus
}
#endif

/* End of file RamTst_Cfg.c */
