/*
 * Copyright 2020-2025 Yuntu Microelectronics Co., Ltd.
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * 
 * @file PpuTst_Cfg.h
 * @brief 
 * 
 */


#ifndef PPUTST_CFG_H
#define PPUTST_CFG_H

#ifdef __cplusplus
extern "C" {
#endif

/*==================================================================================================
*                                        INCLUDE FILES
==================================================================================================*/

/*==================================================================================================
*                              SOURCE FILE VERSION INFORMATION
==================================================================================================*/
#define PPUTST_VENDOR_ID_CFG                      (180)
#define PPUTST_AR_RELEASE_MAJOR_VERSION_CFG       (4)
#define PPUTST_AR_RELEASE_MINOR_VERSION_CFG       (4)
#define PPUTST_AR_RELEASE_REVISION_VERSION_CFG    (0)
#define PPUTST_SW_MAJOR_VERSION_CFG               (2)
#define PPUTST_SW_MINOR_VERSION_CFG               (0)
#define PPUTST_SW_PATCH_VERSION_CFG               (0)

/*==================================================================================================
 *                          LOCAL TYPEDEFS (STRUCTURES, UNIONS, ENUMS)
==================================================================================================*/

/*==================================================================================================
*                                       DEFINITIONS AND MACROS
==================================================================================================*/
/**
 * @brief          The count of the PPU protection IPs
 * @sw_type        sw_detail
 */
#define PPUTST_GROUP_COUNT                        (0X6U)

/**
 * @brief          The definition to configure the PPU TST driver error detection enablement
 * @sw_type        sw_arch
 */
#define PPUTST_DEV_ERROR_DETECT                    (STD_ON)

/**
 * @brief          The definition to configure the PpuTst_GetVersionInfo API enablement
 * @sw_type        sw_arch
 */
#define PPUTST_VERSION_INFO_API                    (STD_OFF)

/**
 * @brief          The definition to configure the error notification support
 * @sw_type        sw_arch
 */
#define PPUTST_ERR_NOTIFICATION_SUPPORT            (STD_ON)


#ifdef PPUTST_ENABLE_USER_MODE_SUPPORT
#ifndef MCAL_ENABLE_USER_MODE_SUPPORT
#error "Must define MCAL_ENABLE_USER_MODE_SUPPORT if PPUTST_ENABLE_USER_MODE_SUPPORT is defined"
#endif
#endif

#ifdef __cplusplus
}
#endif

#endif /* End of file PpuTst_Cfg.h*/
